#!/usr/bin/env bash

if [ -z "$BASH_SOURCE" ]; then
    # If not running bash, try to obtain directory with $0
    BASEDIR="$( cd "$(dirname "$0")"; pwd -P )"
else
    BASEDIR=$(dirname ${BASH_SOURCE[0]})
fi
command -v realpath &> /dev/null && BASEDIR=$(realpath ${BASEDIR}/../..) || BASEDIR=$(cd ${BASEDIR}/../.. && pwd)

if [ ! -d "${BASEDIR}" ]; then
    echo "${BASEDIR} does not exist"
    return 1
fi

rocprofiler_systems_ROOT=${BASEDIR}
PATH=${BASEDIR}/bin:${PATH}
PATH=${BASEDIR}/libexec/rocprofiler-systems:${PATH}
LD_LIBRARY_PATH=${BASEDIR}/lib:${LD_LIBRARY_PATH}
PYTHONPATH=${BASEDIR}/lib/python/site-packages:${PYTHONPATH}
CMAKE_PREFIX_PATH=${BASEDIR}:${CMAKE_PREFIX_PATH}
rocprofiler_systems_DIR=${BASEDIR}/share/cmake/rocprofiler-systems

export rocprofiler_systems_ROOT
export PATH
export LD_LIBRARY_PATH
export PYTHONPATH
export CMAKE_PREFIX_PATH
export rocprofiler_systems_DIR
