
get_filename_component(FULL_FILE_PATH ${CMAKE_CURRENT_LIST_FILE} REALPATH)
get_filename_component(CTEST_CURRENT_DIR ${FULL_FILE_PATH} DIRECTORY)
get_filename_component(EXE_PATH ${CTEST_CURRENT_DIR}/.. REALPATH)

set(LIB_PATH ${EXE_PATH}/../../../lib)
file(GLOB HIP_LIBS "${LIB_PATH}/libamdhip64*")
if(HIP_LIBS)
    set(LIB_PATH ${LIB_PATH} ${LIB_PATH}/rocm_sysdeps/lib)
else()
    set(LIB_PATH "/opt/rocm/lib")
endif()
 
# File has been updated by hip-tests/catch folder for portability
if(EXISTS "HipSpecificTest")
  if(NOT EXISTS "HipSpecificTest-b12d07c_tests.cmake" OR
     NOT "HipSpecificTest-b12d07c_tests.cmake" IS_NEWER_THAN "HipSpecificTest" OR
     NOT "HipSpecificTest-b12d07c_tests.cmake" IS_NEWER_THAN "${CMAKE_CURRENT_LIST_FILE}")
    include("${CTEST_CURRENT_DIR}/CatchAddTests.cmake")
    catch_discover_tests_impl(
      TEST_EXECUTABLE  ${EXE_PATH}/HipSpecificTest
      TEST_EXECUTOR [==[]==]
      TEST_WORKING_DIR  ${EXE_PATH}
      TEST_SPEC [==[]==]
      TEST_EXTRA_ARGS [==[]==]
      TEST_PROPERTIES [==[SKIP_REGULAR_EXPRESSION;HIP_SKIP_THIS_TEST;SKIP_RETURN_CODE;4]==]
      TEST_PREFIX [==[]==]
      TEST_SUFFIX [==[]==]
      TEST_LIST [==[HipSpecificTest_TESTS]==]
      TEST_REPORTER [==[]==]
      TEST_OUTPUT_DIR [==[]==]
      TEST_OUTPUT_PREFIX [==[]==]
      TEST_OUTPUT_SUFFIX [==[]==]
      CTEST_FILE ${CTEST_CURRENT_DIR}/HipSpecificTest-b12d07c_tests.cmake
      TEST_DL_PATHS  ${LIB_PATH}
      TEST_DL_FRAMEWORK_PATHS [==[]==]
      ADD_TAGS_AS_LABELS [==[FALSE]==]
    )
  endif()
  include("${CTEST_CURRENT_DIR}/HipSpecificTest-b12d07c_tests.cmake")
else()
  add_test(HipSpecificTest_NOT_BUILT HipSpecificTest_NOT_BUILT)
endif()
