
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was openmp-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Partial path copied from build variable OPENMP_INSTALL_LIBDIR
set( openmp_LIB_DIR "lib" )

# Full path to libomp.so using PACKAGE_PREFIX_DIR and OPENMP_INSTALL_LIBDIR partial path.
set_and_check( openmp_LIB_INSTALL_DIR "${PACKAGE_PREFIX_DIR}/lib" )

# Full path to omp.h using PACKAGE_PREFIX and LIBOMP_HEADERS_INSTALL_PATH partial path.
set_and_check( openmp_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/lib/clang/22/include" )
set_and_check( openmp_INCLUDE_DIRS "${openmp_INCLUDE_DIR}" )

set( libomp_install_rpath "$ORIGIN:$ORIGIN/../lib:$ORIGIN/../../lib:$ORIGIN/../../../lib" )
include( "${CMAKE_CURRENT_LIST_DIR}/openmpTargets.cmake" )

set_property(TARGET OpenMP::omp APPEND PROPERTY
    INTERFACE_COMPILE_OPTIONS "-fopenmp"
)
set_property(TARGET OpenMP::omp APPEND PROPERTY
    INTERFACE_LINK_OPTIONS "-fopenmp"
)

if(libomp_install_rpath)
  set_property(TARGET OpenMP::omp APPEND PROPERTY
      INTERFACE_LINK_OPTIONS "-fno-openmp-implicit-rpath"
  )
endif()
