/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: XeGPUTransformOps.td                                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::transform::ConvertLayoutOp,
::mlir::transform::GetDescOp,
::mlir::transform::InsertPrefetchOp,
::mlir::transform::SetDescLayoutOp,
::mlir::transform::SetGPULaunchThreadsOp,
::mlir::transform::SetOpLayoutAttrOp
#endif // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//


static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPUTransformOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::transform::TransformValueHandleTypeInterface>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TransformValueHandleTypeInterface instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPUTransformOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::transform::TransformHandleTypeInterface>(type))) || ((::llvm::isa<::mlir::transform::TransformParamTypeInterface>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of transform any param type or any handle type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPUTransformOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::transform::TransformHandleTypeInterface>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TransformHandleTypeInterface instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPUTransformOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::transform::TransformHandleTypeInterface>(type))) || ((::llvm::isa<::mlir::transform::TransformParamTypeInterface>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be transform any param type or any handle type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: i64 dense array attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(64)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPUTransformOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPUTransformOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPUTransformOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::ConvertLayoutOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

ConvertLayoutOpGenericAdaptorBase::ConvertLayoutOpGenericAdaptorBase(ConvertLayoutOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> ConvertLayoutOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticInputSgLayoutAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_sg_layout);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticInputSgLayout() {
  auto attr = getStaticInputSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticInputSgDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_sg_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticInputSgData() {
  auto attr = getStaticInputSgDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticInputInstDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_input_inst_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticInputInstData() {
  auto attr = getStaticInputInstDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticTargetSgLayoutAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_sg_layout);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticTargetSgLayout() {
  auto attr = getStaticTargetSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticTargetSgDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_sg_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticTargetSgData() {
  auto attr = getStaticTargetSgDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr ConvertLayoutOpGenericAdaptorBase::getStaticTargetInstDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_target_inst_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOpGenericAdaptorBase::getStaticTargetInstData() {
  auto attr = getStaticTargetInstDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}


} // namespace detail
ConvertLayoutOpAdaptor::ConvertLayoutOpAdaptor(ConvertLayoutOp op) : ConvertLayoutOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ConvertLayoutOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_static_input_inst_data = getProperties().static_input_inst_data; (void)tblgen_static_input_inst_data;
  auto tblgen_static_input_sg_data = getProperties().static_input_sg_data; (void)tblgen_static_input_sg_data;
  auto tblgen_static_input_sg_layout = getProperties().static_input_sg_layout; (void)tblgen_static_input_sg_layout;
  auto tblgen_static_target_inst_data = getProperties().static_target_inst_data; (void)tblgen_static_target_inst_data;
  auto tblgen_static_target_sg_data = getProperties().static_target_sg_data; (void)tblgen_static_target_sg_data;
  auto tblgen_static_target_sg_layout = getProperties().static_target_sg_layout; (void)tblgen_static_target_sg_layout;

  if (tblgen_static_input_sg_layout && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_input_sg_layout))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_input_sg_layout' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_input_sg_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_input_sg_data))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_input_sg_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_input_inst_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_input_inst_data))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_input_inst_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_target_sg_layout && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_target_sg_layout))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_target_sg_layout' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_target_sg_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_target_sg_data))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_target_sg_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_target_inst_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_target_inst_data))))
    return emitError(loc, "'transform.xegpu.convert_layout' op attribute 'static_target_inst_data' failed to satisfy constraint: i64 dense array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ConvertLayoutOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange ConvertLayoutOp::getInputSgLayoutMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ConvertLayoutOp::getInputSgDataMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ConvertLayoutOp::getInputInstDataMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ConvertLayoutOp::getTargetSgLayoutMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ConvertLayoutOp::getTargetSgDataMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ConvertLayoutOp::getTargetInstDataMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult ConvertLayoutOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.static_input_inst_data;
       auto attr = dict.get("static_input_inst_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_input_inst_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_input_sg_data;
       auto attr = dict.get("static_input_sg_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_input_sg_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_input_sg_layout;
       auto attr = dict.get("static_input_sg_layout");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_input_sg_layout` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_target_inst_data;
       auto attr = dict.get("static_target_inst_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_target_inst_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_target_sg_data;
       auto attr = dict.get("static_target_sg_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_target_sg_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_target_sg_layout;
       auto attr = dict.get("static_target_sg_layout");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_target_sg_layout` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute ConvertLayoutOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.static_input_inst_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_input_inst_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_input_sg_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_input_sg_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_input_sg_layout;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_input_sg_layout",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_target_inst_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_target_inst_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_target_sg_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_target_sg_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_target_sg_layout;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_target_sg_layout",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ConvertLayoutOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes_ = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.static_input_inst_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_input_sg_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_input_sg_layout.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_target_inst_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_target_sg_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_target_sg_layout.getAsOpaquePointer()), 
    hash_operandSegmentSizes_(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> ConvertLayoutOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "static_input_inst_data")
      return prop.static_input_inst_data;

    if (name == "static_input_sg_data")
      return prop.static_input_sg_data;

    if (name == "static_input_sg_layout")
      return prop.static_input_sg_layout;

    if (name == "static_target_inst_data")
      return prop.static_target_inst_data;

    if (name == "static_target_sg_data")
      return prop.static_target_sg_data;

    if (name == "static_target_sg_layout")
      return prop.static_target_sg_layout;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void ConvertLayoutOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "static_input_inst_data") {
       prop.static_input_inst_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_input_inst_data)>>(value);
       return;
    }

    if (name == "static_input_sg_data") {
       prop.static_input_sg_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_input_sg_data)>>(value);
       return;
    }

    if (name == "static_input_sg_layout") {
       prop.static_input_sg_layout = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_input_sg_layout)>>(value);
       return;
    }

    if (name == "static_target_inst_data") {
       prop.static_target_inst_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_target_inst_data)>>(value);
       return;
    }

    if (name == "static_target_sg_data") {
       prop.static_target_sg_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_target_sg_data)>>(value);
       return;
    }

    if (name == "static_target_sg_layout") {
       prop.static_target_sg_layout = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_target_sg_layout)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void ConvertLayoutOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.static_input_inst_data) attrs.append("static_input_inst_data", prop.static_input_inst_data);

    if (prop.static_input_sg_data) attrs.append("static_input_sg_data", prop.static_input_sg_data);

    if (prop.static_input_sg_layout) attrs.append("static_input_sg_layout", prop.static_input_sg_layout);

    if (prop.static_target_inst_data) attrs.append("static_target_inst_data", prop.static_target_inst_data);

    if (prop.static_target_sg_data) attrs.append("static_target_sg_data", prop.static_target_sg_data);

    if (prop.static_target_sg_layout) attrs.append("static_target_sg_layout", prop.static_target_sg_layout);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult ConvertLayoutOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getStaticInputInstDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_input_inst_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticInputSgDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_input_sg_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticInputSgLayoutAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_input_sg_layout", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticTargetInstDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_target_inst_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticTargetSgDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_target_sg_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticTargetSgLayoutAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_target_sg_layout", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ConvertLayoutOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_input_inst_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_input_sg_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_input_sg_layout)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_target_inst_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_target_sg_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_target_sg_layout)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ConvertLayoutOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.static_input_inst_data);

  writer.writeOptionalAttribute(prop.static_input_sg_data);

  writer.writeOptionalAttribute(prop.static_input_sg_layout);

  writer.writeOptionalAttribute(prop.static_target_inst_data);

  writer.writeOptionalAttribute(prop.static_target_sg_data);

  writer.writeOptionalAttribute(prop.static_target_sg_layout);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticInputSgLayout() {
  auto attr = getStaticInputSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticInputSgData() {
  auto attr = getStaticInputSgDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticInputInstData() {
  auto attr = getStaticInputInstDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticTargetSgLayout() {
  auto attr = getStaticTargetSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticTargetSgData() {
  auto attr = getStaticTargetSgDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> ConvertLayoutOp::getStaticTargetInstData() {
  auto attr = getStaticTargetInstDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

void ConvertLayoutOp::setStaticInputSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_input_sg_layout;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void ConvertLayoutOp::setStaticInputSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_input_sg_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void ConvertLayoutOp::setStaticInputInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_input_inst_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void ConvertLayoutOp::setStaticTargetSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_target_sg_layout;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void ConvertLayoutOp::setStaticTargetSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_target_sg_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void ConvertLayoutOp::setStaticTargetInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_target_inst_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedInputSgLayout, ArrayRef<OpFoldResult> mixedInputSgData, ArrayRef<OpFoldResult> mixedInputInstData, ArrayRef<OpFoldResult> mixedTargetSgLayout, ArrayRef<OpFoldResult> mixedTargetSgData, ArrayRef<OpFoldResult> mixedTargetInstData) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, mixedInputSgLayout, mixedInputSgData, mixedInputInstData, mixedTargetSgLayout, mixedTargetSgData, mixedTargetInstData);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedInputSgLayout, ArrayRef<OpFoldResult> mixedInputSgData, ArrayRef<OpFoldResult> mixedInputInstData, ArrayRef<OpFoldResult> mixedTargetSgLayout, ArrayRef<OpFoldResult> mixedTargetSgData, ArrayRef<OpFoldResult> mixedTargetInstData) {
  return create(builder, builder.getLoc(), target, mixedInputSgLayout, mixedInputSgData, mixedInputInstData, mixedTargetSgLayout, mixedTargetSgData, mixedTargetInstData);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  odsState.addOperands(target);
  odsState.addOperands(input_sg_layout);
  odsState.addOperands(input_sg_data);
  odsState.addOperands(input_inst_data);
  odsState.addOperands(target_sg_layout);
  odsState.addOperands(target_sg_data);
  odsState.addOperands(target_inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(input_sg_layout.size()), static_cast<int32_t>(input_sg_data.size()), static_cast<int32_t>(input_inst_data.size()), static_cast<int32_t>(target_sg_layout.size()), static_cast<int32_t>(target_sg_data.size()), static_cast<int32_t>(target_inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (static_input_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_input_sg_layout = static_input_sg_layout;
  }
  if (static_input_sg_data) {
    odsState.getOrAddProperties<Properties>().static_input_sg_data = static_input_sg_data;
  }
  if (static_input_inst_data) {
    odsState.getOrAddProperties<Properties>().static_input_inst_data = static_input_inst_data;
  }
  if (static_target_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_target_sg_layout = static_target_sg_layout;
  }
  if (static_target_sg_data) {
    odsState.getOrAddProperties<Properties>().static_target_sg_data = static_target_sg_data;
  }
  if (static_target_inst_data) {
    odsState.getOrAddProperties<Properties>().static_target_inst_data = static_target_inst_data;
  }
  odsState.addTypes(newConvertOp);
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, newConvertOp, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  return create(builder, builder.getLoc(), newConvertOp, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  odsState.addOperands(target);
  odsState.addOperands(input_sg_layout);
  odsState.addOperands(input_sg_data);
  odsState.addOperands(input_inst_data);
  odsState.addOperands(target_sg_layout);
  odsState.addOperands(target_sg_data);
  odsState.addOperands(target_inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(input_sg_layout.size()), static_cast<int32_t>(input_sg_data.size()), static_cast<int32_t>(input_inst_data.size()), static_cast<int32_t>(target_sg_layout.size()), static_cast<int32_t>(target_sg_data.size()), static_cast<int32_t>(target_inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (static_input_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_input_sg_layout = static_input_sg_layout;
  }
  if (static_input_sg_data) {
    odsState.getOrAddProperties<Properties>().static_input_sg_data = static_input_sg_data;
  }
  if (static_input_inst_data) {
    odsState.getOrAddProperties<Properties>().static_input_inst_data = static_input_inst_data;
  }
  if (static_target_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_target_sg_layout = static_target_sg_layout;
  }
  if (static_target_sg_data) {
    odsState.getOrAddProperties<Properties>().static_target_sg_data = static_target_sg_data;
  }
  if (static_target_inst_data) {
    odsState.getOrAddProperties<Properties>().static_target_inst_data = static_target_inst_data;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_input_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_input_inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_target_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_target_inst_data) {
  return create(builder, builder.getLoc(), resultTypes, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  odsState.addOperands(target);
  odsState.addOperands(input_sg_layout);
  odsState.addOperands(input_sg_data);
  odsState.addOperands(input_inst_data);
  odsState.addOperands(target_sg_layout);
  odsState.addOperands(target_sg_data);
  odsState.addOperands(target_inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(input_sg_layout.size()), static_cast<int32_t>(input_sg_data.size()), static_cast<int32_t>(input_inst_data.size()), static_cast<int32_t>(target_sg_layout.size()), static_cast<int32_t>(target_sg_data.size()), static_cast<int32_t>(target_inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().static_input_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_input_sg_layout);
  odsState.getOrAddProperties<Properties>().static_input_sg_data = odsBuilder.getDenseI64ArrayAttr(static_input_sg_data);
  odsState.getOrAddProperties<Properties>().static_input_inst_data = odsBuilder.getDenseI64ArrayAttr(static_input_inst_data);
  odsState.getOrAddProperties<Properties>().static_target_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_target_sg_layout);
  odsState.getOrAddProperties<Properties>().static_target_sg_data = odsBuilder.getDenseI64ArrayAttr(static_target_sg_data);
  odsState.getOrAddProperties<Properties>().static_target_inst_data = odsBuilder.getDenseI64ArrayAttr(static_target_inst_data);
  odsState.addTypes(newConvertOp);
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, newConvertOp, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type newConvertOp, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  return create(builder, builder.getLoc(), newConvertOp, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  odsState.addOperands(target);
  odsState.addOperands(input_sg_layout);
  odsState.addOperands(input_sg_data);
  odsState.addOperands(input_inst_data);
  odsState.addOperands(target_sg_layout);
  odsState.addOperands(target_sg_data);
  odsState.addOperands(target_inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(input_sg_layout.size()), static_cast<int32_t>(input_sg_data.size()), static_cast<int32_t>(input_inst_data.size()), static_cast<int32_t>(target_sg_layout.size()), static_cast<int32_t>(target_sg_data.size()), static_cast<int32_t>(target_inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().static_input_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_input_sg_layout);
  odsState.getOrAddProperties<Properties>().static_input_sg_data = odsBuilder.getDenseI64ArrayAttr(static_input_sg_data);
  odsState.getOrAddProperties<Properties>().static_input_inst_data = odsBuilder.getDenseI64ArrayAttr(static_input_inst_data);
  odsState.getOrAddProperties<Properties>().static_target_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_target_sg_layout);
  odsState.getOrAddProperties<Properties>().static_target_sg_data = odsBuilder.getDenseI64ArrayAttr(static_target_sg_data);
  odsState.getOrAddProperties<Properties>().static_target_inst_data = odsBuilder.getDenseI64ArrayAttr(static_target_inst_data);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange input_sg_layout, ::mlir::ValueRange input_sg_data, ::mlir::ValueRange input_inst_data, ::mlir::ValueRange target_sg_layout, ::mlir::ValueRange target_sg_data, ::mlir::ValueRange target_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_input_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_input_inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_target_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_target_inst_data) {
  return create(builder, builder.getLoc(), resultTypes, target, input_sg_layout, input_sg_data, input_inst_data, target_sg_layout, target_sg_data, target_inst_data, static_input_sg_layout, static_input_sg_data, static_input_inst_data, static_target_sg_layout, static_target_sg_data, static_target_inst_data);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ConvertLayoutOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ConvertLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ConvertLayoutOp ConvertLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ConvertLayoutOp::verifyInvariantsImpl() {
  auto tblgen_static_input_inst_data = getProperties().static_input_inst_data; (void)tblgen_static_input_inst_data;
  auto tblgen_static_input_sg_data = getProperties().static_input_sg_data; (void)tblgen_static_input_sg_data;
  auto tblgen_static_input_sg_layout = getProperties().static_input_sg_layout; (void)tblgen_static_input_sg_layout;
  auto tblgen_static_target_inst_data = getProperties().static_target_inst_data; (void)tblgen_static_target_inst_data;
  auto tblgen_static_target_sg_data = getProperties().static_target_sg_data; (void)tblgen_static_target_sg_data;
  auto tblgen_static_target_sg_layout = getProperties().static_target_sg_layout; (void)tblgen_static_target_sg_layout;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_input_sg_layout, "static_input_sg_layout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_input_sg_data, "static_input_sg_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_input_inst_data, "static_input_inst_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_target_sg_layout, "static_target_sg_layout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_target_sg_data, "static_target_sg_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_target_inst_data, "static_target_inst_data")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ConvertLayoutOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ConvertLayoutOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> input_sg_layoutOperands;
  ::llvm::SMLoc input_sg_layoutOperandsLoc;
  (void)input_sg_layoutOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_input_sg_layoutAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> input_sg_dataOperands;
  ::llvm::SMLoc input_sg_dataOperandsLoc;
  (void)input_sg_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_input_sg_dataAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> input_inst_dataOperands;
  ::llvm::SMLoc input_inst_dataOperandsLoc;
  (void)input_inst_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_input_inst_dataAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> target_sg_layoutOperands;
  ::llvm::SMLoc target_sg_layoutOperandsLoc;
  (void)target_sg_layoutOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_target_sg_layoutAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> target_sg_dataOperands;
  ::llvm::SMLoc target_sg_dataOperandsLoc;
  (void)target_sg_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_target_sg_dataAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> target_inst_dataOperands;
  ::llvm::SMLoc target_inst_dataOperandsLoc;
  (void)target_inst_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_target_inst_dataAttr;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("input_sg_layout"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    input_sg_layoutOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, input_sg_layoutOperands, static_input_sg_layoutAttr);
    if (odsResult) return ::mlir::failure();
    if (static_input_sg_layoutAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_input_sg_layout = static_input_sg_layoutAttr;
  }
  if (parser.parseKeyword("input_sg_data"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    input_sg_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, input_sg_dataOperands, static_input_sg_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_input_sg_dataAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_input_sg_data = static_input_sg_dataAttr;
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("input_inst_data"))) {
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    input_inst_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, input_inst_dataOperands, static_input_inst_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_input_inst_dataAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_input_inst_data = static_input_inst_dataAttr;
  }
  }
  if (parser.parseKeyword("target_sg_layout"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    target_sg_layoutOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, target_sg_layoutOperands, static_target_sg_layoutAttr);
    if (odsResult) return ::mlir::failure();
    if (static_target_sg_layoutAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_target_sg_layout = static_target_sg_layoutAttr;
  }
  if (parser.parseKeyword("target_sg_data"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    target_sg_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, target_sg_dataOperands, static_target_sg_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_target_sg_dataAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_target_sg_data = static_target_sg_dataAttr;
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("target_inst_data"))) {
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    target_inst_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, target_inst_dataOperands, static_target_inst_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_target_inst_dataAttr)
      result.getOrAddProperties<ConvertLayoutOp::Properties>().static_target_inst_data = static_target_inst_dataAttr;
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(input_sg_layoutOperands.size()), static_cast<int32_t>(input_sg_dataOperands.size()), static_cast<int32_t>(input_inst_dataOperands.size()), static_cast<int32_t>(target_sg_layoutOperands.size()), static_cast<int32_t>(target_sg_dataOperands.size()), static_cast<int32_t>(target_inst_dataOperands.size())}), result.getOrAddProperties<ConvertLayoutOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(targetOperands, input_sg_layoutOperands, input_sg_dataOperands, input_inst_dataOperands, target_sg_layoutOperands, target_sg_dataOperands, target_inst_dataOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ConvertLayoutOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  _odsPrinter << ' ' << "input_sg_layout";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getInputSgLayout(), getStaticInputSgLayoutAttr());
  _odsPrinter << ' ' << "input_sg_data";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getInputSgData(), getStaticInputSgDataAttr());
  if (((!getInputInstData().empty()) || ((getStaticInputInstDataAttr() && getStaticInputInstDataAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))))) {
    _odsPrinter << ' ' << "input_inst_data";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getInputInstData(), getStaticInputInstDataAttr());
  }
  _odsPrinter << ' ' << "target_sg_layout";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getTargetSgLayout(), getStaticTargetSgLayoutAttr());
  _odsPrinter << ' ' << "target_sg_data";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getTargetSgData(), getStaticTargetSgDataAttr());
  if (((!getTargetInstData().empty()) || ((getStaticTargetInstDataAttr() && getStaticTargetInstDataAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))))) {
    _odsPrinter << ' ' << "target_inst_data";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getTargetInstData(), getStaticTargetInstDataAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("static_input_sg_layout");
  elidedAttrs.push_back("static_input_sg_data");
  elidedAttrs.push_back("static_input_inst_data");
  elidedAttrs.push_back("static_target_sg_layout");
  elidedAttrs.push_back("static_target_sg_data");
  elidedAttrs.push_back("static_target_inst_data");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticInputSgLayoutAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_input_sg_layout");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticInputSgDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_input_sg_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticInputInstDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_input_inst_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticTargetSgLayoutAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_target_sg_layout");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticTargetSgDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_target_sg_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticTargetInstDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_target_inst_data");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::ConvertLayoutOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::GetDescOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

GetDescOpGenericAdaptorBase::GetDescOpGenericAdaptorBase(GetDescOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}


} // namespace detail
GetDescOpAdaptor::GetDescOpAdaptor(GetDescOp op) : GetDescOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult GetDescOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult GetDescOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute GetDescOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GetDescOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> GetDescOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void GetDescOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void GetDescOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult GetDescOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void GetDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type descHandle, ::mlir::Value target) {
  odsState.addOperands(target);
  odsState.addTypes(descHandle);
}

GetDescOp GetDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type descHandle, ::mlir::Value target) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, descHandle, target);
  auto __res__ = ::llvm::dyn_cast<GetDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GetDescOp GetDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type descHandle, ::mlir::Value target) {
  return create(builder, builder.getLoc(), descHandle, target);
}

void GetDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target) {
  odsState.addOperands(target);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GetDescOp GetDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target);
  auto __res__ = ::llvm::dyn_cast<GetDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GetDescOp GetDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target) {
  return create(builder, builder.getLoc(), resultTypes, target);
}

void GetDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GetDescOp GetDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<GetDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GetDescOp GetDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void GetDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GetDescOp GetDescOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<GetDescOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GetDescOp GetDescOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult GetDescOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult GetDescOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GetDescOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(targetOperands, allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void GetDescOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::GetDescOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::InsertPrefetchOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

InsertPrefetchOpGenericAdaptorBase::InsertPrefetchOpGenericAdaptorBase(InsertPrefetchOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> InsertPrefetchOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::IntegerAttr InsertPrefetchOpGenericAdaptorBase::getStaticNbPrefetchAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().static_nb_prefetch);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getIntegerAttr(::mlir::Builder(odsAttrs.getContext()).getIntegerType(64), 1);
  return attr;
}

uint64_t InsertPrefetchOpGenericAdaptorBase::getStaticNbPrefetch() {
  auto attr = getStaticNbPrefetchAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getIntegerAttr(::mlir::Builder(odsAttrs.getContext()).getIntegerType(64), 1).getValue().getZExtValue();
  return attr.getValue().getZExtValue();
}


} // namespace detail
InsertPrefetchOpAdaptor::InsertPrefetchOpAdaptor(InsertPrefetchOp op) : InsertPrefetchOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult InsertPrefetchOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_static_nb_prefetch = getProperties().static_nb_prefetch; (void)tblgen_static_nb_prefetch;

  if (tblgen_static_nb_prefetch && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_static_nb_prefetch))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_static_nb_prefetch).getType().isSignlessInteger(64)))))
    return emitError(loc, "'transform.xegpu.insert_prefetch' op attribute 'static_nb_prefetch' failed to satisfy constraint: 64-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> InsertPrefetchOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange InsertPrefetchOp::getDynamicNbPrefetchMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult InsertPrefetchOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.static_nb_prefetch;
       auto attr = dict.get("static_nb_prefetch");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_nb_prefetch` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute InsertPrefetchOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.static_nb_prefetch;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_nb_prefetch",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InsertPrefetchOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.static_nb_prefetch.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> InsertPrefetchOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "static_nb_prefetch")
      return prop.static_nb_prefetch;
  return std::nullopt;
}

void InsertPrefetchOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "static_nb_prefetch") {
       prop.static_nb_prefetch = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_nb_prefetch)>>(value);
       return;
    }
}

void InsertPrefetchOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.static_nb_prefetch) attrs.append("static_nb_prefetch", prop.static_nb_prefetch);
}

::llvm::LogicalResult InsertPrefetchOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getStaticNbPrefetchAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps2(attr, "static_nb_prefetch", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult InsertPrefetchOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.static_nb_prefetch)))
    return ::mlir::failure();
  return ::mlir::success();
}

void InsertPrefetchOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.static_nb_prefetch);
}

uint64_t InsertPrefetchOp::getStaticNbPrefetch() {
  auto attr = getStaticNbPrefetchAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), 1).getValue().getZExtValue();
  return attr.getValue().getZExtValue();
}

void InsertPrefetchOp::setStaticNbPrefetch(::std::optional<uint64_t> attrValue) {
    auto &odsProp = getProperties().static_nb_prefetch;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), *attrValue);
    else
      odsProp = nullptr;
}

void InsertPrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  odsState.addOperands(target);
  if (dynamic_nb_prefetch)
    odsState.addOperands(dynamic_nb_prefetch);
  if (static_nb_prefetch) {
    odsState.getOrAddProperties<Properties>().static_nb_prefetch = static_nb_prefetch;
  }
  odsState.addTypes(desc_op);
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc_op, target, dynamic_nb_prefetch, static_nb_prefetch);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  return create(builder, builder.getLoc(), desc_op, target, dynamic_nb_prefetch, static_nb_prefetch);
}

void InsertPrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  odsState.addOperands(target);
  if (dynamic_nb_prefetch)
    odsState.addOperands(dynamic_nb_prefetch);
  if (static_nb_prefetch) {
    odsState.getOrAddProperties<Properties>().static_nb_prefetch = static_nb_prefetch;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, dynamic_nb_prefetch, static_nb_prefetch);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/::mlir::IntegerAttr static_nb_prefetch) {
  return create(builder, builder.getLoc(), resultTypes, target, dynamic_nb_prefetch, static_nb_prefetch);
}

void InsertPrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  odsState.addOperands(target);
  if (dynamic_nb_prefetch)
    odsState.addOperands(dynamic_nb_prefetch);
  odsState.getOrAddProperties<Properties>().static_nb_prefetch = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), static_nb_prefetch);
  odsState.addTypes(desc_op);
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, desc_op, target, dynamic_nb_prefetch, static_nb_prefetch);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type desc_op, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  return create(builder, builder.getLoc(), desc_op, target, dynamic_nb_prefetch, static_nb_prefetch);
}

void InsertPrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  odsState.addOperands(target);
  if (dynamic_nb_prefetch)
    odsState.addOperands(dynamic_nb_prefetch);
  odsState.getOrAddProperties<Properties>().static_nb_prefetch = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), static_nb_prefetch);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, dynamic_nb_prefetch, static_nb_prefetch);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::Value dynamic_nb_prefetch, /*optional*/uint64_t static_nb_prefetch) {
  return create(builder, builder.getLoc(), resultTypes, target, dynamic_nb_prefetch, static_nb_prefetch);
}

void InsertPrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<InsertPrefetchOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void InsertPrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<InsertPrefetchOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InsertPrefetchOp InsertPrefetchOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult InsertPrefetchOp::verifyInvariantsImpl() {
  auto tblgen_static_nb_prefetch = getProperties().static_nb_prefetch; (void)tblgen_static_nb_prefetch;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps2(*this, tblgen_static_nb_prefetch, "static_nb_prefetch")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult InsertPrefetchOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult InsertPrefetchOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dynamic_nb_prefetchOperands;
  ::llvm::SMLoc dynamic_nb_prefetchOperandsLoc;
  (void)dynamic_nb_prefetchOperandsLoc;
  ::mlir::IntegerAttr static_nb_prefetchAttr;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("nb_prefetch"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  {
    dynamic_nb_prefetchOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      dynamic_nb_prefetchOperands.push_back(operand);
    }
  }
  if (!dynamic_nb_prefetchOperands.empty()) {
  } else {

  if (parser.parseCustomAttributeWithFallback(static_nb_prefetchAttr, parser.getBuilder().getIntegerType(64))) {
    return ::mlir::failure();
  }
  if (static_nb_prefetchAttr) result.getOrAddProperties<InsertPrefetchOp::Properties>().static_nb_prefetch = static_nb_prefetchAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(targetOperands, dynamic_nb_prefetchOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InsertPrefetchOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  _odsPrinter << ' ' << "nb_prefetch";
  _odsPrinter << ' ' << "=";
  if (getDynamicNbPrefetch()) {
    _odsPrinter << ' ';
    if (::mlir::Value value = getDynamicNbPrefetch())
      _odsPrinter << value;
  } else {
    _odsPrinter << ' ';
    _odsPrinter.printAttributeWithoutType(getStaticNbPrefetchAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("static_nb_prefetch");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticNbPrefetchAttr();
     if(attr && (attr == odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), 1)))
       elidedAttrs.push_back("static_nb_prefetch");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::InsertPrefetchOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetDescLayoutOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

SetDescLayoutOpGenericAdaptorBase::SetDescLayoutOpGenericAdaptorBase(SetDescLayoutOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> SetDescLayoutOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DenseI64ArrayAttr SetDescLayoutOpGenericAdaptorBase::getStaticSgLayoutAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_layout);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOpGenericAdaptorBase::getStaticSgLayout() {
  auto attr = getStaticSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetDescLayoutOpGenericAdaptorBase::getStaticSgDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOpGenericAdaptorBase::getStaticSgData() {
  auto attr = getStaticSgDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetDescLayoutOpGenericAdaptorBase::getStaticInstDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_inst_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOpGenericAdaptorBase::getStaticInstData() {
  auto attr = getStaticInstDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetDescLayoutOpGenericAdaptorBase::getSliceDimsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().slice_dims);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOpGenericAdaptorBase::getSliceDims() {
  auto attr = getSliceDimsAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}


} // namespace detail
SetDescLayoutOpAdaptor::SetDescLayoutOpAdaptor(SetDescLayoutOp op) : SetDescLayoutOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SetDescLayoutOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_slice_dims = getProperties().slice_dims; (void)tblgen_slice_dims;
  auto tblgen_static_inst_data = getProperties().static_inst_data; (void)tblgen_static_inst_data;
  auto tblgen_static_sg_data = getProperties().static_sg_data; (void)tblgen_static_sg_data;
  auto tblgen_static_sg_layout = getProperties().static_sg_layout; (void)tblgen_static_sg_layout;

  if (tblgen_static_sg_layout && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_sg_layout))))
    return emitError(loc, "'transform.xegpu.set_desc_layout' op attribute 'static_sg_layout' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_sg_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_sg_data))))
    return emitError(loc, "'transform.xegpu.set_desc_layout' op attribute 'static_sg_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_inst_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_inst_data))))
    return emitError(loc, "'transform.xegpu.set_desc_layout' op attribute 'static_inst_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_slice_dims && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_slice_dims))))
    return emitError(loc, "'transform.xegpu.set_desc_layout' op attribute 'slice_dims' failed to satisfy constraint: i64 dense array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SetDescLayoutOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange SetDescLayoutOp::getSgLayoutMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SetDescLayoutOp::getSgDataMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SetDescLayoutOp::getInstDataMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult SetDescLayoutOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.slice_dims;
       auto attr = dict.get("slice_dims");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `slice_dims` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_inst_data;
       auto attr = dict.get("static_inst_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_inst_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_sg_data;
       auto attr = dict.get("static_sg_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_sg_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_sg_layout;
       auto attr = dict.get("static_sg_layout");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_sg_layout` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute SetDescLayoutOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.slice_dims;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("slice_dims",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_inst_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_inst_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_sg_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_sg_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_sg_layout;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_sg_layout",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SetDescLayoutOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes_ = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.slice_dims.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_inst_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_sg_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_sg_layout.getAsOpaquePointer()), 
    hash_operandSegmentSizes_(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> SetDescLayoutOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "slice_dims")
      return prop.slice_dims;

    if (name == "static_inst_data")
      return prop.static_inst_data;

    if (name == "static_sg_data")
      return prop.static_sg_data;

    if (name == "static_sg_layout")
      return prop.static_sg_layout;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void SetDescLayoutOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "slice_dims") {
       prop.slice_dims = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.slice_dims)>>(value);
       return;
    }

    if (name == "static_inst_data") {
       prop.static_inst_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_inst_data)>>(value);
       return;
    }

    if (name == "static_sg_data") {
       prop.static_sg_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_sg_data)>>(value);
       return;
    }

    if (name == "static_sg_layout") {
       prop.static_sg_layout = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_sg_layout)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void SetDescLayoutOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.slice_dims) attrs.append("slice_dims", prop.slice_dims);

    if (prop.static_inst_data) attrs.append("static_inst_data", prop.static_inst_data);

    if (prop.static_sg_data) attrs.append("static_sg_data", prop.static_sg_data);

    if (prop.static_sg_layout) attrs.append("static_sg_layout", prop.static_sg_layout);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult SetDescLayoutOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getSliceDimsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "slice_dims", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticInstDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_inst_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticSgDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_sg_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticSgLayoutAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_sg_layout", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SetDescLayoutOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.slice_dims)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_inst_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_sg_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_sg_layout)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void SetDescLayoutOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.slice_dims);

  writer.writeOptionalAttribute(prop.static_inst_data);

  writer.writeOptionalAttribute(prop.static_sg_data);

  writer.writeOptionalAttribute(prop.static_sg_layout);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::llvm::ArrayRef<int64_t> SetDescLayoutOp::getStaticSgLayout() {
  auto attr = getStaticSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOp::getStaticSgData() {
  auto attr = getStaticSgDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOp::getStaticInstData() {
  auto attr = getStaticInstDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetDescLayoutOp::getSliceDims() {
  auto attr = getSliceDimsAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

void SetDescLayoutOp::setStaticSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_sg_layout;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetDescLayoutOp::setStaticSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_sg_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetDescLayoutOp::setStaticInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_inst_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetDescLayoutOp::setSliceDims(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().slice_dims;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, mixedSgLayout, mixedSgData, mixedInstData, sliceDims);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims) {
  return create(builder, builder.getLoc(), target, mixedSgLayout, mixedSgData, mixedInstData, sliceDims);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (static_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_sg_layout = static_sg_layout;
  }
  if (static_sg_data) {
    odsState.getOrAddProperties<Properties>().static_sg_data = static_sg_data;
  }
  if (static_inst_data) {
    odsState.getOrAddProperties<Properties>().static_inst_data = static_inst_data;
  }
  if (slice_dims) {
    odsState.getOrAddProperties<Properties>().slice_dims = slice_dims;
  }
  odsState.addTypes(transformed);
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, transformed, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  return create(builder, builder.getLoc(), transformed, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (static_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_sg_layout = static_sg_layout;
  }
  if (static_sg_data) {
    odsState.getOrAddProperties<Properties>().static_sg_data = static_sg_data;
  }
  if (static_inst_data) {
    odsState.getOrAddProperties<Properties>().static_inst_data = static_inst_data;
  }
  if (slice_dims) {
    odsState.getOrAddProperties<Properties>().slice_dims = slice_dims;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims) {
  return create(builder, builder.getLoc(), resultTypes, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().static_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_sg_layout);
  odsState.getOrAddProperties<Properties>().static_sg_data = odsBuilder.getDenseI64ArrayAttr(static_sg_data);
  odsState.getOrAddProperties<Properties>().static_inst_data = odsBuilder.getDenseI64ArrayAttr(static_inst_data);
  odsState.getOrAddProperties<Properties>().slice_dims = odsBuilder.getDenseI64ArrayAttr(slice_dims);
  odsState.addTypes(transformed);
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, transformed, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  return create(builder, builder.getLoc(), transformed, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().static_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_sg_layout);
  odsState.getOrAddProperties<Properties>().static_sg_data = odsBuilder.getDenseI64ArrayAttr(static_sg_data);
  odsState.getOrAddProperties<Properties>().static_inst_data = odsBuilder.getDenseI64ArrayAttr(static_inst_data);
  odsState.getOrAddProperties<Properties>().slice_dims = odsBuilder.getDenseI64ArrayAttr(slice_dims);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims) {
  return create(builder, builder.getLoc(), resultTypes, target, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SetDescLayoutOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SetDescLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SetDescLayoutOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetDescLayoutOp SetDescLayoutOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SetDescLayoutOp::verifyInvariantsImpl() {
  auto tblgen_slice_dims = getProperties().slice_dims; (void)tblgen_slice_dims;
  auto tblgen_static_inst_data = getProperties().static_inst_data; (void)tblgen_static_inst_data;
  auto tblgen_static_sg_data = getProperties().static_sg_data; (void)tblgen_static_sg_data;
  auto tblgen_static_sg_layout = getProperties().static_sg_layout; (void)tblgen_static_sg_layout;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_sg_layout, "static_sg_layout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_sg_data, "static_sg_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_inst_data, "static_inst_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_slice_dims, "slice_dims")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SetDescLayoutOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SetDescLayoutOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> sg_layoutOperands;
  ::llvm::SMLoc sg_layoutOperandsLoc;
  (void)sg_layoutOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_sg_layoutAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> sg_dataOperands;
  ::llvm::SMLoc sg_dataOperandsLoc;
  (void)sg_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_sg_dataAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> inst_dataOperands;
  ::llvm::SMLoc inst_dataOperandsLoc;
  (void)inst_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_inst_dataAttr;
  ::mlir::DenseI64ArrayAttr slice_dimsAttr;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("sg_layout"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    sg_layoutOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, sg_layoutOperands, static_sg_layoutAttr);
    if (odsResult) return ::mlir::failure();
    if (static_sg_layoutAttr)
      result.getOrAddProperties<SetDescLayoutOp::Properties>().static_sg_layout = static_sg_layoutAttr;
  }
  if (parser.parseKeyword("sg_data"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    sg_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, sg_dataOperands, static_sg_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_sg_dataAttr)
      result.getOrAddProperties<SetDescLayoutOp::Properties>().static_sg_data = static_sg_dataAttr;
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("inst_data"))) {
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    inst_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, inst_dataOperands, static_inst_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_inst_dataAttr)
      result.getOrAddProperties<SetDescLayoutOp::Properties>().static_inst_data = static_inst_dataAttr;
  }
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("slice_dims"))) {
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(slice_dimsAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (slice_dimsAttr) result.getOrAddProperties<SetDescLayoutOp::Properties>().slice_dims = slice_dimsAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layoutOperands.size()), static_cast<int32_t>(sg_dataOperands.size()), static_cast<int32_t>(inst_dataOperands.size())}), result.getOrAddProperties<SetDescLayoutOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(targetOperands, sg_layoutOperands, sg_dataOperands, inst_dataOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SetDescLayoutOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  _odsPrinter << ' ' << "sg_layout";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getSgLayout(), getStaticSgLayoutAttr());
  _odsPrinter << ' ' << "sg_data";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getSgData(), getStaticSgDataAttr());
  if (((!getInstData().empty()) || ((getStaticInstDataAttr() && getStaticInstDataAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))))) {
    _odsPrinter << ' ' << "inst_data";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getInstData(), getStaticInstDataAttr());
  }
  if ((getSliceDimsAttr() && getSliceDimsAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))) {
    _odsPrinter << ' ' << "slice_dims";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getSliceDimsAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("static_sg_layout");
  elidedAttrs.push_back("static_sg_data");
  elidedAttrs.push_back("static_inst_data");
  elidedAttrs.push_back("slice_dims");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticSgLayoutAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_sg_layout");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticSgDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_sg_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticInstDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_inst_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getSliceDimsAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("slice_dims");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::SetDescLayoutOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetGPULaunchThreadsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

SetGPULaunchThreadsOpGenericAdaptorBase::SetGPULaunchThreadsOpGenericAdaptorBase(SetGPULaunchThreadsOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> SetGPULaunchThreadsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DenseI64ArrayAttr SetGPULaunchThreadsOpGenericAdaptorBase::getStaticThreadsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_threads);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetGPULaunchThreadsOpGenericAdaptorBase::getStaticThreads() {
  auto attr = getStaticThreadsAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}


} // namespace detail
SetGPULaunchThreadsOpAdaptor::SetGPULaunchThreadsOpAdaptor(SetGPULaunchThreadsOp op) : SetGPULaunchThreadsOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SetGPULaunchThreadsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_static_threads = getProperties().static_threads; (void)tblgen_static_threads;

  if (tblgen_static_threads && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_threads))))
    return emitError(loc, "'transform.xegpu.set_gpu_launch_threads' op attribute 'static_threads' failed to satisfy constraint: i64 dense array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SetGPULaunchThreadsOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange SetGPULaunchThreadsOp::getThreadsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult SetGPULaunchThreadsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.static_threads;
       auto attr = dict.get("static_threads");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_threads` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute SetGPULaunchThreadsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.static_threads;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_threads",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SetGPULaunchThreadsOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.static_threads.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> SetGPULaunchThreadsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "static_threads")
      return prop.static_threads;
  return std::nullopt;
}

void SetGPULaunchThreadsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "static_threads") {
       prop.static_threads = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_threads)>>(value);
       return;
    }
}

void SetGPULaunchThreadsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.static_threads) attrs.append("static_threads", prop.static_threads);
}

::llvm::LogicalResult SetGPULaunchThreadsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getStaticThreadsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_threads", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SetGPULaunchThreadsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.static_threads)))
    return ::mlir::failure();
  return ::mlir::success();
}

void SetGPULaunchThreadsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.static_threads);
}

::llvm::ArrayRef<int64_t> SetGPULaunchThreadsOp::getStaticThreads() {
  auto attr = getStaticThreadsAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

void SetGPULaunchThreadsOp::setStaticThreads(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_threads;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, ArrayRef<OpFoldResult> mixedThreads) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, mixedThreads);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, Value target, ArrayRef<OpFoldResult> mixedThreads) {
  return create(builder, builder.getLoc(), target, mixedThreads);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  odsState.addOperands(target);
  odsState.addOperands(threads);
  if (static_threads) {
    odsState.getOrAddProperties<Properties>().static_threads = static_threads;
  }
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, threads, static_threads);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  return create(builder, builder.getLoc(), target, threads, static_threads);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  odsState.addOperands(target);
  odsState.addOperands(threads);
  if (static_threads) {
    odsState.getOrAddProperties<Properties>().static_threads = static_threads;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, threads, static_threads);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::mlir::DenseI64ArrayAttr static_threads) {
  return create(builder, builder.getLoc(), resultTypes, target, threads, static_threads);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  odsState.addOperands(target);
  odsState.addOperands(threads);
  odsState.getOrAddProperties<Properties>().static_threads = odsBuilder.getDenseI64ArrayAttr(static_threads);
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, threads, static_threads);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  return create(builder, builder.getLoc(), target, threads, static_threads);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  odsState.addOperands(target);
  odsState.addOperands(threads);
  odsState.getOrAddProperties<Properties>().static_threads = odsBuilder.getDenseI64ArrayAttr(static_threads);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, threads, static_threads);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, ::mlir::ValueRange threads, /*optional*/::llvm::ArrayRef<int64_t> static_threads) {
  return create(builder, builder.getLoc(), resultTypes, target, threads, static_threads);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SetGPULaunchThreadsOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SetGPULaunchThreadsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SetGPULaunchThreadsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetGPULaunchThreadsOp SetGPULaunchThreadsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SetGPULaunchThreadsOp::verifyInvariantsImpl() {
  auto tblgen_static_threads = getProperties().static_threads; (void)tblgen_static_threads;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_threads, "static_threads")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SetGPULaunchThreadsOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SetGPULaunchThreadsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> threadsOperands;
  ::llvm::SMLoc threadsOperandsLoc;
  (void)threadsOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_threadsAttr;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  if (parser.parseKeyword("threads"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    threadsOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, threadsOperands, static_threadsAttr);
    if (odsResult) return ::mlir::failure();
    if (static_threadsAttr)
      result.getOrAddProperties<SetGPULaunchThreadsOp::Properties>().static_threads = static_threadsAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(targetOperands, threadsOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SetGPULaunchThreadsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  _odsPrinter << ' ' << "threads";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getThreads(), getStaticThreadsAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("static_threads");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticThreadsAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_threads");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperandTypes();
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::SetGPULaunchThreadsOp)

namespace mlir::transform {


//===----------------------------------------------------------------------===//
// ::mlir::transform::SetOpLayoutAttrOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

SetOpLayoutAttrOpGenericAdaptorBase::SetOpLayoutAttrOpGenericAdaptorBase(SetOpLayoutAttrOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> SetOpLayoutAttrOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::IntegerAttr SetOpLayoutAttrOpGenericAdaptorBase::getIndexAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().index);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getIntegerAttr(::mlir::Builder(odsAttrs.getContext()).getIntegerType(64), 0);
  return attr;
}

uint64_t SetOpLayoutAttrOpGenericAdaptorBase::getIndex() {
  auto attr = getIndexAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getIntegerAttr(::mlir::Builder(odsAttrs.getContext()).getIntegerType(64), 0).getValue().getZExtValue();
  return attr.getValue().getZExtValue();
}

::mlir::DenseI64ArrayAttr SetOpLayoutAttrOpGenericAdaptorBase::getStaticSgLayoutAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_layout);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOpGenericAdaptorBase::getStaticSgLayout() {
  auto attr = getStaticSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetOpLayoutAttrOpGenericAdaptorBase::getStaticSgDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_sg_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOpGenericAdaptorBase::getStaticSgData() {
  auto attr = getStaticSgDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetOpLayoutAttrOpGenericAdaptorBase::getStaticInstDataAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().static_inst_data);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOpGenericAdaptorBase::getStaticInstData() {
  auto attr = getStaticInstDataAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::DenseI64ArrayAttr SetOpLayoutAttrOpGenericAdaptorBase::getSliceDimsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().slice_dims);
  if (!attr)
    attr = ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOpGenericAdaptorBase::getSliceDims() {
  auto attr = getSliceDimsAttr();
    if (!attr)
      return ::mlir::Builder(odsAttrs.getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::mlir::UnitAttr SetOpLayoutAttrOpGenericAdaptorBase::getResultAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().result);
  return attr;
}

bool SetOpLayoutAttrOpGenericAdaptorBase::getResult() {
  auto attr = getResultAttr();
  return attr != nullptr;
}


} // namespace detail
SetOpLayoutAttrOpAdaptor::SetOpLayoutAttrOpAdaptor(SetOpLayoutAttrOp op) : SetOpLayoutAttrOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SetOpLayoutAttrOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_index = getProperties().index; (void)tblgen_index;
  auto tblgen_result = getProperties().result; (void)tblgen_result;
  auto tblgen_slice_dims = getProperties().slice_dims; (void)tblgen_slice_dims;
  auto tblgen_static_inst_data = getProperties().static_inst_data; (void)tblgen_static_inst_data;
  auto tblgen_static_sg_data = getProperties().static_sg_data; (void)tblgen_static_sg_data;
  auto tblgen_static_sg_layout = getProperties().static_sg_layout; (void)tblgen_static_sg_layout;

  if (tblgen_index && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_index))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_index).getType().isSignlessInteger(64)))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'index' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_static_sg_layout && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_sg_layout))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'static_sg_layout' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_sg_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_sg_data))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'static_sg_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_static_inst_data && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_static_inst_data))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'static_inst_data' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_slice_dims && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_slice_dims))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'slice_dims' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_result && !((::llvm::isa<::mlir::UnitAttr>(tblgen_result))))
    return emitError(loc, "'transform.xegpu.set_op_layout_attr' op attribute 'result' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SetOpLayoutAttrOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange SetOpLayoutAttrOp::getSgLayoutMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SetOpLayoutAttrOp::getSgDataMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SetOpLayoutAttrOp::getInstDataMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult SetOpLayoutAttrOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.index;
       auto attr = dict.get("index");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `index` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.result;
       auto attr = dict.get("result");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `result` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.slice_dims;
       auto attr = dict.get("slice_dims");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `slice_dims` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_inst_data;
       auto attr = dict.get("static_inst_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_inst_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_sg_data;
       auto attr = dict.get("static_sg_data");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_sg_data` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.static_sg_layout;
       auto attr = dict.get("static_sg_layout");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `static_sg_layout` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute SetOpLayoutAttrOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.index;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("index",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.result;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("result",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.slice_dims;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("slice_dims",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_inst_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_inst_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_sg_data;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_sg_data",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.static_sg_layout;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("static_sg_layout",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SetOpLayoutAttrOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes_ = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.index.getAsOpaquePointer()), 
    llvm::hash_value(prop.result.getAsOpaquePointer()), 
    llvm::hash_value(prop.slice_dims.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_inst_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_sg_data.getAsOpaquePointer()), 
    llvm::hash_value(prop.static_sg_layout.getAsOpaquePointer()), 
    hash_operandSegmentSizes_(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> SetOpLayoutAttrOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "index")
      return prop.index;

    if (name == "result")
      return prop.result;

    if (name == "slice_dims")
      return prop.slice_dims;

    if (name == "static_inst_data")
      return prop.static_inst_data;

    if (name == "static_sg_data")
      return prop.static_sg_data;

    if (name == "static_sg_layout")
      return prop.static_sg_layout;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void SetOpLayoutAttrOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "index") {
       prop.index = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.index)>>(value);
       return;
    }

    if (name == "result") {
       prop.result = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.result)>>(value);
       return;
    }

    if (name == "slice_dims") {
       prop.slice_dims = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.slice_dims)>>(value);
       return;
    }

    if (name == "static_inst_data") {
       prop.static_inst_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_inst_data)>>(value);
       return;
    }

    if (name == "static_sg_data") {
       prop.static_sg_data = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_sg_data)>>(value);
       return;
    }

    if (name == "static_sg_layout") {
       prop.static_sg_layout = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.static_sg_layout)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void SetOpLayoutAttrOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.index) attrs.append("index", prop.index);

    if (prop.result) attrs.append("result", prop.result);

    if (prop.slice_dims) attrs.append("slice_dims", prop.slice_dims);

    if (prop.static_inst_data) attrs.append("static_inst_data", prop.static_inst_data);

    if (prop.static_sg_data) attrs.append("static_sg_data", prop.static_sg_data);

    if (prop.static_sg_layout) attrs.append("static_sg_layout", prop.static_sg_layout);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult SetOpLayoutAttrOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIndexAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps2(attr, "index", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getResultAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps3(attr, "result", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSliceDimsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "slice_dims", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticInstDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_inst_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticSgDataAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_sg_data", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStaticSgLayoutAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(attr, "static_sg_layout", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult SetOpLayoutAttrOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.index)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  if (::mlir::failed(reader.readOptionalAttribute(prop.result)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.slice_dims)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_inst_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_sg_data)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.static_sg_layout)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void SetOpLayoutAttrOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.index);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  writer.writeOptionalAttribute(prop.result);

  writer.writeOptionalAttribute(prop.slice_dims);

  writer.writeOptionalAttribute(prop.static_inst_data);

  writer.writeOptionalAttribute(prop.static_sg_data);

  writer.writeOptionalAttribute(prop.static_sg_layout);

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

uint64_t SetOpLayoutAttrOp::getIndex() {
  auto attr = getIndexAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), 0).getValue().getZExtValue();
  return attr.getValue().getZExtValue();
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOp::getStaticSgLayout() {
  auto attr = getStaticSgLayoutAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOp::getStaticSgData() {
  auto attr = getStaticSgDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOp::getStaticInstData() {
  auto attr = getStaticInstDataAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

::llvm::ArrayRef<int64_t> SetOpLayoutAttrOp::getSliceDims() {
  auto attr = getSliceDimsAttr();
    if (!attr)
      return ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr({});
  return attr;
}

bool SetOpLayoutAttrOp::getResult() {
  auto attr = getResultAttr();
  return attr != nullptr;
}

void SetOpLayoutAttrOp::setIndex(::std::optional<uint64_t> attrValue) {
    auto &odsProp = getProperties().index;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), *attrValue);
    else
      odsProp = nullptr;
}

void SetOpLayoutAttrOp::setStaticSgLayout(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_sg_layout;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetOpLayoutAttrOp::setStaticSgData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_sg_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetOpLayoutAttrOp::setStaticInstData(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().static_inst_data;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetOpLayoutAttrOp::setSliceDims(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().slice_dims;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void SetOpLayoutAttrOp::setResult(bool attrValue) {
  getProperties().result = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Value target, int64_t index, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims, bool result) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, index, mixedSgLayout, mixedSgData, mixedInstData, sliceDims, result);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, Value target, int64_t index, ArrayRef<OpFoldResult> mixedSgLayout, ArrayRef<OpFoldResult> mixedSgData, ArrayRef<OpFoldResult> mixedInstData, ArrayRef<int64_t> sliceDims, bool result) {
  return create(builder, builder.getLoc(), target, index, mixedSgLayout, mixedSgData, mixedInstData, sliceDims, result);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (index) {
    odsState.getOrAddProperties<Properties>().index = index;
  }
  if (static_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_sg_layout = static_sg_layout;
  }
  if (static_sg_data) {
    odsState.getOrAddProperties<Properties>().static_sg_data = static_sg_data;
  }
  if (static_inst_data) {
    odsState.getOrAddProperties<Properties>().static_inst_data = static_inst_data;
  }
  if (slice_dims) {
    odsState.getOrAddProperties<Properties>().slice_dims = slice_dims;
  }
  if (result) {
    odsState.getOrAddProperties<Properties>().result = result;
  }
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  return create(builder, builder.getLoc(), target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (index) {
    odsState.getOrAddProperties<Properties>().index = index;
  }
  if (static_sg_layout) {
    odsState.getOrAddProperties<Properties>().static_sg_layout = static_sg_layout;
  }
  if (static_sg_data) {
    odsState.getOrAddProperties<Properties>().static_sg_data = static_sg_data;
  }
  if (static_inst_data) {
    odsState.getOrAddProperties<Properties>().static_inst_data = static_inst_data;
  }
  if (slice_dims) {
    odsState.getOrAddProperties<Properties>().slice_dims = slice_dims;
  }
  if (result) {
    odsState.getOrAddProperties<Properties>().result = result;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/::mlir::IntegerAttr index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::mlir::DenseI64ArrayAttr static_sg_layout, /*optional*/::mlir::DenseI64ArrayAttr static_sg_data, /*optional*/::mlir::DenseI64ArrayAttr static_inst_data, /*optional*/::mlir::DenseI64ArrayAttr slice_dims, ::mlir::UnitAttr result) {
  return create(builder, builder.getLoc(), resultTypes, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().index = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), index);
  odsState.getOrAddProperties<Properties>().static_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_sg_layout);
  odsState.getOrAddProperties<Properties>().static_sg_data = odsBuilder.getDenseI64ArrayAttr(static_sg_data);
  odsState.getOrAddProperties<Properties>().static_inst_data = odsBuilder.getDenseI64ArrayAttr(static_inst_data);
  odsState.getOrAddProperties<Properties>().slice_dims = odsBuilder.getDenseI64ArrayAttr(slice_dims);
  if (result) {
    odsState.getOrAddProperties<Properties>().result = ((result) ? odsBuilder.getUnitAttr() : nullptr);
  }
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  return create(builder, builder.getLoc(), target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  odsState.addOperands(target);
  odsState.addOperands(sg_layout);
  odsState.addOperands(sg_data);
  odsState.addOperands(inst_data);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layout.size()), static_cast<int32_t>(sg_data.size()), static_cast<int32_t>(inst_data.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().index = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), index);
  odsState.getOrAddProperties<Properties>().static_sg_layout = odsBuilder.getDenseI64ArrayAttr(static_sg_layout);
  odsState.getOrAddProperties<Properties>().static_sg_data = odsBuilder.getDenseI64ArrayAttr(static_sg_data);
  odsState.getOrAddProperties<Properties>().static_inst_data = odsBuilder.getDenseI64ArrayAttr(static_inst_data);
  odsState.getOrAddProperties<Properties>().slice_dims = odsBuilder.getDenseI64ArrayAttr(slice_dims);
  if (result) {
    odsState.getOrAddProperties<Properties>().result = ((result) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value target, /*optional*/uint64_t index, ::mlir::ValueRange sg_layout, ::mlir::ValueRange sg_data, ::mlir::ValueRange inst_data, /*optional*/::llvm::ArrayRef<int64_t> static_sg_layout, /*optional*/::llvm::ArrayRef<int64_t> static_sg_data, /*optional*/::llvm::ArrayRef<int64_t> static_inst_data, /*optional*/::llvm::ArrayRef<int64_t> slice_dims, bool result) {
  return create(builder, builder.getLoc(), resultTypes, target, index, sg_layout, sg_data, inst_data, static_sg_layout, static_sg_data, static_inst_data, slice_dims, result);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<SetOpLayoutAttrOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SetOpLayoutAttrOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SetOpLayoutAttrOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SetOpLayoutAttrOp SetOpLayoutAttrOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void SetOpLayoutAttrOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.result)
    properties.result = ((false) ? odsBuilder.getUnitAttr() : nullptr);
}

::llvm::LogicalResult SetOpLayoutAttrOp::verifyInvariantsImpl() {
  auto tblgen_index = getProperties().index; (void)tblgen_index;
  auto tblgen_result = getProperties().result; (void)tblgen_result;
  auto tblgen_slice_dims = getProperties().slice_dims; (void)tblgen_slice_dims;
  auto tblgen_static_inst_data = getProperties().static_inst_data; (void)tblgen_static_inst_data;
  auto tblgen_static_sg_data = getProperties().static_sg_data; (void)tblgen_static_sg_data;
  auto tblgen_static_sg_layout = getProperties().static_sg_layout; (void)tblgen_static_sg_layout;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps2(*this, tblgen_index, "index")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_sg_layout, "static_sg_layout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_sg_data, "static_sg_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_static_inst_data, "static_inst_data")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps1(*this, tblgen_slice_dims, "slice_dims")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPUTransformOps3(*this, tblgen_result, "result")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPUTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SetOpLayoutAttrOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SetOpLayoutAttrOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand targetRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> targetOperands(&targetRawOperand, 1);  ::llvm::SMLoc targetOperandsLoc;
  (void)targetOperandsLoc;
  ::mlir::IntegerAttr indexAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> sg_layoutOperands;
  ::llvm::SMLoc sg_layoutOperandsLoc;
  (void)sg_layoutOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_sg_layoutAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> sg_dataOperands;
  ::llvm::SMLoc sg_dataOperandsLoc;
  (void)sg_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_sg_dataAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> inst_dataOperands;
  ::llvm::SMLoc inst_dataOperandsLoc;
  (void)inst_dataOperandsLoc;
  ::mlir::DenseI64ArrayAttr static_inst_dataAttr;
  ::mlir::DenseI64ArrayAttr slice_dimsAttr;
  ::llvm::SmallVector<::mlir::Type, 1> allOperandTypes;

  targetOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(targetRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("result"))) {
    result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().result = parser.getBuilder().getUnitAttr();  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("index"))) {
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(indexAttr, parser.getBuilder().getIntegerType(64))) {
    return ::mlir::failure();
  }
  if (indexAttr) result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().index = indexAttr;
  }
  if (parser.parseKeyword("sg_layout"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    sg_layoutOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, sg_layoutOperands, static_sg_layoutAttr);
    if (odsResult) return ::mlir::failure();
    if (static_sg_layoutAttr)
      result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().static_sg_layout = static_sg_layoutAttr;
  }
  if (parser.parseKeyword("sg_data"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    sg_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, sg_dataOperands, static_sg_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_sg_dataAttr)
      result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().static_sg_data = static_sg_dataAttr;
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("inst_data"))) {
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    inst_dataOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, inst_dataOperands, static_inst_dataAttr);
    if (odsResult) return ::mlir::failure();
    if (static_inst_dataAttr)
      result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().static_inst_data = static_inst_dataAttr;
  }
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("slice_dims"))) {
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(slice_dimsAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (slice_dimsAttr) result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().slice_dims = slice_dimsAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(allOperandTypes))
    return ::mlir::failure();
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(sg_layoutOperands.size()), static_cast<int32_t>(sg_dataOperands.size()), static_cast<int32_t>(inst_dataOperands.size())}), result.getOrAddProperties<SetOpLayoutAttrOp::Properties>().operandSegmentSizes.begin());
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(targetOperands, sg_layoutOperands, sg_dataOperands, inst_dataOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SetOpLayoutAttrOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTarget();
  if (getResultAttr() != ((false) ? ::mlir::OpBuilder((*this)->getContext()).getUnitAttr() : nullptr)) {
    _odsPrinter << ' ' << "result";
  }
  if ((getIndexAttr() && getIndexAttr() != ::mlir::OpBuilder((*this)->getContext()).getIntegerAttr(::mlir::OpBuilder((*this)->getContext()).getIntegerType(64), 0))) {
    _odsPrinter << ' ' << "index";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    _odsPrinter.printAttributeWithoutType(getIndexAttr());
  }
  _odsPrinter << ' ' << "sg_layout";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getSgLayout(), getStaticSgLayoutAttr());
  _odsPrinter << ' ' << "sg_data";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getSgData(), getStaticSgDataAttr());
  if (((!getInstData().empty()) || ((getStaticInstDataAttr() && getStaticInstDataAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))))) {
    _odsPrinter << ' ' << "inst_data";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getInstData(), getStaticInstDataAttr());
  }
  if ((getSliceDimsAttr() && getSliceDimsAttr() != ::mlir::OpBuilder((*this)->getContext()).getDenseI64ArrayAttr({}))) {
    _odsPrinter << ' ' << "slice_dims";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
  _odsPrinter.printStrippedAttrOrType(getSliceDimsAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("result");
  elidedAttrs.push_back("index");
  elidedAttrs.push_back("static_sg_layout");
  elidedAttrs.push_back("static_sg_data");
  elidedAttrs.push_back("static_inst_data");
  elidedAttrs.push_back("slice_dims");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIndexAttr();
     if(attr && (attr == odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), 0)))
       elidedAttrs.push_back("index");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticSgLayoutAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_sg_layout");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticSgDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_sg_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStaticInstDataAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("static_inst_data");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getSliceDimsAttr();
     if(attr && (attr == odsBuilder.getDenseI64ArrayAttr({})))
       elidedAttrs.push_back("slice_dims");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getResultAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("result");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperandTypes();
}


} // namespace mlir::transform
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::SetOpLayoutAttrOp)


#endif // GET_OP_CLASSES

