/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TuneExtensionOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

 mlir::transform::tune ::AlternativesOp,
 mlir::transform::tune ::KnobOp
#endif // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//


static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TuneExtensionOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::transform::TransformParamTypeInterface>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TransformParamTypeInterface instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_TuneExtensionOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::transform::TransformParamTypeInterface>(type))) || ((::llvm::isa<::mlir::transform::TransformHandleTypeInterface>(type))) || ((::llvm::isa<::mlir::transform::TransformValueHandleTypeInterface>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of any transform handle or parameter, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::StringAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: An Attribute containing a string";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TuneExtensionOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::IntegerAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: arbitrary integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TuneExtensionOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((true)))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: any attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_TuneExtensionOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_TuneExtensionOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_region_constraint_TuneExtensionOps1(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((::llvm::hasNItems(region, 1)))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: region with 1 blocks";
  }
  return ::mlir::success();
}
namespace  mlir::transform::tune  {


//===----------------------------------------------------------------------===//
//  mlir::transform::tune ::AlternativesOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

AlternativesOpGenericAdaptorBase::AlternativesOpGenericAdaptorBase(AlternativesOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> AlternativesOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::StringAttr AlternativesOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return ::llvm::cast<::mlir::StringAttr>(attr);
}

::std::optional< ::mlir::APInt > AlternativesOpGenericAdaptorBase::getSelectedRegionAttr() {
  auto attr = getSelectedRegionAttrAttr();
  return attr ? ::std::optional< ::mlir::APInt >(attr.getValue()) : (::std::nullopt);
}


} // namespace detail
AlternativesOpAdaptor::AlternativesOpAdaptor(AlternativesOp op) : AlternativesOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AlternativesOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitError(loc, "'transform.tune.alternatives' op requires attribute 'name'");
  auto tblgen_selected_region_attr = getProperties().selected_region_attr; (void)tblgen_selected_region_attr;

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'transform.tune.alternatives' op attribute 'name' failed to satisfy constraint: An Attribute containing a string");

  if (tblgen_selected_region_attr && !((::llvm::isa<::mlir::IntegerAttr>(tblgen_selected_region_attr))))
    return emitError(loc, "'transform.tune.alternatives' op attribute 'selected_region_attr' failed to satisfy constraint: arbitrary integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AlternativesOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange AlternativesOp::getSelectedRegionParamMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> AlternativesOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::LogicalResult AlternativesOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.selected_region_attr;
       auto attr = dict.get("selected_region_attr");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `selected_region_attr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AlternativesOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.selected_region_attr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("selected_region_attr",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AlternativesOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.selected_region_attr.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AlternativesOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "name")
      return prop.name;

    if (name == "selected_region_attr")
      return prop.selected_region_attr;
  return std::nullopt;
}

void AlternativesOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "selected_region_attr") {
       prop.selected_region_attr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.selected_region_attr)>>(value);
       return;
    }
}

void AlternativesOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.name) attrs.append("name", prop.name);

    if (prop.selected_region_attr) attrs.append("selected_region_attr", prop.selected_region_attr);
}

::llvm::LogicalResult AlternativesOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps1(attr, "name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSelectedRegionAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps2(attr, "selected_region_attr", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AlternativesOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.selected_region_attr)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AlternativesOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.name);

  writer.writeOptionalAttribute(prop.selected_region_attr);
}

::mlir::StringAttr AlternativesOp::getName() {
  auto attr = getNameAttr();
  return ::llvm::cast<::mlir::StringAttr>(attr);
}

::std::optional< ::mlir::APInt > AlternativesOp::getSelectedRegionAttr() {
  auto attr = getSelectedRegionAttrAttr();
  return attr ? ::std::optional< ::mlir::APInt >(attr.getValue()) : (::std::nullopt);
}

void AlternativesOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount) {
  if (selected_region_param)
    odsState.addOperands(selected_region_param);
  odsState.getOrAddProperties<Properties>().name = name;
  if (selected_region_attr) {
    odsState.getOrAddProperties<Properties>().selected_region_attr = selected_region_attr;
  }
  for (unsigned i = 0; i < alternativesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(results);
}

AlternativesOp AlternativesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, results, name, selected_region_attr, selected_region_param, alternativesCount);
  auto __res__ = ::llvm::dyn_cast<AlternativesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AlternativesOp AlternativesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange results, ::mlir::StringAttr name, /*optional*/::mlir::IntegerAttr selected_region_attr, /*optional*/::mlir::Value selected_region_param, unsigned alternativesCount) {
  return create(builder, builder.getLoc(), results, name, selected_region_attr, selected_region_param, alternativesCount);
}

void AlternativesOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AlternativesOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

AlternativesOp AlternativesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes, numRegions);
  auto __res__ = ::llvm::dyn_cast<AlternativesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AlternativesOp AlternativesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes, numRegions);
}

void AlternativesOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions) {
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(resultTypes);
}

AlternativesOp AlternativesOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes, numRegions);
  auto __res__ = ::llvm::dyn_cast<AlternativesOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

AlternativesOp AlternativesOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes, unsigned numRegions) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes, numRegions);
}

::llvm::LogicalResult AlternativesOp::verifyInvariantsImpl() {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitOpError("requires attribute 'name'");
  auto tblgen_selected_region_attr = getProperties().selected_region_attr; (void)tblgen_selected_region_attr;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps1(*this, tblgen_name, "name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps2(*this, tblgen_selected_region_attr, "selected_region_attr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TuneExtensionOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TuneExtensionOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : getAlternatives())
      if (::mlir::failed(__mlir_ods_local_region_constraint_TuneExtensionOps1(*this, region, "alternatives", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::llvm::LogicalResult AlternativesOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AlternativesOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr nameAttr;
  ::mlir::IntegerAttr selected_region_attrAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> selected_region_paramOperands;
  ::llvm::SMLoc selected_region_paramOperandsLoc;
  (void)selected_region_paramOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> selected_region_paramTypes;
  ::llvm::SmallVector<::mlir::Type, 1> resultsTypes;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> fullRegions;
  if (parser.parseLess())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(nameAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (nameAttr) result.getOrAddProperties<AlternativesOp::Properties>().name = nameAttr;
  if (parser.parseGreater())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("selected_region"))) {
  if (parser.parseEqual())
    return ::mlir::failure();
  {
    selected_region_paramOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> selected_region_paramOperand;
    auto odsResult = parseAlternativesOpSelectedRegion(parser, selected_region_attrAttr, selected_region_paramOperand);
    if (odsResult) return ::mlir::failure();
    if (selected_region_attrAttr)
      result.getOrAddProperties<AlternativesOp::Properties>().selected_region_attr = selected_region_attrAttr;
    if (selected_region_paramOperand.has_value())
      selected_region_paramOperands.push_back(*selected_region_paramOperand);
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      selected_region_paramTypes.push_back(optionalType);
    }
  }
  }
  if (::mlir::succeeded(parser.parseOptionalArrow())) {

  if (parser.parseTypeList(resultsTypes))
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.has_value()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      fullRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        fullRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : fullRegions)
    ensureTerminator(*region, parser.getBuilder(), result.location);
  result.addRegions(fullRegions);
  result.addTypes(resultsTypes);
  if (parser.resolveOperands(selected_region_paramOperands, selected_region_paramTypes, selected_region_paramOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AlternativesOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "<";
_odsPrinter.printStrippedAttrOrType(getNameAttr());
  _odsPrinter << ">";
  if (((getSelectedRegionAttrAttr()) || (getSelectedRegionParam()))) {
    _odsPrinter << ' ' << "selected_region";
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    printAlternativesOpSelectedRegion(_odsPrinter, *this, getSelectedRegionAttrAttr(), getSelectedRegionParam());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("name");
  elidedAttrs.push_back("selected_region_attr");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
  if (getSelectedRegionParam()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << (getSelectedRegionParam() ? ::llvm::ArrayRef<::mlir::Type>(getSelectedRegionParam().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  }
  if (!getResults().empty()) {
    _odsPrinter << ' ' << "->";
    _odsPrinter << ' ';
    _odsPrinter << getResults().getTypes();
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(getOperation()->getRegions(), _odsPrinter, [&](::mlir::Region &region) {

  {
    bool printTerminator = true;
    if (auto *term = region.empty() ? nullptr : region.begin()->getTerminator()) {
      printTerminator = !term->getAttrDictionary().empty() ||
                        term->getNumOperands() != 0 ||
                        term->getNumResults() != 0;
    }
    _odsPrinter.printRegion(region, /*printEntryBlockArgs=*/true,
      /*printBlockTerminators=*/printTerminator);
  }
    });
}


} // namespace  mlir::transform::tune 
MLIR_DEFINE_EXPLICIT_TYPE_ID( mlir::transform::tune ::AlternativesOp)

namespace  mlir::transform::tune  {


//===----------------------------------------------------------------------===//
//  mlir::transform::tune ::KnobOp definitions
//===----------------------------------------------------------------------===//

namespace detail {

KnobOpGenericAdaptorBase::KnobOpGenericAdaptorBase(KnobOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::StringAttr KnobOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return ::llvm::cast<::mlir::StringAttr>(attr);
}

::mlir::Attribute KnobOpGenericAdaptorBase::getOptions() {
  auto attr = getOptionsAttr();
  return attr;
}

::std::optional<::mlir::Attribute> KnobOpGenericAdaptorBase::getSelected() {
  auto attr = getSelectedAttr();
  return attr ? ::std::optional<::mlir::Attribute>(attr) : (::std::nullopt);
}


} // namespace detail
KnobOpAdaptor::KnobOpAdaptor(KnobOp op) : KnobOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult KnobOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitError(loc, "'transform.tune.knob' op requires attribute 'name'");
  auto tblgen_options = getProperties().options; (void)tblgen_options;
  if (!tblgen_options) return emitError(loc, "'transform.tune.knob' op requires attribute 'options'");
  auto tblgen_selected = getProperties().selected; (void)tblgen_selected;

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'transform.tune.knob' op attribute 'name' failed to satisfy constraint: An Attribute containing a string");

  if (tblgen_options && !((true)))
    return emitError(loc, "'transform.tune.knob' op attribute 'options' failed to satisfy constraint: any attribute");

  if (tblgen_selected && !((true)))
    return emitError(loc, "'transform.tune.knob' op attribute 'selected' failed to satisfy constraint: any attribute");
  return ::mlir::success();
}

::llvm::LogicalResult KnobOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.options;
       auto attr = dict.get("options");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `options` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.selected;
       auto attr = dict.get("selected");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `selected` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute KnobOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.options;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("options",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.selected;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("selected",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code KnobOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.options.getAsOpaquePointer()), 
    llvm::hash_value(prop.selected.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> KnobOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "name")
      return prop.name;

    if (name == "options")
      return prop.options;

    if (name == "selected")
      return prop.selected;
  return std::nullopt;
}

void KnobOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "options") {
       prop.options = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.options)>>(value);
       return;
    }

    if (name == "selected") {
       prop.selected = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.selected)>>(value);
       return;
    }
}

void KnobOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.name) attrs.append("name", prop.name);

    if (prop.options) attrs.append("options", prop.options);

    if (prop.selected) attrs.append("selected", prop.selected);
}

::llvm::LogicalResult KnobOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps1(attr, "name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getOptionsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps3(attr, "options", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSelectedAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps3(attr, "selected", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult KnobOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.options)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.selected)))
    return ::mlir::failure();
  return ::mlir::success();
}

void KnobOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.name);
  writer.writeAttribute(prop.options);

  writer.writeOptionalAttribute(prop.selected);
}

::mlir::StringAttr KnobOp::getName() {
  auto attr = getNameAttr();
  return ::llvm::cast<::mlir::StringAttr>(attr);
}

::mlir::Attribute KnobOp::getOptions() {
  auto attr = getOptionsAttr();
  return attr;
}

::std::optional<::mlir::Attribute> KnobOp::getSelected() {
  auto attr = getSelectedAttr();
  return attr ? ::std::optional<::mlir::Attribute>(attr) : (::std::nullopt);
}

void KnobOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  odsState.getOrAddProperties<Properties>().name = name;
  odsState.getOrAddProperties<Properties>().options = options;
  if (selected) {
    odsState.getOrAddProperties<Properties>().selected = selected;
  }
  odsState.addTypes(result);
}

KnobOp KnobOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, name, options, selected);
  auto __res__ = ::llvm::dyn_cast<KnobOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KnobOp KnobOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  return create(builder, builder.getLoc(), result, name, options, selected);
}

void KnobOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  odsState.getOrAddProperties<Properties>().name = name;
  odsState.getOrAddProperties<Properties>().options = options;
  if (selected) {
    odsState.getOrAddProperties<Properties>().selected = selected;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

KnobOp KnobOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, name, options, selected);
  auto __res__ = ::llvm::dyn_cast<KnobOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KnobOp KnobOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, ::mlir::Attribute options, /*optional*/::mlir::Attribute selected) {
  return create(builder, builder.getLoc(), resultTypes, name, options, selected);
}

void KnobOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<KnobOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

KnobOp KnobOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<KnobOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KnobOp KnobOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void KnobOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

KnobOp KnobOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<KnobOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

KnobOp KnobOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult KnobOp::verifyInvariantsImpl() {
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  if (!tblgen_name) return emitOpError("requires attribute 'name'");
  auto tblgen_options = getProperties().options; (void)tblgen_options;
  if (!tblgen_options) return emitOpError("requires attribute 'options'");
  auto tblgen_selected = getProperties().selected; (void)tblgen_selected;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps1(*this, tblgen_name, "name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps3(*this, tblgen_options, "options")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_TuneExtensionOps3(*this, tblgen_selected, "selected")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_TuneExtensionOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult KnobOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult KnobOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr nameAttr;
  ::mlir::Attribute selectedAttr;
  ::mlir::Attribute optionsAttr;
  ::llvm::SmallVector<::mlir::Type, 1> allResultTypes;
  if (parser.parseLess())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(nameAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (nameAttr) result.getOrAddProperties<KnobOp::Properties>().name = nameAttr;
  if (parser.parseGreater())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalEqual())) {

  if (parser.parseAttribute(selectedAttr, ::mlir::Type{}))
    return ::mlir::failure();
  if (selectedAttr) result.getOrAddProperties<KnobOp::Properties>().selected = selectedAttr;
  if (parser.parseKeyword("from"))
    return ::mlir::failure();
  }
  if (parser.parseKeyword("options"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseAttribute(optionsAttr, ::mlir::Type{}))
    return ::mlir::failure();
  if (optionsAttr) result.getOrAddProperties<KnobOp::Properties>().options = optionsAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseTypeList(allResultTypes))
    return ::mlir::failure();
  result.addTypes(allResultTypes);
  return ::mlir::success();
}

void KnobOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "<";
_odsPrinter.printStrippedAttrOrType(getNameAttr());
  _odsPrinter << ">";
  if (getSelectedAttr()) {
    _odsPrinter << ' ' << "=";
    _odsPrinter << ' ';
    _odsPrinter.printAttribute(getSelectedAttr());
    _odsPrinter << ' ' << "from";
  }
  _odsPrinter << ' ' << "options";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  _odsPrinter.printAttribute(getOptionsAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("name");
  elidedAttrs.push_back("selected");
  elidedAttrs.push_back("options");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getResultTypes();
}


} // namespace  mlir::transform::tune 
MLIR_DEFINE_EXPLICIT_TYPE_ID( mlir::transform::tune ::KnobOp)


#endif // GET_OP_CLASSES

