/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_ACCIMPLICITDATA
#define GEN_PASS_DECL_ACCIMPLICITROUTINE
#define GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// ACCImplicitData
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIMPLICITDATA
struct ACCImplicitDataOptions {
  bool enableImplicitReductionCopy = true;
};
std::unique_ptr<::mlir::Pass> createACCImplicitData();
std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options);
#undef GEN_PASS_DECL_ACCIMPLICITDATA
#endif // GEN_PASS_DECL_ACCIMPLICITDATA
#ifdef GEN_PASS_DEF_ACCIMPLICITDATA

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitData();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCImplicitDataBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitDataBase;

  ACCImplicitDataBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitDataBase(const ACCImplicitDataBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitDataBase& operator=(const ACCImplicitDataBase &) = delete;
  ACCImplicitDataBase(ACCImplicitDataBase &&) = delete;
  ACCImplicitDataBase& operator=(ACCImplicitDataBase &&) = delete;
  ~ACCImplicitDataBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-data");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-data"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit data attributes for OpenACC compute constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitData");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitData"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitDataBase<DerivedT>)

  ACCImplicitDataBase(ACCImplicitDataOptions options) : ACCImplicitDataBase() {
    enableImplicitReductionCopy = std::move(options.enableImplicitReductionCopy);
  }
protected:
  ::mlir::Pass::Option<bool> enableImplicitReductionCopy{*this, "enable-implicit-reduction-copy", ::llvm::cl::desc(R"PO(Enable applying implicit copy in lieu of implicit firstprivate for reduction variables. This allows uniform treatment of reduction variables between combined constructs (e.g., 'parallel loop') and separate constructs (e.g., 'parallel' followed by 'loop'), where the OpenACC spec requires copy semantics for the former but firstprivate would normally apply for the latter.)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createACCImplicitData() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCImplicitData() {
  return impl::createACCImplicitData();
}

std::unique_ptr<::mlir::Pass> createACCImplicitData(ACCImplicitDataOptions options) {
  return impl::createACCImplicitData(std::move(options));
}
#undef GEN_PASS_DEF_ACCIMPLICITDATA
#endif // GEN_PASS_DEF_ACCIMPLICITDATA

//===----------------------------------------------------------------------===//
// ACCImplicitRoutine
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ACCIMPLICITROUTINE
struct ACCImplicitRoutineOptions {
  mlir::acc::DeviceType deviceType = mlir::acc::DeviceType::None;
};
std::unique_ptr<::mlir::Pass> createACCImplicitRoutine();
std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options);
#undef GEN_PASS_DECL_ACCIMPLICITROUTINE
#endif // GEN_PASS_DECL_ACCIMPLICITROUTINE
#ifdef GEN_PASS_DEF_ACCIMPLICITROUTINE

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitRoutine();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ACCImplicitRoutineBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitRoutineBase;

  ACCImplicitRoutineBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitRoutineBase(const ACCImplicitRoutineBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitRoutineBase& operator=(const ACCImplicitRoutineBase &) = delete;
  ACCImplicitRoutineBase(ACCImplicitRoutineBase &&) = delete;
  ACCImplicitRoutineBase& operator=(ACCImplicitRoutineBase &&) = delete;
  ~ACCImplicitRoutineBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-routine");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-routine"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit acc routine for functions in acc regions)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitRoutine");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitRoutine"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitRoutineBase<DerivedT>)

  ACCImplicitRoutineBase(ACCImplicitRoutineOptions options) : ACCImplicitRoutineBase() {
    deviceType = std::move(options.deviceType);
  }
protected:
  ::mlir::Pass::Option<mlir::acc::DeviceType> deviceType{*this, "device-type", ::llvm::cl::desc(R"PO(Target device type for implicit routine generation. Ensures that `acc routine` device_type clauses are properly considered not just default clauses.)PO"), ::llvm::cl::init(mlir::acc::DeviceType::None), ::llvm::cl::values(
              clEnumValN(mlir::acc::DeviceType::None, "none", "none"),
              clEnumValN(mlir::acc::DeviceType::Host, "host", "host"),
              clEnumValN(mlir::acc::DeviceType::Multicore, "multicore", "multicore"),
              clEnumValN(mlir::acc::DeviceType::Nvidia, "nvidia", "nvidia"),
              clEnumValN(mlir::acc::DeviceType::Radeon, "radeon", "radeon"))
           };
private:

  friend std::unique_ptr<::mlir::Pass> createACCImplicitRoutine() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createACCImplicitRoutine() {
  return impl::createACCImplicitRoutine();
}

std::unique_ptr<::mlir::Pass> createACCImplicitRoutine(ACCImplicitRoutineOptions options) {
  return impl::createACCImplicitRoutine(std::move(options));
}
#undef GEN_PASS_DEF_ACCIMPLICITROUTINE
#endif // GEN_PASS_DEF_ACCIMPLICITROUTINE

//===----------------------------------------------------------------------===//
// LegalizeDataValuesInRegion
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
struct LegalizeDataValuesInRegionOptions {
  bool hostToDevice = true;
  bool applyToAccDataConstruct = true;
};
std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion();
std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options);
#undef GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_DECL_LEGALIZEDATAVALUESINREGION
#ifdef GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION

namespace impl {
  std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class LegalizeDataValuesInRegionBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = LegalizeDataValuesInRegionBase;

  LegalizeDataValuesInRegionBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeDataValuesInRegionBase(const LegalizeDataValuesInRegionBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  LegalizeDataValuesInRegionBase& operator=(const LegalizeDataValuesInRegionBase &) = delete;
  LegalizeDataValuesInRegionBase(LegalizeDataValuesInRegionBase &&) = delete;
  LegalizeDataValuesInRegionBase& operator=(LegalizeDataValuesInRegionBase &&) = delete;
  ~LegalizeDataValuesInRegionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("openacc-legalize-data-values");
  }
  ::llvm::StringRef getArgument() const override { return "openacc-legalize-data-values"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalizes SSA values in compute regions with results from data clause operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeDataValuesInRegion");
  }
  ::llvm::StringRef getName() const override { return "LegalizeDataValuesInRegion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeDataValuesInRegionBase<DerivedT>)

  LegalizeDataValuesInRegionBase(LegalizeDataValuesInRegionOptions options) : LegalizeDataValuesInRegionBase() {
    hostToDevice = std::move(options.hostToDevice);
    applyToAccDataConstruct = std::move(options.applyToAccDataConstruct);
  }
protected:
  ::mlir::Pass::Option<bool> hostToDevice{*this, "host-to-device", ::llvm::cl::desc(R"PO(Replace varPtr uses with accPtr if true. Replace accPtr uses with varPtr if false)PO"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> applyToAccDataConstruct{*this, "apply-to-acc-data-construct", ::llvm::cl::desc(R"PO(Replaces varPtr uses with accPtr for acc compute regions contained within acc.data or acc.declare region.)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion() {
  return impl::createLegalizeDataValuesInRegion();
}

std::unique_ptr<::mlir::Pass> createLegalizeDataValuesInRegion(LegalizeDataValuesInRegionOptions options) {
  return impl::createLegalizeDataValuesInRegion(std::move(options));
}
#undef GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_DEF_LEGALIZEDATAVALUESINREGION
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_ACCIMPLICITDATA
#define GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE
#define GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ACCImplicitData Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIMPLICITDATA

inline void registerACCImplicitData() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitData();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCImplicitDataPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitData();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIMPLICITDATA
#endif // GEN_PASS_REGISTRATION_ACCIMPLICITDATA

//===----------------------------------------------------------------------===//
// ACCImplicitRoutine Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE

inline void registerACCImplicitRoutine() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitRoutine();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerACCImplicitRoutinePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createACCImplicitRoutine();
  });
}

#undef GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE
#endif // GEN_PASS_REGISTRATION_ACCIMPLICITROUTINE

//===----------------------------------------------------------------------===//
// LegalizeDataValuesInRegion Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION

inline void registerLegalizeDataValuesInRegion() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeDataValuesInRegion();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerLegalizeDataValuesInRegionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createLegalizeDataValuesInRegion();
  });
}

#undef GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION
#endif // GEN_PASS_REGISTRATION_LEGALIZEDATAVALUESINREGION
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// OpenACC Registration
//===----------------------------------------------------------------------===//

inline void registerOpenACCPasses() {
  registerACCImplicitData();
  registerACCImplicitRoutine();
  registerLegalizeDataValuesInRegion();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class ACCImplicitDataBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitDataBase;

  ACCImplicitDataBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitDataBase(const ACCImplicitDataBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitDataBase& operator=(const ACCImplicitDataBase &) = delete;
  ACCImplicitDataBase(ACCImplicitDataBase &&) = delete;
  ACCImplicitDataBase& operator=(ACCImplicitDataBase &&) = delete;
  ~ACCImplicitDataBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-data");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-data"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit data attributes for OpenACC compute constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitData");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitData"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
    registry.insert<mlir::memref::MemRefDialect>();
    registry.insert<mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitDataBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> enableImplicitReductionCopy{*this, "enable-implicit-reduction-copy", ::llvm::cl::desc(R"PO(Enable applying implicit copy in lieu of implicit firstprivate for reduction variables. This allows uniform treatment of reduction variables between combined constructs (e.g., 'parallel loop') and separate constructs (e.g., 'parallel' followed by 'loop'), where the OpenACC spec requires copy semantics for the former but firstprivate would normally apply for the latter.)PO"), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class ACCImplicitRoutineBase : public ::mlir::OperationPass<mlir::ModuleOp> {
public:
  using Base = ACCImplicitRoutineBase;

  ACCImplicitRoutineBase() : ::mlir::OperationPass<mlir::ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ACCImplicitRoutineBase(const ACCImplicitRoutineBase &other) : ::mlir::OperationPass<mlir::ModuleOp>(other) {}
  ACCImplicitRoutineBase& operator=(const ACCImplicitRoutineBase &) = delete;
  ACCImplicitRoutineBase(ACCImplicitRoutineBase &&) = delete;
  ACCImplicitRoutineBase& operator=(ACCImplicitRoutineBase &&) = delete;
  ~ACCImplicitRoutineBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("acc-implicit-routine");
  }
  ::llvm::StringRef getArgument() const override { return "acc-implicit-routine"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Generate implicit acc routine for functions in acc regions)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ACCImplicitRoutine");
  }
  ::llvm::StringRef getName() const override { return "ACCImplicitRoutine"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<mlir::acc::OpenACCDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ACCImplicitRoutineBase<DerivedT>)

protected:
  ::mlir::Pass::Option<mlir::acc::DeviceType> deviceType{*this, "device-type", ::llvm::cl::desc(R"PO(Target device type for implicit routine generation. Ensures that `acc routine` device_type clauses are properly considered not just default clauses.)PO"), ::llvm::cl::init(mlir::acc::DeviceType::None), ::llvm::cl::values(
              clEnumValN(mlir::acc::DeviceType::None, "none", "none"),
              clEnumValN(mlir::acc::DeviceType::Host, "host", "host"),
              clEnumValN(mlir::acc::DeviceType::Multicore, "multicore", "multicore"),
              clEnumValN(mlir::acc::DeviceType::Nvidia, "nvidia", "nvidia"),
              clEnumValN(mlir::acc::DeviceType::Radeon, "radeon", "radeon"))
           };
};

template <typename DerivedT>
class LegalizeDataValuesInRegionBase : public ::mlir::OperationPass<mlir::func::FuncOp> {
public:
  using Base = LegalizeDataValuesInRegionBase;

  LegalizeDataValuesInRegionBase() : ::mlir::OperationPass<mlir::func::FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  LegalizeDataValuesInRegionBase(const LegalizeDataValuesInRegionBase &other) : ::mlir::OperationPass<mlir::func::FuncOp>(other) {}
  LegalizeDataValuesInRegionBase& operator=(const LegalizeDataValuesInRegionBase &) = delete;
  LegalizeDataValuesInRegionBase(LegalizeDataValuesInRegionBase &&) = delete;
  LegalizeDataValuesInRegionBase& operator=(LegalizeDataValuesInRegionBase &&) = delete;
  ~LegalizeDataValuesInRegionBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("openacc-legalize-data-values");
  }
  ::llvm::StringRef getArgument() const override { return "openacc-legalize-data-values"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalizes SSA values in compute regions with results from data clause operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("LegalizeDataValuesInRegion");
  }
  ::llvm::StringRef getName() const override { return "LegalizeDataValuesInRegion"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(LegalizeDataValuesInRegionBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> hostToDevice{*this, "host-to-device", ::llvm::cl::desc(R"PO(Replace varPtr uses with accPtr if true. Replace accPtr uses with varPtr if false)PO"), ::llvm::cl::init(true)};
  ::mlir::Pass::Option<bool> applyToAccDataConstruct{*this, "apply-to-acc-data-construct", ::llvm::cl::desc(R"PO(Replaces varPtr uses with accPtr for acc compute regions contained within acc.data or acc.declare region.)PO"), ::llvm::cl::init(true)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
