/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_EXPANDOPSPASS
#define GEN_PASS_DECL_EXPANDREALLOCPASS
#define GEN_PASS_DECL_EXPANDSTRIDEDMETADATAPASS
#define GEN_PASS_DECL_FLATTENMEMREFSPASS
#define GEN_PASS_DECL_FOLDMEMREFALIASOPSPASS
#define GEN_PASS_DECL_MEMREFEMULATEWIDEINT
#define GEN_PASS_DECL_NORMALIZEMEMREFSPASS
#define GEN_PASS_DECL_REIFYRESULTSHAPESPASS
#define GEN_PASS_DECL_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#define GEN_PASS_DECL_RESOLVESHAPEDTYPERESULTDIMSPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// ExpandOpsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EXPANDOPSPASS
std::unique_ptr<::mlir::Pass> createExpandOpsPass();
#undef GEN_PASS_DECL_EXPANDOPSPASS
#endif // GEN_PASS_DECL_EXPANDOPSPASS
#ifdef GEN_PASS_DEF_EXPANDOPSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createExpandOpsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ExpandOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandOpsPassBase;

  ExpandOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandOpsPassBase(const ExpandOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandOpsPassBase& operator=(const ExpandOpsPassBase &) = delete;
  ExpandOpsPassBase(ExpandOpsPassBase &&) = delete;
  ExpandOpsPassBase& operator=(ExpandOpsPassBase &&) = delete;
  ~ExpandOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memref-expand");
  }
  ::llvm::StringRef getArgument() const override { return "memref-expand"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize memref operations to be convertible to LLVM.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandOpsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createExpandOpsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createExpandOpsPass() {
  return impl::createExpandOpsPass();
}
#undef GEN_PASS_DEF_EXPANDOPSPASS
#endif // GEN_PASS_DEF_EXPANDOPSPASS

//===----------------------------------------------------------------------===//
// ExpandReallocPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EXPANDREALLOCPASS
struct ExpandReallocPassOptions {
  bool emitDeallocs = true;
};
std::unique_ptr<::mlir::Pass> createExpandReallocPass();
std::unique_ptr<::mlir::Pass> createExpandReallocPass(ExpandReallocPassOptions options);
#undef GEN_PASS_DECL_EXPANDREALLOCPASS
#endif // GEN_PASS_DECL_EXPANDREALLOCPASS
#ifdef GEN_PASS_DEF_EXPANDREALLOCPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createExpandReallocPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createExpandReallocPass(ExpandReallocPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ExpandReallocPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandReallocPassBase;

  ExpandReallocPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandReallocPassBase(const ExpandReallocPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandReallocPassBase& operator=(const ExpandReallocPassBase &) = delete;
  ExpandReallocPassBase(ExpandReallocPassBase &&) = delete;
  ExpandReallocPassBase& operator=(ExpandReallocPassBase &&) = delete;
  ~ExpandReallocPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("expand-realloc");
  }
  ::llvm::StringRef getArgument() const override { return "expand-realloc"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Expand memref.realloc operations into its components)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandReallocPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandReallocPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<scf::SCFDialect>();
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandReallocPassBase<DerivedT>)

  ExpandReallocPassBase(ExpandReallocPassOptions options) : ExpandReallocPassBase() {
    emitDeallocs = std::move(options.emitDeallocs);
  }
protected:
  ::mlir::Pass::Option<bool> emitDeallocs{*this, "emit-deallocs", ::llvm::cl::desc(R"PO(Emit deallocation operations for the original MemRef)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createExpandReallocPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createExpandReallocPass(ExpandReallocPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createExpandReallocPass() {
  return impl::createExpandReallocPass();
}

std::unique_ptr<::mlir::Pass> createExpandReallocPass(ExpandReallocPassOptions options) {
  return impl::createExpandReallocPass(std::move(options));
}
#undef GEN_PASS_DEF_EXPANDREALLOCPASS
#endif // GEN_PASS_DEF_EXPANDREALLOCPASS

//===----------------------------------------------------------------------===//
// ExpandStridedMetadataPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_EXPANDSTRIDEDMETADATAPASS
std::unique_ptr<::mlir::Pass> createExpandStridedMetadataPass();
#undef GEN_PASS_DECL_EXPANDSTRIDEDMETADATAPASS
#endif // GEN_PASS_DECL_EXPANDSTRIDEDMETADATAPASS
#ifdef GEN_PASS_DEF_EXPANDSTRIDEDMETADATAPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createExpandStridedMetadataPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ExpandStridedMetadataPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandStridedMetadataPassBase;

  ExpandStridedMetadataPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandStridedMetadataPassBase(const ExpandStridedMetadataPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandStridedMetadataPassBase& operator=(const ExpandStridedMetadataPassBase &) = delete;
  ExpandStridedMetadataPassBase(ExpandStridedMetadataPassBase &&) = delete;
  ExpandStridedMetadataPassBase& operator=(ExpandStridedMetadataPassBase &&) = delete;
  ~ExpandStridedMetadataPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("expand-strided-metadata");
  }
  ::llvm::StringRef getArgument() const override { return "expand-strided-metadata"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Expand memref operations into easier to analyze constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandStridedMetadataPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandStridedMetadataPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandStridedMetadataPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createExpandStridedMetadataPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createExpandStridedMetadataPass() {
  return impl::createExpandStridedMetadataPass();
}
#undef GEN_PASS_DEF_EXPANDSTRIDEDMETADATAPASS
#endif // GEN_PASS_DEF_EXPANDSTRIDEDMETADATAPASS

//===----------------------------------------------------------------------===//
// FlattenMemrefsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_FLATTENMEMREFSPASS
std::unique_ptr<::mlir::Pass> createFlattenMemrefsPass();
#undef GEN_PASS_DECL_FLATTENMEMREFSPASS
#endif // GEN_PASS_DECL_FLATTENMEMREFSPASS
#ifdef GEN_PASS_DEF_FLATTENMEMREFSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createFlattenMemrefsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class FlattenMemrefsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = FlattenMemrefsPassBase;

  FlattenMemrefsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  FlattenMemrefsPassBase(const FlattenMemrefsPassBase &other) : ::mlir::OperationPass<>(other) {}
  FlattenMemrefsPassBase& operator=(const FlattenMemrefsPassBase &) = delete;
  FlattenMemrefsPassBase(FlattenMemrefsPassBase &&) = delete;
  FlattenMemrefsPassBase& operator=(FlattenMemrefsPassBase &&) = delete;
  ~FlattenMemrefsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("flatten-memref");
  }
  ::llvm::StringRef getArgument() const override { return "flatten-memref"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Flatten a multiple dimensional memref to 1-dimensional)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FlattenMemrefsPass");
  }
  ::llvm::StringRef getName() const override { return "FlattenMemrefsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FlattenMemrefsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createFlattenMemrefsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createFlattenMemrefsPass() {
  return impl::createFlattenMemrefsPass();
}
#undef GEN_PASS_DEF_FLATTENMEMREFSPASS
#endif // GEN_PASS_DEF_FLATTENMEMREFSPASS

//===----------------------------------------------------------------------===//
// FoldMemRefAliasOpsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_FOLDMEMREFALIASOPSPASS
std::unique_ptr<::mlir::Pass> createFoldMemRefAliasOpsPass();
#undef GEN_PASS_DECL_FOLDMEMREFALIASOPSPASS
#endif // GEN_PASS_DECL_FOLDMEMREFALIASOPSPASS
#ifdef GEN_PASS_DEF_FOLDMEMREFALIASOPSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createFoldMemRefAliasOpsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class FoldMemRefAliasOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = FoldMemRefAliasOpsPassBase;

  FoldMemRefAliasOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  FoldMemRefAliasOpsPassBase(const FoldMemRefAliasOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  FoldMemRefAliasOpsPassBase& operator=(const FoldMemRefAliasOpsPassBase &) = delete;
  FoldMemRefAliasOpsPassBase(FoldMemRefAliasOpsPassBase &&) = delete;
  FoldMemRefAliasOpsPassBase& operator=(FoldMemRefAliasOpsPassBase &&) = delete;
  ~FoldMemRefAliasOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("fold-memref-alias-ops");
  }
  ::llvm::StringRef getArgument() const override { return "fold-memref-alias-ops"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Fold memref alias ops into consumer load/store ops)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FoldMemRefAliasOpsPass");
  }
  ::llvm::StringRef getName() const override { return "FoldMemRefAliasOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FoldMemRefAliasOpsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createFoldMemRefAliasOpsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createFoldMemRefAliasOpsPass() {
  return impl::createFoldMemRefAliasOpsPass();
}
#undef GEN_PASS_DEF_FOLDMEMREFALIASOPSPASS
#endif // GEN_PASS_DEF_FOLDMEMREFALIASOPSPASS

//===----------------------------------------------------------------------===//
// MemRefEmulateWideInt
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_MEMREFEMULATEWIDEINT
struct MemRefEmulateWideIntOptions {
  unsigned widestIntSupported = 32;
};
std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt();
std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt(MemRefEmulateWideIntOptions options);
#undef GEN_PASS_DECL_MEMREFEMULATEWIDEINT
#endif // GEN_PASS_DECL_MEMREFEMULATEWIDEINT
#ifdef GEN_PASS_DEF_MEMREFEMULATEWIDEINT

namespace impl {
  std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt(MemRefEmulateWideIntOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class MemRefEmulateWideIntBase : public ::mlir::OperationPass<> {
public:
  using Base = MemRefEmulateWideIntBase;

  MemRefEmulateWideIntBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  MemRefEmulateWideIntBase(const MemRefEmulateWideIntBase &other) : ::mlir::OperationPass<>(other) {}
  MemRefEmulateWideIntBase& operator=(const MemRefEmulateWideIntBase &) = delete;
  MemRefEmulateWideIntBase(MemRefEmulateWideIntBase &&) = delete;
  MemRefEmulateWideIntBase& operator=(MemRefEmulateWideIntBase &&) = delete;
  ~MemRefEmulateWideIntBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memref-emulate-wide-int");
  }
  ::llvm::StringRef getArgument() const override { return "memref-emulate-wide-int"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate 2*N-bit integer operations using N-bit operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MemRefEmulateWideInt");
  }
  ::llvm::StringRef getName() const override { return "MemRefEmulateWideInt"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MemRefEmulateWideIntBase<DerivedT>)

  MemRefEmulateWideIntBase(MemRefEmulateWideIntOptions options) : MemRefEmulateWideIntBase() {
    widestIntSupported = std::move(options.widestIntSupported);
  }
protected:
  ::mlir::Pass::Option<unsigned> widestIntSupported{*this, "widest-int-supported", ::llvm::cl::desc(R"PO(Widest integer type supported by the target)PO"), ::llvm::cl::init(32)};
private:

  friend std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt(MemRefEmulateWideIntOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt() {
  return impl::createMemRefEmulateWideInt();
}

std::unique_ptr<::mlir::Pass> createMemRefEmulateWideInt(MemRefEmulateWideIntOptions options) {
  return impl::createMemRefEmulateWideInt(std::move(options));
}
#undef GEN_PASS_DEF_MEMREFEMULATEWIDEINT
#endif // GEN_PASS_DEF_MEMREFEMULATEWIDEINT

//===----------------------------------------------------------------------===//
// NormalizeMemRefsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_NORMALIZEMEMREFSPASS
std::unique_ptr<::mlir::Pass> createNormalizeMemRefsPass();
#undef GEN_PASS_DECL_NORMALIZEMEMREFSPASS
#endif // GEN_PASS_DECL_NORMALIZEMEMREFSPASS
#ifdef GEN_PASS_DEF_NORMALIZEMEMREFSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createNormalizeMemRefsPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class NormalizeMemRefsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = NormalizeMemRefsPassBase;

  NormalizeMemRefsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  NormalizeMemRefsPassBase(const NormalizeMemRefsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  NormalizeMemRefsPassBase& operator=(const NormalizeMemRefsPassBase &) = delete;
  NormalizeMemRefsPassBase(NormalizeMemRefsPassBase &&) = delete;
  NormalizeMemRefsPassBase& operator=(NormalizeMemRefsPassBase &&) = delete;
  ~NormalizeMemRefsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("normalize-memrefs");
  }
  ::llvm::StringRef getArgument() const override { return "normalize-memrefs"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Normalize memrefs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("NormalizeMemRefsPass");
  }
  ::llvm::StringRef getName() const override { return "NormalizeMemRefsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(NormalizeMemRefsPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createNormalizeMemRefsPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createNormalizeMemRefsPass() {
  return impl::createNormalizeMemRefsPass();
}
#undef GEN_PASS_DEF_NORMALIZEMEMREFSPASS
#endif // GEN_PASS_DEF_NORMALIZEMEMREFSPASS

//===----------------------------------------------------------------------===//
// ReifyResultShapesPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_REIFYRESULTSHAPESPASS
std::unique_ptr<::mlir::Pass> createReifyResultShapesPass();
#undef GEN_PASS_DECL_REIFYRESULTSHAPESPASS
#endif // GEN_PASS_DECL_REIFYRESULTSHAPESPASS
#ifdef GEN_PASS_DEF_REIFYRESULTSHAPESPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createReifyResultShapesPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ReifyResultShapesPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ReifyResultShapesPassBase;

  ReifyResultShapesPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ReifyResultShapesPassBase(const ReifyResultShapesPassBase &other) : ::mlir::OperationPass<>(other) {}
  ReifyResultShapesPassBase& operator=(const ReifyResultShapesPassBase &) = delete;
  ReifyResultShapesPassBase(ReifyResultShapesPassBase &&) = delete;
  ReifyResultShapesPassBase& operator=(ReifyResultShapesPassBase &&) = delete;
  ~ReifyResultShapesPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("reify-result-shapes");
  }
  ::llvm::StringRef getArgument() const override { return "reify-result-shapes"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Reifies the results of `tensor::PadOp` and `tensor::ConcatOp`.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ReifyResultShapesPass");
  }
  ::llvm::StringRef getName() const override { return "ReifyResultShapesPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ReifyResultShapesPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createReifyResultShapesPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createReifyResultShapesPass() {
  return impl::createReifyResultShapesPass();
}
#undef GEN_PASS_DEF_REIFYRESULTSHAPESPASS
#endif // GEN_PASS_DEF_REIFYRESULTSHAPESPASS

//===----------------------------------------------------------------------===//
// ResolveRankedShapeTypeResultDimsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
struct ResolveRankedShapeTypeResultDimsPassOptions {
  bool errorOnPatternIterationLimit = true;
};
std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass();
std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass(ResolveRankedShapeTypeResultDimsPassOptions options);
#undef GEN_PASS_DECL_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#endif // GEN_PASS_DECL_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#ifdef GEN_PASS_DEF_RESOLVERANKEDSHAPETYPERESULTDIMSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass(ResolveRankedShapeTypeResultDimsPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ResolveRankedShapeTypeResultDimsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ResolveRankedShapeTypeResultDimsPassBase;

  ResolveRankedShapeTypeResultDimsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ResolveRankedShapeTypeResultDimsPassBase(const ResolveRankedShapeTypeResultDimsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ResolveRankedShapeTypeResultDimsPassBase& operator=(const ResolveRankedShapeTypeResultDimsPassBase &) = delete;
  ResolveRankedShapeTypeResultDimsPassBase(ResolveRankedShapeTypeResultDimsPassBase &&) = delete;
  ResolveRankedShapeTypeResultDimsPassBase& operator=(ResolveRankedShapeTypeResultDimsPassBase &&) = delete;
  ~ResolveRankedShapeTypeResultDimsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("resolve-ranked-shaped-type-result-dims");
  }
  ::llvm::StringRef getArgument() const override { return "resolve-ranked-shaped-type-result-dims"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Resolve memref.dim of result values of ranked shape type)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ResolveRankedShapeTypeResultDimsPass");
  }
  ::llvm::StringRef getName() const override { return "ResolveRankedShapeTypeResultDimsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ResolveRankedShapeTypeResultDimsPassBase<DerivedT>)

  ResolveRankedShapeTypeResultDimsPassBase(ResolveRankedShapeTypeResultDimsPassOptions options) : ResolveRankedShapeTypeResultDimsPassBase() {
    errorOnPatternIterationLimit = std::move(options.errorOnPatternIterationLimit);
  }
protected:
  ::mlir::Pass::Option<bool> errorOnPatternIterationLimit{*this, "error-on-pattern-iteration-limit", ::llvm::cl::desc(R"PO(Throw an error when pattern rewriter hits iteration limit)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass(ResolveRankedShapeTypeResultDimsPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass() {
  return impl::createResolveRankedShapeTypeResultDimsPass();
}

std::unique_ptr<::mlir::Pass> createResolveRankedShapeTypeResultDimsPass(ResolveRankedShapeTypeResultDimsPassOptions options) {
  return impl::createResolveRankedShapeTypeResultDimsPass(std::move(options));
}
#undef GEN_PASS_DEF_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#endif // GEN_PASS_DEF_RESOLVERANKEDSHAPETYPERESULTDIMSPASS

//===----------------------------------------------------------------------===//
// ResolveShapedTypeResultDimsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_RESOLVESHAPEDTYPERESULTDIMSPASS
struct ResolveShapedTypeResultDimsPassOptions {
  bool errorOnPatternIterationLimit = true;
};
std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass();
std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass(ResolveShapedTypeResultDimsPassOptions options);
#undef GEN_PASS_DECL_RESOLVESHAPEDTYPERESULTDIMSPASS
#endif // GEN_PASS_DECL_RESOLVESHAPEDTYPERESULTDIMSPASS
#ifdef GEN_PASS_DEF_RESOLVESHAPEDTYPERESULTDIMSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass(ResolveShapedTypeResultDimsPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ResolveShapedTypeResultDimsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ResolveShapedTypeResultDimsPassBase;

  ResolveShapedTypeResultDimsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ResolveShapedTypeResultDimsPassBase(const ResolveShapedTypeResultDimsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ResolveShapedTypeResultDimsPassBase& operator=(const ResolveShapedTypeResultDimsPassBase &) = delete;
  ResolveShapedTypeResultDimsPassBase(ResolveShapedTypeResultDimsPassBase &&) = delete;
  ResolveShapedTypeResultDimsPassBase& operator=(ResolveShapedTypeResultDimsPassBase &&) = delete;
  ~ResolveShapedTypeResultDimsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("resolve-shaped-type-result-dims");
  }
  ::llvm::StringRef getArgument() const override { return "resolve-shaped-type-result-dims"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Resolve memref.dim of result values)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ResolveShapedTypeResultDimsPass");
  }
  ::llvm::StringRef getName() const override { return "ResolveShapedTypeResultDimsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ResolveShapedTypeResultDimsPassBase<DerivedT>)

  ResolveShapedTypeResultDimsPassBase(ResolveShapedTypeResultDimsPassOptions options) : ResolveShapedTypeResultDimsPassBase() {
    errorOnPatternIterationLimit = std::move(options.errorOnPatternIterationLimit);
  }
protected:
  ::mlir::Pass::Option<bool> errorOnPatternIterationLimit{*this, "error-on-pattern-iteration-limit", ::llvm::cl::desc(R"PO(Throw an error when pattern rewriter hits iteration limit)PO"), ::llvm::cl::init(true)};
private:

  friend std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass(ResolveShapedTypeResultDimsPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass() {
  return impl::createResolveShapedTypeResultDimsPass();
}

std::unique_ptr<::mlir::Pass> createResolveShapedTypeResultDimsPass(ResolveShapedTypeResultDimsPassOptions options) {
  return impl::createResolveShapedTypeResultDimsPass(std::move(options));
}
#undef GEN_PASS_DEF_RESOLVESHAPEDTYPERESULTDIMSPASS
#endif // GEN_PASS_DEF_RESOLVESHAPEDTYPERESULTDIMSPASS
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_EXPANDOPSPASS
#define GEN_PASS_REGISTRATION_EXPANDREALLOCPASS
#define GEN_PASS_REGISTRATION_EXPANDSTRIDEDMETADATAPASS
#define GEN_PASS_REGISTRATION_FLATTENMEMREFSPASS
#define GEN_PASS_REGISTRATION_FOLDMEMREFALIASOPSPASS
#define GEN_PASS_REGISTRATION_MEMREFEMULATEWIDEINT
#define GEN_PASS_REGISTRATION_NORMALIZEMEMREFSPASS
#define GEN_PASS_REGISTRATION_REIFYRESULTSHAPESPASS
#define GEN_PASS_REGISTRATION_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#define GEN_PASS_REGISTRATION_RESOLVESHAPEDTYPERESULTDIMSPASS
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ExpandOpsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_EXPANDOPSPASS

inline void registerExpandOpsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandOpsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerExpandOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandOpsPass();
  });
}

#undef GEN_PASS_REGISTRATION_EXPANDOPSPASS
#endif // GEN_PASS_REGISTRATION_EXPANDOPSPASS

//===----------------------------------------------------------------------===//
// ExpandReallocPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_EXPANDREALLOCPASS

inline void registerExpandReallocPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandReallocPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerExpandReallocPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandReallocPass();
  });
}

#undef GEN_PASS_REGISTRATION_EXPANDREALLOCPASS
#endif // GEN_PASS_REGISTRATION_EXPANDREALLOCPASS

//===----------------------------------------------------------------------===//
// ExpandStridedMetadataPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_EXPANDSTRIDEDMETADATAPASS

inline void registerExpandStridedMetadataPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandStridedMetadataPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerExpandStridedMetadataPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createExpandStridedMetadataPass();
  });
}

#undef GEN_PASS_REGISTRATION_EXPANDSTRIDEDMETADATAPASS
#endif // GEN_PASS_REGISTRATION_EXPANDSTRIDEDMETADATAPASS

//===----------------------------------------------------------------------===//
// FlattenMemrefsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_FLATTENMEMREFSPASS

inline void registerFlattenMemrefsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFlattenMemrefsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerFlattenMemrefsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFlattenMemrefsPass();
  });
}

#undef GEN_PASS_REGISTRATION_FLATTENMEMREFSPASS
#endif // GEN_PASS_REGISTRATION_FLATTENMEMREFSPASS

//===----------------------------------------------------------------------===//
// FoldMemRefAliasOpsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_FOLDMEMREFALIASOPSPASS

inline void registerFoldMemRefAliasOpsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFoldMemRefAliasOpsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerFoldMemRefAliasOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createFoldMemRefAliasOpsPass();
  });
}

#undef GEN_PASS_REGISTRATION_FOLDMEMREFALIASOPSPASS
#endif // GEN_PASS_REGISTRATION_FOLDMEMREFALIASOPSPASS

//===----------------------------------------------------------------------===//
// MemRefEmulateWideInt Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_MEMREFEMULATEWIDEINT

inline void registerMemRefEmulateWideInt() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createMemRefEmulateWideInt();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerMemRefEmulateWideIntPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createMemRefEmulateWideInt();
  });
}

#undef GEN_PASS_REGISTRATION_MEMREFEMULATEWIDEINT
#endif // GEN_PASS_REGISTRATION_MEMREFEMULATEWIDEINT

//===----------------------------------------------------------------------===//
// NormalizeMemRefsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_NORMALIZEMEMREFSPASS

inline void registerNormalizeMemRefsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createNormalizeMemRefsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerNormalizeMemRefsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createNormalizeMemRefsPass();
  });
}

#undef GEN_PASS_REGISTRATION_NORMALIZEMEMREFSPASS
#endif // GEN_PASS_REGISTRATION_NORMALIZEMEMREFSPASS

//===----------------------------------------------------------------------===//
// ReifyResultShapesPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_REIFYRESULTSHAPESPASS

inline void registerReifyResultShapesPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createReifyResultShapesPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerReifyResultShapesPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createReifyResultShapesPass();
  });
}

#undef GEN_PASS_REGISTRATION_REIFYRESULTSHAPESPASS
#endif // GEN_PASS_REGISTRATION_REIFYRESULTSHAPESPASS

//===----------------------------------------------------------------------===//
// ResolveRankedShapeTypeResultDimsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_RESOLVERANKEDSHAPETYPERESULTDIMSPASS

inline void registerResolveRankedShapeTypeResultDimsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createResolveRankedShapeTypeResultDimsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerResolveRankedShapeTypeResultDimsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createResolveRankedShapeTypeResultDimsPass();
  });
}

#undef GEN_PASS_REGISTRATION_RESOLVERANKEDSHAPETYPERESULTDIMSPASS
#endif // GEN_PASS_REGISTRATION_RESOLVERANKEDSHAPETYPERESULTDIMSPASS

//===----------------------------------------------------------------------===//
// ResolveShapedTypeResultDimsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_RESOLVESHAPEDTYPERESULTDIMSPASS

inline void registerResolveShapedTypeResultDimsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createResolveShapedTypeResultDimsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerResolveShapedTypeResultDimsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createResolveShapedTypeResultDimsPass();
  });
}

#undef GEN_PASS_REGISTRATION_RESOLVESHAPEDTYPERESULTDIMSPASS
#endif // GEN_PASS_REGISTRATION_RESOLVESHAPEDTYPERESULTDIMSPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// MemRef Registration
//===----------------------------------------------------------------------===//

inline void registerMemRefPasses() {
  registerExpandOpsPass();
  registerExpandReallocPass();
  registerExpandStridedMetadataPass();
  registerFlattenMemrefsPass();
  registerFoldMemRefAliasOpsPass();
  registerMemRefEmulateWideInt();
  registerNormalizeMemRefsPass();
  registerReifyResultShapesPass();
  registerResolveRankedShapeTypeResultDimsPass();
  registerResolveShapedTypeResultDimsPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class ExpandOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandOpsPassBase;

  ExpandOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandOpsPassBase(const ExpandOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandOpsPassBase& operator=(const ExpandOpsPassBase &) = delete;
  ExpandOpsPassBase(ExpandOpsPassBase &&) = delete;
  ExpandOpsPassBase& operator=(ExpandOpsPassBase &&) = delete;
  ~ExpandOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memref-expand");
  }
  ::llvm::StringRef getArgument() const override { return "memref-expand"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize memref operations to be convertible to LLVM.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandOpsPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class ExpandReallocPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandReallocPassBase;

  ExpandReallocPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandReallocPassBase(const ExpandReallocPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandReallocPassBase& operator=(const ExpandReallocPassBase &) = delete;
  ExpandReallocPassBase(ExpandReallocPassBase &&) = delete;
  ExpandReallocPassBase& operator=(ExpandReallocPassBase &&) = delete;
  ~ExpandReallocPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("expand-realloc");
  }
  ::llvm::StringRef getArgument() const override { return "expand-realloc"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Expand memref.realloc operations into its components)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandReallocPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandReallocPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<arith::ArithDialect>();
    registry.insert<scf::SCFDialect>();
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandReallocPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> emitDeallocs{*this, "emit-deallocs", ::llvm::cl::desc(R"PO(Emit deallocation operations for the original MemRef)PO"), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class ExpandStridedMetadataPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ExpandStridedMetadataPassBase;

  ExpandStridedMetadataPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ExpandStridedMetadataPassBase(const ExpandStridedMetadataPassBase &other) : ::mlir::OperationPass<>(other) {}
  ExpandStridedMetadataPassBase& operator=(const ExpandStridedMetadataPassBase &) = delete;
  ExpandStridedMetadataPassBase(ExpandStridedMetadataPassBase &&) = delete;
  ExpandStridedMetadataPassBase& operator=(ExpandStridedMetadataPassBase &&) = delete;
  ~ExpandStridedMetadataPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("expand-strided-metadata");
  }
  ::llvm::StringRef getArgument() const override { return "expand-strided-metadata"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Expand memref operations into easier to analyze constructs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExpandStridedMetadataPass");
  }
  ::llvm::StringRef getName() const override { return "ExpandStridedMetadataPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ExpandStridedMetadataPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class FlattenMemrefsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = FlattenMemrefsPassBase;

  FlattenMemrefsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  FlattenMemrefsPassBase(const FlattenMemrefsPassBase &other) : ::mlir::OperationPass<>(other) {}
  FlattenMemrefsPassBase& operator=(const FlattenMemrefsPassBase &) = delete;
  FlattenMemrefsPassBase(FlattenMemrefsPassBase &&) = delete;
  FlattenMemrefsPassBase& operator=(FlattenMemrefsPassBase &&) = delete;
  ~FlattenMemrefsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("flatten-memref");
  }
  ::llvm::StringRef getArgument() const override { return "flatten-memref"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Flatten a multiple dimensional memref to 1-dimensional)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FlattenMemrefsPass");
  }
  ::llvm::StringRef getName() const override { return "FlattenMemrefsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FlattenMemrefsPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class FoldMemRefAliasOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = FoldMemRefAliasOpsPassBase;

  FoldMemRefAliasOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  FoldMemRefAliasOpsPassBase(const FoldMemRefAliasOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  FoldMemRefAliasOpsPassBase& operator=(const FoldMemRefAliasOpsPassBase &) = delete;
  FoldMemRefAliasOpsPassBase(FoldMemRefAliasOpsPassBase &&) = delete;
  FoldMemRefAliasOpsPassBase& operator=(FoldMemRefAliasOpsPassBase &&) = delete;
  ~FoldMemRefAliasOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("fold-memref-alias-ops");
  }
  ::llvm::StringRef getArgument() const override { return "fold-memref-alias-ops"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Fold memref alias ops into consumer load/store ops)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FoldMemRefAliasOpsPass");
  }
  ::llvm::StringRef getName() const override { return "FoldMemRefAliasOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(FoldMemRefAliasOpsPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class MemRefEmulateWideIntBase : public ::mlir::OperationPass<> {
public:
  using Base = MemRefEmulateWideIntBase;

  MemRefEmulateWideIntBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  MemRefEmulateWideIntBase(const MemRefEmulateWideIntBase &other) : ::mlir::OperationPass<>(other) {}
  MemRefEmulateWideIntBase& operator=(const MemRefEmulateWideIntBase &) = delete;
  MemRefEmulateWideIntBase(MemRefEmulateWideIntBase &&) = delete;
  MemRefEmulateWideIntBase& operator=(MemRefEmulateWideIntBase &&) = delete;
  ~MemRefEmulateWideIntBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("memref-emulate-wide-int");
  }
  ::llvm::StringRef getArgument() const override { return "memref-emulate-wide-int"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate 2*N-bit integer operations using N-bit operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MemRefEmulateWideInt");
  }
  ::llvm::StringRef getName() const override { return "MemRefEmulateWideInt"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(MemRefEmulateWideIntBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> widestIntSupported{*this, "widest-int-supported", ::llvm::cl::desc(R"PO(Widest integer type supported by the target)PO"), ::llvm::cl::init(32)};
};

template <typename DerivedT>
class NormalizeMemRefsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = NormalizeMemRefsPassBase;

  NormalizeMemRefsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  NormalizeMemRefsPassBase(const NormalizeMemRefsPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}
  NormalizeMemRefsPassBase& operator=(const NormalizeMemRefsPassBase &) = delete;
  NormalizeMemRefsPassBase(NormalizeMemRefsPassBase &&) = delete;
  NormalizeMemRefsPassBase& operator=(NormalizeMemRefsPassBase &&) = delete;
  ~NormalizeMemRefsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("normalize-memrefs");
  }
  ::llvm::StringRef getArgument() const override { return "normalize-memrefs"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Normalize memrefs)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("NormalizeMemRefsPass");
  }
  ::llvm::StringRef getName() const override { return "NormalizeMemRefsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(NormalizeMemRefsPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class ReifyResultShapesPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ReifyResultShapesPassBase;

  ReifyResultShapesPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ReifyResultShapesPassBase(const ReifyResultShapesPassBase &other) : ::mlir::OperationPass<>(other) {}
  ReifyResultShapesPassBase& operator=(const ReifyResultShapesPassBase &) = delete;
  ReifyResultShapesPassBase(ReifyResultShapesPassBase &&) = delete;
  ReifyResultShapesPassBase& operator=(ReifyResultShapesPassBase &&) = delete;
  ~ReifyResultShapesPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("reify-result-shapes");
  }
  ::llvm::StringRef getArgument() const override { return "reify-result-shapes"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Reifies the results of `tensor::PadOp` and `tensor::ConcatOp`.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ReifyResultShapesPass");
  }
  ::llvm::StringRef getName() const override { return "ReifyResultShapesPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ReifyResultShapesPassBase<DerivedT>)

protected:
};

template <typename DerivedT>
class ResolveRankedShapeTypeResultDimsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ResolveRankedShapeTypeResultDimsPassBase;

  ResolveRankedShapeTypeResultDimsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ResolveRankedShapeTypeResultDimsPassBase(const ResolveRankedShapeTypeResultDimsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ResolveRankedShapeTypeResultDimsPassBase& operator=(const ResolveRankedShapeTypeResultDimsPassBase &) = delete;
  ResolveRankedShapeTypeResultDimsPassBase(ResolveRankedShapeTypeResultDimsPassBase &&) = delete;
  ResolveRankedShapeTypeResultDimsPassBase& operator=(ResolveRankedShapeTypeResultDimsPassBase &&) = delete;
  ~ResolveRankedShapeTypeResultDimsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("resolve-ranked-shaped-type-result-dims");
  }
  ::llvm::StringRef getArgument() const override { return "resolve-ranked-shaped-type-result-dims"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Resolve memref.dim of result values of ranked shape type)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ResolveRankedShapeTypeResultDimsPass");
  }
  ::llvm::StringRef getName() const override { return "ResolveRankedShapeTypeResultDimsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ResolveRankedShapeTypeResultDimsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> errorOnPatternIterationLimit{*this, "error-on-pattern-iteration-limit", ::llvm::cl::desc(R"PO(Throw an error when pattern rewriter hits iteration limit)PO"), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class ResolveShapedTypeResultDimsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ResolveShapedTypeResultDimsPassBase;

  ResolveShapedTypeResultDimsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ResolveShapedTypeResultDimsPassBase(const ResolveShapedTypeResultDimsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ResolveShapedTypeResultDimsPassBase& operator=(const ResolveShapedTypeResultDimsPassBase &) = delete;
  ResolveShapedTypeResultDimsPassBase(ResolveShapedTypeResultDimsPassBase &&) = delete;
  ResolveShapedTypeResultDimsPassBase& operator=(ResolveShapedTypeResultDimsPassBase &&) = delete;
  ~ResolveShapedTypeResultDimsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("resolve-shaped-type-result-dims");
  }
  ::llvm::StringRef getArgument() const override { return "resolve-shaped-type-result-dims"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Resolve memref.dim of result values)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ResolveShapedTypeResultDimsPass");
  }
  ::llvm::StringRef getName() const override { return "ResolveShapedTypeResultDimsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<affine::AffineDialect>();
    registry.insert<memref::MemRefDialect>();
    registry.insert<tensor::TensorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ResolveShapedTypeResultDimsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> errorOnPatternIterationLimit{*this, "error-on-pattern-iteration-limit", ::llvm::cl::desc(R"PO(Throw an error when pattern rewriter hits iteration limit)PO"), ::llvm::cl::init(true)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
