/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ROCDLOps.td                                                          *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir::ROCDL {

/// Vote across thread group
/// Ballot provides a bit mask containing the 1-bit predicate value from each lane.
///       The nth bit of the result contains the 1 bit contributed by the nth warp lane.
class BallotOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class BarrierInitOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class BarrierJoinOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class BarrierLeaveOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BarrierOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class BarrierSignalIsfirstOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BarrierSignalOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class BarrierSignalVarOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BarrierWaitOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockDimXOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockDimYOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockDimZOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockIdXOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockIdYOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class BlockIdZOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ClusterIdXOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ClusterIdYOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ClusterIdZOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert bf8 to f32
/// Convert 8-bit bf8 value from the `byteSel`th bit of `srcA` to fp32.
class CvtF32Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert fp8 to f32
/// Convert 8-bit fp8 value from the `byteSel`th bit of `srcA` to fp32.
class CvtF32Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert two f32's to bf8
/// Convert `srcA` and `srcB` to bf8 and store into the low/high word of
///     `old`, preserving the other word.
class CvtPkBf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert packed bf8 to packed f32
/// Convert `src` based on $wordSel to packed fp32,
class CvtPkF32Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert packed fp8 to packed f32
/// Convert `src` based on $wordSel to packed fp32.
class CvtPkF32Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert two f32's to fp8
/// Convert `srcA` and `srcB` to fp8 and store into the low/high word of
///     `old`, preserving the other word.
class CvtPkFp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert two f32 input into a vector<2xf16>
/// Convert two f32 values into a packed vector<2xf16>.
class CvtPkRtz;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 bf6 and converts them to 16 bf16.
/// Available on gfx1250+.
class CvtPkScalePk16Bf16Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 fp6 and converts them to 16 bf16.
/// Available on gfx1250+.
class CvtPkScalePk16Bf16Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 bf6 and converts them to 16 f16.
/// Available on gfx1250+.
class CvtPkScalePk16F16Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 fp6 and converts them to 16 f16.
/// Available on gfx1250+.
class CvtPkScalePk16F16Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 bf6 and converts them to 16 f32.
/// Available on gfx1250+.
class CvtPkScalePk16F32Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 16 fp6 and converts them to 16 f32.
/// Available on gfx1250+.
class CvtPkScalePk16F32Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 bf8 and converts them to 8 bf16.
/// Available on gfx1250+.
class CvtPkScalePk8Bf16Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp4 and converts them to 8 bf16.
/// Available on gfx1250+.
class CvtPkScalePk8Bf16Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp8 and converts them to 8 bf16.
/// Available on gfx1250+.
class CvtPkScalePk8Bf16Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 bf8 and converts them to 8 f16.
/// Available on gfx1250+.
class CvtPkScalePk8F16Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp4 and converts them to 8 f16.
/// Available on gfx1250+.
class CvtPkScalePk8F16Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp8 and converts them to 8 f16.
/// Available on gfx1250+.
class CvtPkScalePk8F16Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 bf8 and converts them to 8 f32.
/// Available on gfx1250+.
class CvtPkScalePk8F32Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp4 and converts them to 8 f32.
/// Available on gfx1250+.
class CvtPkScalePk8F32Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scales 8 fp8 and converts them to 8 f32.
/// Available on gfx1250+.
class CvtPkScalePk8F32Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two vector<16xf32> to 32 packed bf6
/// Convert 32 single-precision float values, packed into two length-16
///       vectors that will be logically concanenated, to packed bf6, dividing by the exponent part of `scale`
///       before doing so.
class CvtScaleF322xPk16Bf6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two vector<16xf32> to 32 packed fp6
/// Convert 32 single-precision float values, packed into two length-16
///       vectors that will be logically concanenated, to packed fp6, dividing by the exponent part of `scale`
///       before doing so.
class CvtScaleF322xPk16Fp6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert bf8 from packed vector to f16, updating tied result
/// Convert a bf8 byte from `src`, selected by
///       `srcSelIndex`, to f16 while multiplying it by the expontent of `scale`,
///       and place it into the `dstLoHiSel`th bit
///       of `oldVdst` preserving the other element of that vector in
///       the return value.
/// 
///       The bytes are stored as an `i32` and not a `<4 x i8>`.
class CvtScaleF32F16Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert fp8 from packed vector to f16, updating tied result
/// Convert a fp8 byte from `src`, selected by
///       `srcSelIndex`, to f16 while multiplying it by the expontent of `scale`,
///       and place it into the `dstLoHiSel`th bit
///       of `oldVdst` preserving the other element of that vector in
///       the return value.
/// 
///       The bytes are stored as an `i32` and not a `<4 x i8>`.
class CvtScaleF32F16Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert bf8 from packed vector to f32
/// Convert a bf8 byte from `src`, selected by
///       `srcSelIndex`, to f32, multiplying it by the exponent of `scale`.
/// 
///       The bytes are stored in an `i32`, not a `<4 x i8>`.
class CvtScaleF32F32Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert fp8 from packed vector to f32
/// Convert a fp8 byte from `src`, selected by
///       `srcSelIndex`, to f32, multiplying it by the exponent of `scale`.
/// 
///       The bytes are stored in an `i32`, not a `<4 x i8>`.
class CvtScaleF32F32Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf6
/// Convert 8 packed bf16 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Bf6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf6
/// Convert 8 packed f16 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Bf6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed bf6
/// Convert 8 packed f32 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Bf6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp6
/// Convert 8 packed bf16 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Fp6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp6
/// Convert 8 packed f16 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Fp6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp6
/// Convert 8 packed f32 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk16Fp6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf6 to packed bf16
/// Convert 32 packed bf6 values to packed bf16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32Bf16Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed fp6 to packed bf16
/// Convert 32 packed fp6 values to packed bf16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32Bf16Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf6
/// Convert 32 packed bf16 values to packed bf6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Bf6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf6
/// Convert 32 packed f16 values to packed bf6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Bf6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf6 to packed f16
/// Convert 32 packed bf6 values to packed f16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F16Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed fp6 to packed f16
/// Convert 32 packed fp6 values to packed f16, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F16Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf6 to packed f32
/// Convert 32 packed bf6 values to packed f32, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F32Bf6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed fp6 to packed f32
/// Convert 32 packed fp6 values to packed f32, multiplying by the exponent part of `scale`
///         before doing so.
class CvtScaleF32Pk32F32Fp6Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp6
/// Convert 32 packed bf16 values to packed fp6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Fp6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp6
/// Convert 32 packed f16 values to packed fp6, dividing by the exponent part of `scale`
///           before doing so.
class CvtScaleF32Pk32Fp6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf8
/// Convert 8 packed bf16 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Bf8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf8
/// Convert 8 packed f16 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Bf8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed bf8
/// Convert 8 packed f32 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Bf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp4
/// Convert 8 packed bf16 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp4Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp4
/// Convert 8 packed f16 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp4F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp4
/// Convert 8 packed f32 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp4F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp8
/// Convert 8 packed bf16 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp8
/// Convert 8 packed f16 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp8
/// Convert 8 packed f32 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so. This op is for gfx1250+ arch.
class CvtScaleF32Pk8Fp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two bf8to two bf16
/// Convert two packed bf8 values in `src0` to two bf16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkBf16Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two packed fp4 to packed bf16
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed bf16, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkBf16Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two fp8to two bf16
/// Convert two packed fp8 values in `src0` to two bf16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkBf16Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two bf16to two bf8, updating packed vector
/// Convert two bf16 values in `src0` to two bf8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkBf8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two f16to two bf8, updating packed vector
/// Convert two f16 values in `src0` to two bf8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkBf8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two f32 to two bf8, updating packed vector
/// Convert two f32 values in `src0` and `src1` to two bf8 bytes,
///       dividing by the exponent in `scale`. The bytes are packed into
///       a 16-bit value which is inserted into `oldVdst` at the `dstLoHiSel`
///       position, with the entire updated vector being returned.
class CvtScaleF32PkBf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two bf8to two f16
/// Convert two packed bf8 values in `src0` to two f16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF16Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two packed fp4 to packed f16
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed f16, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkF16Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two fp8to two f16
/// Convert two packed fp8 values in `src0` to two f16 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF16Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two bf8to two f32
/// Convert two packed bf8 values in `src0` to two f32 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF32Bf8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two packed fp4 to packed f32
/// Convert two packed fp4 (f4E2M1) values  stored as one byte of a 32-bit integer
///       to packed f32, multiplying by the exponent part of `scale`
///       before doing so.
/// 
///       The byte to convert is chosen by `srcSelIndex`.
class CvtScaleF32PkF32Fp4Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two fp8to two f32
/// Convert two packed fp8 values in `src0` to two f32 values, multiplying by the exponent in `scale`.
///         The two values to be converted are selected from the low or high half
///         of `src` (a packed vector represented as an `i32`)
///         on the basis of `srcLoHiSel`.
class CvtScaleF32PkF32Fp8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two bf16 to packed fp4, updating tied vector
/// Convert two packed bf16 values to packed
///         fp4, dividing by the exponent part of `scale`
///         before doing so.
/// 
///         The two scaled values are packed  into a byte.
///         That byte is used to update the `dstSelIndex`th
///         byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two f16 to packed fp4, updating tied vector
/// Convert two packed f16 values to packed
///         fp4, dividing by the exponent part of `scale`
///         before doing so.
/// 
///         The two scaled values are packed  into a byte.
///         That byte is used to update the `dstSelIndex`th
///         byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two f32 values to two packed fp4, updating tied vector
/// Convert two single-precision float values, passed in `src0` and `src1`
///     into two fp4 values, dividing them by the expontent part of `scale`
///     before doing so.
/// 
///     The two scaled values are packed  into a byte.
///     That byte is used to update the `dstSelIndex`th
///     byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32PkFp4F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two bf16to two fp8, updating packed vector
/// Convert two bf16 values in `src0` to two fp8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkFp8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two f16to two fp8, updating packed vector
/// Convert two f16 values in `src0` to two fp8 bytes, dividing by the exponent in `scale`. The bytes are
///         packed into a 16-bit value which is inserted into `oldVdst` at the
///         `dstLoHiSel` position, with the entire updated vector being returned.
class CvtScaleF32PkFp8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert two f32 to two fp8, updating packed vector
/// Convert two f32 values in `src0` and `src1` to two fp8 bytes,
///       dividing by the exponent in `scale`. The bytes are packed into
///       a 16-bit value which is inserted into `oldVdst` at the `dstLoHiSel`
///       position, with the entire updated vector being returned.
class CvtScaleF32PkFp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert bf16to bf8 with stochiastic rounding, updating packed vector
/// Convert a bf16 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8BF16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert f16to bf8 with stochiastic rounding, updating packed vector
/// Convert a f16 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert f32to bf8 with stochiastic rounding, updating packed vector
/// Convert a f32 value in `src0` to a bf8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrBf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert bf16to fp8 with stochiastic rounding, updating packed vector
/// Convert a bf16 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8BF16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert f16to fp8 with stochiastic rounding, updating packed vector
/// Convert a f16 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scaled convert f32to fp8 with stochiastic rounding, updating packed vector
/// Convert a f32 value in `src0` to a fp8 bytes, dividing by the exponent in `scale` and using `seed`
///         for stochiastic rounding. Place the resulting byte in the
///         `dstSelIndex`th bit of `oldVdst` and return the entire packed vector,
///         which is stored as an `i32`.
class CvtScaleF32SrFp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf6 with stochastic rounding
/// Convert 8 packed bf16 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Bf6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf6 with stochastic rounding
/// Convert 8 packed f16 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Bf6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed bf6 with stochastic rounding
/// Convert 8 packed f32 values to packed bf6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Bf6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp6 with stochastic rounding
/// Convert 8 packed bf16 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Fp6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp6 with stochastic rounding
/// Convert 8 packed f16 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Fp6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp6 with stochastic rounding
/// Convert 8 packed f32 values to packed fp6, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk16Fp6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf6 with stochiastic rounding
/// Convert 32 packed bf16 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf6 with stochiastic rounding
/// Convert 32 packed f16 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed bf6 with stochiastic rounding
/// Convert 32 packed f32 values to packed bf6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Bf6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp6 with stochiastic rounding
/// Convert 32 packed bf16 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp6 with stochiastic rounding
/// Convert 32 packed f16 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp6 with stochiastic rounding
/// Convert 32 packed f32 values to packed fp6, dividing by the exponent part of `scale`
///         before doing so and applying random rounding derived from
///         `seed`.
class CvtScaleF32SrPk32Fp6F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed bf8 with stochastic rounding
/// Convert 8 packed bf16 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Bf8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed bf8 with stochastic rounding
/// Convert 8 packed f16 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Bf8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed bf8 with stochastic rounding
/// Convert 8 packed f32 values to packed bf8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Bf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp4 with stochastic rounding
/// Convert 8 packed bf16 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp4Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp4 with stochastic rounding
/// Convert 8 packed f16 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp4F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp4 with stochastic rounding
/// Convert 8 packed f32 values to packed fp4, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp4F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed bf16 to packed fp8 with stochastic rounding
/// Convert 8 packed bf16 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp8Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f16 to packed fp8 with stochastic rounding
/// Convert 8 packed f16 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp8F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert packed f32 to packed fp8 with stochastic rounding
/// Convert 8 packed f32 values to packed fp8, multiplying by the exponent part of `scale`
///         before doing so and apply stochastic rounding. This op is for gfx1250+ arch.
class CvtScaleF32SrPk8Fp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two bf16 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed bf16 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4Bf16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two f16 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed f16 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4F16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Scale and convert two f32 to packed fp4 with stochiastic rounding, updating tied vector
/// Convert two packed f32 values to packed
///       fp4, dividing by the exponent part of `scale`
///       before doing so and using `seed` as the random seed for
///       stochiastic rounding.
/// 
///       The two scaled values are packed (little-endian)
///       into a byte. That byte is used to update the `dstSelIndex`th
///       byte of `oldVdst`, which is returned in its entirity.
class CvtScaleF32SrPkFp4F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert f32 to bf8, stochiastic rounding
/// Convert `srcA` to bf8, adding the rounding factor from `srcB`,
///     and store into the `byteSel`th byte of `old`, preserving the others.
class CvtSrBf8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Convert f32 to fp8, stochiastic rounding
/// Convert `srcA` to fp8, adding the rounding factor from `srcB`,
///     and store into the `byteSel`th byte of `old`, preserving the others.
class CvtSrFp8F32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class DPPUpdateOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class DsBpermuteOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from ds memory to registers (available in gfx1250+).
/// Load a matrix of 16-bit data from the ds memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 128-bit vector register.
/// 
///     Available in gfx1250+.
class DsLoadTr16_B128;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from ds memory to registers (available in gfx1250+).
/// Load a matrix of 4-bit data from the ds memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 64-bit vector register.
/// 
///     Available in gfx1250+.
class DsLoadTr4_B64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from ds memory to registers (available in gfx1250+).
/// Load a matrix of 6-bit data from the ds memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 96-bit vector register.
/// 
///     Available in gfx1250+.
class DsLoadTr6_B96;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from ds memory to registers (available in gfx1250+).
/// Load a matrix of 8-bit data from the ds memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 64-bit vector register.
/// 
///     Available in gfx1250+.
class DsLoadTr8_B64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class DsSwizzleOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Median of three float/half values
/// Computes the median of three floating-point values using the AMDGPU fmed3 intrinsic.
///     This operation is equivalent to `max(min(a, b), min(max(a, b), c))` but uses the
///     hardware-accelerated V_MED3_F16/V_MED3_F32 instruction for better performance.
///     
///     The operation supports both scalar and vector floating-point types (f16, f32).
///     
///     Example:
///     ```mlir
///     // Scalar f32 median
///     %result = rocdl.fmed3 %a, %b, %c : f32
///     
///     // Vector f16 median
///     %result = rocdl.fmed3 %va, %vb, %vc : vector<4xf16>
///     ```
class FMed3Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class GetBarrierStateOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Available on gfx1250+.
class GetNamedBarrierStateOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Asynchronously loads 128 bits of data from a global memory pointer
///       to a Local Data Share (LDS) pointer.
/// 
///       Available on gfx1250+.
class GlobalLoadAsyncToLDSB128Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Asynchronously loads 32 bits of data from a global memory pointer
///       to a Local Data Share (LDS) pointer.
/// 
///       Available on gfx1250+.
class GlobalLoadAsyncToLDSB32Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Asynchronously loads 64 bits of data from a global memory pointer
///       to a Local Data Share (LDS) pointer.
/// 
///       Available on gfx1250+.
class GlobalLoadAsyncToLDSB64Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Asynchronously loads 8 bits of data from a global memory pointer
///       to a Local Data Share (LDS) pointer.
/// 
///       Available on gfx1250+.
class GlobalLoadAsyncToLDSB8Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class GlobalLoadLDSOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from global memory to registers (available in gfx1250+).
/// Load a matrix of 4-bit data from the global memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 64-bit vector register.
/// 
///     Available in gfx1250+.
class GlobalLoadTr4_B64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from global memory to registers (available in gfx1250+).
/// Load a matrix of 6-bit data from the global memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 96-bit vector register.
/// 
///     Available in gfx1250+.
class GlobalLoadTr6_B96;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from global memory to registers (available in gfx1250+).
/// Load a matrix of 16-bit data from the global memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 128-bit vector register.
/// 
///     Available in gfx1250+.
class GlobalLoadTr8_B128;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Loads and transposes a matrix from global memory to registers (available in gfx1250+).
/// Load a matrix of 8-bit data from the global memory,
///     transpose data between row-major and column-major order,
///     and store the result into a 64-bit vector register.
/// 
///     Available in gfx1250+.
class GlobalLoadTr8_B64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class GridDimXOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class GridDimYOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class GridDimZOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class IglpOpt;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class LoadToLDSOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class MakeBufferRsrcOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class MbcntHiOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class MbcntLoOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Performs a `permlane16.swap` operation with the given operands, applying the
///     permutation specified by $fi to the provided inputs.
class Permlane16SwapOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Performs a `permlane32.swap` operation with the given operands, applying the
///     permutation specified by $fi to the provided inputs.
class Permlane32SwapOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Performs a `permlanex16` operation with the given operands, applying the
///     permutation specified by $fi to the provided inputs.
class PermlaneX16Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferAtomicCmpSwap;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferAtomicFAddOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferAtomicFMaxOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferAtomicSMaxOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferAtomicUMinOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferLoadOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawBufferStoreOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferAtomicCmpSwap;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferAtomicFaddOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferAtomicFmaxOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferAtomicSmaxOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferAtomicUminOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferLoadLdsOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferLoadOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class RawPtrBufferStoreOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Get the value in first active lane.
/// Returns the value in the lowest active lane of the input operand.
class ReadfirstlaneOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Get the value in the specific lane.
/// Get the value in lane `src1` from input `src0`.
class ReadlaneOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SBarrierOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SSleepOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SWaitcntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SchedBarrier;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SchedGroupBarrier;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class SetPrioOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Base class for ROCDL tensor load/store to/from LDS (D2 variant).
/// Moves tiles of tensor data between global memory and LDS. The tile is
///     described by the $dgroup descriptors. 2 $dgroup descriptors allows for
///     movement of up to 2D tensors. $cachePolicy describes the memory scope and an
///     indicator of expected data re-use.
/// 
///     This op is for gfx1250+ architectures.
class TensorLoadToLDSD2Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Base class for ROCDL tensor load/store to/from LDS.
/// Moves tiles of tensor data between global memory and LDS. The tile is
///     described by the $dgroup descriptors. 4 $dgroup descriptors allows for
///     movement of up to 5D tensors. $cachePolicy describes the memory scope and an
///     indicator of expected data re-use.
/// 
///     This op is for gfx1250+ architectures.
class TensorLoadToLDSOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Base class for ROCDL tensor load/store to/from LDS (D2 variant).
/// Moves tiles of tensor data between global memory and LDS. The tile is
///     described by the $dgroup descriptors. 2 $dgroup descriptors allows for
///     movement of up to 2D tensors. $cachePolicy describes the memory scope and an
///     indicator of expected data re-use.
/// 
///     This op is for gfx1250+ architectures.
class TensorStoreFromLDSD2Op;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Base class for ROCDL tensor load/store to/from LDS.
/// Moves tiles of tensor data between global memory and LDS. The tile is
///     described by the $dgroup descriptors. 4 $dgroup descriptors allows for
///     movement of up to 5D tensors. $cachePolicy describes the memory scope and an
///     indicator of expected data re-use.
/// 
///     This op is for gfx1250+ architectures.
class TensorStoreFromLDSOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ThreadIdXOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ThreadIdYOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ThreadIdZOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until ASYNCCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx1250+.
class WaitAsynccntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until DSCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitDscntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until EXPCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitExpcntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until LOADCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitLoadcntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until STORECNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx12+.
class WaitStorecntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

/// Wait until TENSORCNT is less than or equal to `count`
/// Wait for the counter specified to be less-than or equal-to the `count`
///       before continuing.
/// 
///       Available on gfx1250+.
class WaitTensorcntOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class WavefrontSizeOp;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ds_read_tr16_b64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ds_read_tr4_b64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ds_read_tr6_b96;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class ds_read_tr8_b64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x16bf16_1k;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x16f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x1f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x2bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x32_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x4bf16_1k;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x4f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x4f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x8_xf32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_16x16x8bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x16_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x1f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x2bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x2f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x4_xf32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x4bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x4bf16_1k;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x4f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x8bf16_1k;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_32x32x8f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_4x4x1f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_4x4x2bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_4x4x4bf16_1k;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f32_4x4x4f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f64_16x16x4f64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_f64_4x4x4f64;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_16x16x16i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_16x16x32_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_16x16x4i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_16x16x64_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_32x32x16_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_32x32x32_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_32x32x4i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_32x32x8i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_i32_4x4x4i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_scale_f32_16x16x128_f8f6f4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class mfma_scale_f32_32x32x64_f8f6f4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x32_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x32_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x64_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x64_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x64_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_16x16x64_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x16_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x16_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x32_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x32_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x32_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_f32_32x32x32_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_i32_16x16x64_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class smfmac_i32_32x32x32_i8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_bf16_16x16x16_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_bf16_16x16x32_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_bf16f32_16x16x32_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x128_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x128_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x128_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x128_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x16_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x32_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x64_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x64_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x64_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f16_16x16x64_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x128_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x128_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x128_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x128_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x16_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x32_bf16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x32_f16;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x4_f32;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x64_bf8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x64_bf8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x64_fp8_bf8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_f32_16x16x64_fp8_fp8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_i32_16x16x16_iu4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_i32_16x16x16_iu8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_i32_16x16x32_iu4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_i32_16x16x64_iu8;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_scale16_f32_16x16x128_f8f6f4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_scale16_f32_32x16x128_f4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_scale_f32_16x16x128_f8f6f4;

} // namespace mlir::ROCDL
namespace mlir::ROCDL {

class wmma_scale_f32_32x16x128_f4;

} // namespace mlir::ROCDL
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BallotOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BallotOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BallotOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.ballot", odsAttrs.getContext());
  }

  BallotOpGenericAdaptorBase(BallotOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BallotOpGenericAdaptor : public detail::BallotOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BallotOpGenericAdaptorBase;
  static constexpr int odsIndex_pred = 0;
public:
  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BallotOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BallotOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BallotOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BallotOpGenericAdaptor(RangeT values, const BallotOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BallotOp, typename = std::enable_if_t<std::is_same_v<LateInst, BallotOp>>>
  BallotOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPred() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BallotOpAdaptor : public BallotOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BallotOpGenericAdaptor::BallotOpGenericAdaptor;
  BallotOpAdaptor(BallotOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BallotOp : public ::mlir::Op<BallotOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BallotOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BallotOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_pred = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.ballot");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPredMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value pred);
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value pred);
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BallotOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BallotOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BallotOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierInitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierInitOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierInitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.init", odsAttrs.getContext());
  }

  BarrierInitOpGenericAdaptorBase(BarrierInitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint32_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierInitOpGenericAdaptor : public detail::BarrierInitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierInitOpGenericAdaptorBase;
  static constexpr int odsIndex_ptr = 0;
public:
  BarrierInitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierInitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierInitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierInitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierInitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierInitOpGenericAdaptor(RangeT values, const BarrierInitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierInitOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierInitOp>>>
  BarrierInitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPtr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierInitOpAdaptor : public BarrierInitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierInitOpGenericAdaptor::BarrierInitOpGenericAdaptor;
  BarrierInitOpAdaptor(BarrierInitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierInitOp : public ::mlir::Op<BarrierInitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierInitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierInitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ptr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.init");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint32_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, uint32_t id);
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, uint32_t id);
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, uint32_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierInitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierInitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierInitOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierJoinOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierJoinOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierJoinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.join", odsAttrs.getContext());
  }

  BarrierJoinOpGenericAdaptorBase(BarrierJoinOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BarrierJoinOpGenericAdaptor : public detail::BarrierJoinOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierJoinOpGenericAdaptorBase;
  static constexpr int odsIndex_ptr = 0;
public:
  BarrierJoinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierJoinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierJoinOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierJoinOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierJoinOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierJoinOpGenericAdaptor(RangeT values, const BarrierJoinOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierJoinOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierJoinOp>>>
  BarrierJoinOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPtr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierJoinOpAdaptor : public BarrierJoinOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierJoinOpGenericAdaptor::BarrierJoinOpGenericAdaptor;
  BarrierJoinOpAdaptor(BarrierJoinOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierJoinOp : public ::mlir::Op<BarrierJoinOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierJoinOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierJoinOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ptr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.join");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr);
  static BarrierJoinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr);
  static BarrierJoinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr);
  static BarrierJoinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr);
  static BarrierJoinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierJoinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierJoinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierJoinOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierJoinOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierJoinOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierLeaveOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierLeaveOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierLeaveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.leave", odsAttrs.getContext());
  }

  BarrierLeaveOpGenericAdaptorBase(BarrierLeaveOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint16_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierLeaveOpGenericAdaptor : public detail::BarrierLeaveOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierLeaveOpGenericAdaptorBase;
public:
  BarrierLeaveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierLeaveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierLeaveOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierLeaveOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierLeaveOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierLeaveOpGenericAdaptor(RangeT values, const BarrierLeaveOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierLeaveOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierLeaveOp>>>
  BarrierLeaveOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierLeaveOpAdaptor : public BarrierLeaveOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierLeaveOpGenericAdaptor::BarrierLeaveOpGenericAdaptor;
  BarrierLeaveOpAdaptor(BarrierLeaveOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierLeaveOp : public ::mlir::Op<BarrierLeaveOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierLeaveOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierLeaveOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.leave");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint16_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint16_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr id);
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr id);
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint16_t id);
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint16_t id);
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, uint16_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint16_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierLeaveOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierLeaveOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierLeaveOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.barrier", odsAttrs.getContext());
  }

  BarrierOpGenericAdaptorBase(BarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BarrierOpGenericAdaptor : public detail::BarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierOpGenericAdaptorBase;
public:
  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierOpGenericAdaptor(RangeT values, const BarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierOp>>>
  BarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierOpAdaptor : public BarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierOpGenericAdaptor::BarrierOpGenericAdaptor;
  BarrierOpAdaptor(BarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierOp : public ::mlir::Op<BarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierSignalIsfirstOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierSignalIsfirstOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierSignalIsfirstOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.signal.isfirst", odsAttrs.getContext());
  }

  BarrierSignalIsfirstOpGenericAdaptorBase(BarrierSignalIsfirstOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint32_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierSignalIsfirstOpGenericAdaptor : public detail::BarrierSignalIsfirstOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierSignalIsfirstOpGenericAdaptorBase;
public:
  BarrierSignalIsfirstOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierSignalIsfirstOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierSignalIsfirstOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierSignalIsfirstOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierSignalIsfirstOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierSignalIsfirstOpGenericAdaptor(RangeT values, const BarrierSignalIsfirstOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierSignalIsfirstOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierSignalIsfirstOp>>>
  BarrierSignalIsfirstOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierSignalIsfirstOpAdaptor : public BarrierSignalIsfirstOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierSignalIsfirstOpGenericAdaptor::BarrierSignalIsfirstOpGenericAdaptor;
  BarrierSignalIsfirstOpAdaptor(BarrierSignalIsfirstOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierSignalIsfirstOp : public ::mlir::Op<BarrierSignalIsfirstOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierSignalIsfirstOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierSignalIsfirstOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.signal.isfirst");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint32_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::IntegerAttr id);
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::IntegerAttr id);
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, uint32_t id);
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, uint32_t id);
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, uint32_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalIsfirstOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalIsfirstOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierSignalIsfirstOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierSignalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierSignalOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierSignalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.signal", odsAttrs.getContext());
  }

  BarrierSignalOpGenericAdaptorBase(BarrierSignalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint32_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierSignalOpGenericAdaptor : public detail::BarrierSignalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierSignalOpGenericAdaptorBase;
public:
  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierSignalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierSignalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierSignalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierSignalOpGenericAdaptor(RangeT values, const BarrierSignalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierSignalOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierSignalOp>>>
  BarrierSignalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierSignalOpAdaptor : public BarrierSignalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierSignalOpGenericAdaptor::BarrierSignalOpGenericAdaptor;
  BarrierSignalOpAdaptor(BarrierSignalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierSignalOp : public ::mlir::Op<BarrierSignalOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierSignalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierSignalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.signal");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint32_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint32_t id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint32_t id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, uint32_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t id);
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierSignalOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierSignalVarOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierSignalVarOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierSignalVarOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.signal.var", odsAttrs.getContext());
  }

  BarrierSignalVarOpGenericAdaptorBase(BarrierSignalVarOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint32_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierSignalVarOpGenericAdaptor : public detail::BarrierSignalVarOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierSignalVarOpGenericAdaptorBase;
  static constexpr int odsIndex_ptr = 0;
public:
  BarrierSignalVarOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierSignalVarOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierSignalVarOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierSignalVarOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierSignalVarOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierSignalVarOpGenericAdaptor(RangeT values, const BarrierSignalVarOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierSignalVarOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierSignalVarOp>>>
  BarrierSignalVarOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getPtr() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierSignalVarOpAdaptor : public BarrierSignalVarOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierSignalVarOpGenericAdaptor::BarrierSignalVarOpGenericAdaptor;
  BarrierSignalVarOpAdaptor(BarrierSignalVarOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierSignalVarOp : public ::mlir::Op<BarrierSignalVarOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierSignalVarOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierSignalVarOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ptr = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.signal.var");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> getPtr() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getPtrMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint32_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, uint32_t id);
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value ptr, uint32_t id);
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value ptr, uint32_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, uint32_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalVarOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierSignalVarOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierSignalVarOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BarrierWaitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BarrierWaitOpGenericAdaptorBase {
public:
  struct Properties {
    using idTy = ::mlir::IntegerAttr;
    idTy id;

    auto getId() const {
      auto &propStorage = this->id;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setId(const ::mlir::IntegerAttr &propValue) {
      this->id = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.id == this->id &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BarrierWaitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.s.barrier.wait", odsAttrs.getContext());
  }

  BarrierWaitOpGenericAdaptorBase(BarrierWaitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
    return attr;
  }

  uint16_t getId();
};

} // namespace detail
template <typename RangeT>
class BarrierWaitOpGenericAdaptor : public detail::BarrierWaitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BarrierWaitOpGenericAdaptorBase;
public:
  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BarrierWaitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BarrierWaitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BarrierWaitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BarrierWaitOpGenericAdaptor(RangeT values, const BarrierWaitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BarrierWaitOp, typename = std::enable_if_t<std::is_same_v<LateInst, BarrierWaitOp>>>
  BarrierWaitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BarrierWaitOpAdaptor : public BarrierWaitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BarrierWaitOpGenericAdaptor::BarrierWaitOpGenericAdaptor;
  BarrierWaitOpAdaptor(BarrierWaitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BarrierWaitOp : public ::mlir::Op<BarrierWaitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BarrierWaitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BarrierWaitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("id")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.s.barrier.wait");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().id);
  }

  uint16_t getId();
  void setIdAttr(::mlir::IntegerAttr attr) {
    getProperties().id = attr;
  }

  void setId(uint16_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint16_t id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, uint16_t id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, uint16_t id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint16_t id);
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint16_t id);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierWaitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BarrierWaitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BarrierWaitOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.x", odsAttrs.getContext());
  }

  BlockDimXOpGenericAdaptorBase(BlockDimXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimXOpGenericAdaptor : public detail::BlockDimXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimXOpGenericAdaptorBase;
public:
  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimXOpGenericAdaptor(RangeT values, const BlockDimXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimXOp>>>
  BlockDimXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimXOpAdaptor : public BlockDimXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimXOpGenericAdaptor::BlockDimXOpGenericAdaptor;
  BlockDimXOpAdaptor(BlockDimXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimXOp : public ::mlir::Op<BlockDimXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimXOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.y", odsAttrs.getContext());
  }

  BlockDimYOpGenericAdaptorBase(BlockDimYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimYOpGenericAdaptor : public detail::BlockDimYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimYOpGenericAdaptorBase;
public:
  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimYOpGenericAdaptor(RangeT values, const BlockDimYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimYOp>>>
  BlockDimYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimYOpAdaptor : public BlockDimYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimYOpGenericAdaptor::BlockDimYOpGenericAdaptor;
  BlockDimYOpAdaptor(BlockDimYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimYOp : public ::mlir::Op<BlockDimYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimYOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockDimZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockDimZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockDimZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.dim.z", odsAttrs.getContext());
  }

  BlockDimZOpGenericAdaptorBase(BlockDimZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockDimZOpGenericAdaptor : public detail::BlockDimZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockDimZOpGenericAdaptorBase;
public:
  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockDimZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockDimZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockDimZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockDimZOpGenericAdaptor(RangeT values, const BlockDimZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockDimZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockDimZOp>>>
  BlockDimZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockDimZOpAdaptor : public BlockDimZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockDimZOpGenericAdaptor::BlockDimZOpGenericAdaptor;
  BlockDimZOpAdaptor(BlockDimZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockDimZOp : public ::mlir::Op<BlockDimZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockDimZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockDimZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.dim.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockDimZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockDimZOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.x", odsAttrs.getContext());
  }

  BlockIdXOpGenericAdaptorBase(BlockIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdXOpGenericAdaptor : public detail::BlockIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdXOpGenericAdaptorBase;
public:
  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdXOpGenericAdaptor(RangeT values, const BlockIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdXOp>>>
  BlockIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdXOpAdaptor : public BlockIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdXOpGenericAdaptor::BlockIdXOpGenericAdaptor;
  BlockIdXOpAdaptor(BlockIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdXOp : public ::mlir::Op<BlockIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdXOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.y", odsAttrs.getContext());
  }

  BlockIdYOpGenericAdaptorBase(BlockIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdYOpGenericAdaptor : public detail::BlockIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdYOpGenericAdaptorBase;
public:
  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdYOpGenericAdaptor(RangeT values, const BlockIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdYOp>>>
  BlockIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdYOpAdaptor : public BlockIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdYOpGenericAdaptor::BlockIdYOpGenericAdaptor;
  BlockIdYOpAdaptor(BlockIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdYOp : public ::mlir::Op<BlockIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdYOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::BlockIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BlockIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.workgroup.id.z", odsAttrs.getContext());
  }

  BlockIdZOpGenericAdaptorBase(BlockIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class BlockIdZOpGenericAdaptor : public detail::BlockIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockIdZOpGenericAdaptorBase;
public:
  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockIdZOpGenericAdaptor(RangeT values, const BlockIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockIdZOp>>>
  BlockIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockIdZOpAdaptor : public BlockIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockIdZOpGenericAdaptor::BlockIdZOpGenericAdaptor;
  BlockIdZOpAdaptor(BlockIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockIdZOp : public ::mlir::Op<BlockIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.workgroup.id.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::BlockIdZOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::ClusterIdXOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdXOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdXOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cluster.id.x", odsAttrs.getContext());
  }

  ClusterIdXOpGenericAdaptorBase(ClusterIdXOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdXOpGenericAdaptor : public detail::ClusterIdXOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdXOpGenericAdaptorBase;
public:
  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdXOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdXOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdXOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdXOpGenericAdaptor(RangeT values, const ClusterIdXOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdXOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdXOp>>>
  ClusterIdXOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdXOpAdaptor : public ClusterIdXOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdXOpGenericAdaptor::ClusterIdXOpGenericAdaptor;
  ClusterIdXOpAdaptor(ClusterIdXOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdXOp : public ::mlir::Op<ClusterIdXOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdXOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdXOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cluster.id.x");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdXOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdXOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::ClusterIdXOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::ClusterIdYOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdYOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdYOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cluster.id.y", odsAttrs.getContext());
  }

  ClusterIdYOpGenericAdaptorBase(ClusterIdYOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdYOpGenericAdaptor : public detail::ClusterIdYOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdYOpGenericAdaptorBase;
public:
  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdYOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdYOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdYOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdYOpGenericAdaptor(RangeT values, const ClusterIdYOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdYOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdYOp>>>
  ClusterIdYOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdYOpAdaptor : public ClusterIdYOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdYOpGenericAdaptor::ClusterIdYOpGenericAdaptor;
  ClusterIdYOpAdaptor(ClusterIdYOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdYOp : public ::mlir::Op<ClusterIdYOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdYOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdYOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cluster.id.y");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdYOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdYOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::ClusterIdYOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::ClusterIdZOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ClusterIdZOpGenericAdaptorBase {
public:
  struct Properties {
    using rangeTy = ::mlir::LLVM::ConstantRangeAttr;
    rangeTy range;

    auto getRange() const {
      auto &propStorage = this->range;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(propStorage);
    }
    void setRange(const ::mlir::LLVM::ConstantRangeAttr &propValue) {
      this->range = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.range == this->range &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ClusterIdZOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cluster.id.z", odsAttrs.getContext());
  }

  ClusterIdZOpGenericAdaptorBase(ClusterIdZOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
    return attr;
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
};

} // namespace detail
template <typename RangeT>
class ClusterIdZOpGenericAdaptor : public detail::ClusterIdZOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ClusterIdZOpGenericAdaptorBase;
public:
  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ClusterIdZOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ClusterIdZOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ClusterIdZOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ClusterIdZOpGenericAdaptor(RangeT values, const ClusterIdZOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ClusterIdZOp, typename = std::enable_if_t<std::is_same_v<LateInst, ClusterIdZOp>>>
  ClusterIdZOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ClusterIdZOpAdaptor : public ClusterIdZOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ClusterIdZOpGenericAdaptor::ClusterIdZOpGenericAdaptor;
  ClusterIdZOpAdaptor(ClusterIdZOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ClusterIdZOp : public ::mlir::Op<ClusterIdZOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ClusterIdZOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ClusterIdZOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("range")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRangeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRangeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cluster.id.z");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::ConstantRangeAttr getRangeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::ConstantRangeAttr>(getProperties().range);
  }

  ::std::optional<::mlir::LLVM::ConstantRangeAttr> getRange();
  void setRangeAttr(::mlir::LLVM::ConstantRangeAttr attr) {
    getProperties().range = attr;
  }

  ::mlir::Attribute removeRangeAttr() {
      auto attr = getProperties().range;
      getProperties().range = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Type resultType);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, Type resultType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, /*optional*/::mlir::LLVM::ConstantRangeAttr range);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdZOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ClusterIdZOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::ClusterIdZOp)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.f32.bf8", odsAttrs.getContext());
  }

  CvtF32Bf8OpGenericAdaptorBase(CvtF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};

} // namespace detail
template <typename RangeT>
class CvtF32Bf8OpGenericAdaptor : public detail::CvtF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
public:
  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtF32Bf8OpGenericAdaptor(RangeT values, const CvtF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtF32Bf8Op>>>
  CvtF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtF32Bf8OpAdaptor : public CvtF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtF32Bf8OpGenericAdaptor::CvtF32Bf8OpGenericAdaptor;
  CvtF32Bf8OpAdaptor(CvtF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtF32Bf8Op : public ::mlir::Op<CvtF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtF32Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using byteSelTy = ::mlir::IntegerAttr;
    byteSelTy byteSel;

    auto getByteSel() const {
      auto &propStorage = this->byteSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setByteSel(const ::mlir::IntegerAttr &propValue) {
      this->byteSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byteSel == this->byteSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.f32.fp8", odsAttrs.getContext());
  }

  CvtF32Fp8OpGenericAdaptorBase(CvtF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getByteSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
    return attr;
  }

  uint32_t getByteSel();
};

} // namespace detail
template <typename RangeT>
class CvtF32Fp8OpGenericAdaptor : public detail::CvtF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
public:
  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtF32Fp8OpGenericAdaptor(RangeT values, const CvtF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtF32Fp8Op>>>
  CvtF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtF32Fp8OpAdaptor : public CvtF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtF32Fp8OpGenericAdaptor::CvtF32Fp8OpGenericAdaptor;
  CvtF32Fp8OpAdaptor(CvtF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtF32Fp8Op : public ::mlir::Op<CvtF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byteSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByteSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByteSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getByteSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().byteSel);
  }

  uint32_t getByteSel();
  void setByteSelAttr(::mlir::IntegerAttr attr) {
    getProperties().byteSel = attr;
  }

  void setByteSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::IntegerAttr byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, uint32_t byteSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtF32Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.bf8.f32", odsAttrs.getContext());
  }

  CvtPkBf8F32OpGenericAdaptorBase(CvtPkBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkBf8F32OpGenericAdaptor : public detail::CvtPkBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkBf8F32OpGenericAdaptor(RangeT values, const CvtPkBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkBf8F32Op>>>
  CvtPkBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkBf8F32OpAdaptor : public CvtPkBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkBf8F32OpGenericAdaptor::CvtPkBf8F32OpGenericAdaptor;
  CvtPkBf8F32OpAdaptor(CvtPkBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkBf8F32Op : public ::mlir::Op<CvtPkBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkBf8F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.f32.bf8", odsAttrs.getContext());
  }

  CvtPkF32Bf8OpGenericAdaptorBase(CvtPkF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkF32Bf8OpGenericAdaptor : public detail::CvtPkF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkF32Bf8OpGenericAdaptor(RangeT values, const CvtPkF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkF32Bf8Op>>>
  CvtPkF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkF32Bf8OpAdaptor : public CvtPkF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkF32Bf8OpGenericAdaptor::CvtPkF32Bf8OpGenericAdaptor;
  CvtPkF32Bf8OpAdaptor(CvtPkF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkF32Bf8Op : public ::mlir::Op<CvtPkF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkF32Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.f32.fp8", odsAttrs.getContext());
  }

  CvtPkF32Fp8OpGenericAdaptorBase(CvtPkF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkF32Fp8OpGenericAdaptor : public detail::CvtPkF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
public:
  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkF32Fp8OpGenericAdaptor(RangeT values, const CvtPkF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkF32Fp8Op>>>
  CvtPkF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkF32Fp8OpAdaptor : public CvtPkF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkF32Fp8OpGenericAdaptor::CvtPkF32Fp8OpGenericAdaptor;
  CvtPkF32Fp8OpAdaptor(CvtPkF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkF32Fp8Op : public ::mlir::Op<CvtPkF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkF32Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkFp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkFp8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using wordSelTy = ::mlir::IntegerAttr;
    wordSelTy wordSel;

    auto getWordSel() const {
      auto &propStorage = this->wordSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setWordSel(const ::mlir::IntegerAttr &propValue) {
      this->wordSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.wordSel == this->wordSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkFp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pk.fp8.f32", odsAttrs.getContext());
  }

  CvtPkFp8F32OpGenericAdaptorBase(CvtPkFp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getWordSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
    return attr;
  }

  bool getWordSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkFp8F32OpGenericAdaptor : public detail::CvtPkFp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkFp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
public:
  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkFp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkFp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkFp8F32OpGenericAdaptor(RangeT values, const CvtPkFp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkFp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkFp8F32Op>>>
  CvtPkFp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOld() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkFp8F32OpAdaptor : public CvtPkFp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkFp8F32OpGenericAdaptor::CvtPkFp8F32OpGenericAdaptor;
  CvtPkFp8F32OpAdaptor(CvtPkFp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkFp8F32Op : public ::mlir::Op<CvtPkFp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkFp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkFp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  static constexpr int odsIndex_old = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("wordSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWordSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWordSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pk.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getOld() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOldMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getWordSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().wordSel);
  }

  bool getWordSel();
  void setWordSelAttr(::mlir::IntegerAttr attr) {
    getProperties().wordSel = attr;
  }

  void setWordSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, ::mlir::IntegerAttr wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB, ::mlir::Value old, bool wordSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkFp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkFp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkFp8F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkRtz declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkRtzGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkRtzGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.pkrtz", odsAttrs.getContext());
  }

  CvtPkRtzGenericAdaptorBase(CvtPkRtz op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtPkRtzGenericAdaptor : public detail::CvtPkRtzGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkRtzGenericAdaptorBase;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
public:
  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkRtzGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkRtzGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkRtzGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkRtzGenericAdaptor(RangeT values, const CvtPkRtzGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkRtz, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkRtz>>>
  CvtPkRtzGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrcA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrcB() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkRtzAdaptor : public CvtPkRtzGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkRtzGenericAdaptor::CvtPkRtzGenericAdaptor;
  CvtPkRtzAdaptor(CvtPkRtz op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkRtz : public ::mlir::Op<CvtPkRtz, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkRtzAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkRtzGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_srcA = 0;
  static constexpr int odsIndex_srcB = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.pkrtz");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrcB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value srcA, ::mlir::Value srcB);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value srcA, ::mlir::Value srcB);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkRtz create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkRtz create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkRtz)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16Bf16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.bf16.bf6", odsAttrs.getContext());
  }

  CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase(CvtPkScalePk16Bf16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16Bf16Bf6OpGenericAdaptor : public detail::CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16Bf16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16Bf16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16Bf16Bf6OpGenericAdaptor(RangeT values, const CvtPkScalePk16Bf16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16Bf16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16Bf16Bf6Op>>>
  CvtPkScalePk16Bf16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16Bf16Bf6OpAdaptor : public CvtPkScalePk16Bf16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16Bf16Bf6OpGenericAdaptor::CvtPkScalePk16Bf16Bf6OpGenericAdaptor;
  CvtPkScalePk16Bf16Bf6OpAdaptor(CvtPkScalePk16Bf16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16Bf16Bf6Op : public ::mlir::Op<CvtPkScalePk16Bf16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16Bf16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16Bf16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.bf16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16Bf16Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16Bf16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.bf16.fp6", odsAttrs.getContext());
  }

  CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase(CvtPkScalePk16Bf16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16Bf16Fp6OpGenericAdaptor : public detail::CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16Bf16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16Bf16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16Bf16Fp6OpGenericAdaptor(RangeT values, const CvtPkScalePk16Bf16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16Bf16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16Bf16Fp6Op>>>
  CvtPkScalePk16Bf16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16Bf16Fp6OpAdaptor : public CvtPkScalePk16Bf16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16Bf16Fp6OpGenericAdaptor::CvtPkScalePk16Bf16Fp6OpGenericAdaptor;
  CvtPkScalePk16Bf16Fp6OpAdaptor(CvtPkScalePk16Bf16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16Bf16Fp6Op : public ::mlir::Op<CvtPkScalePk16Bf16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16Bf16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16Bf16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.bf16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16Bf16Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16F16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16F16Bf6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16F16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.f16.bf6", odsAttrs.getContext());
  }

  CvtPkScalePk16F16Bf6OpGenericAdaptorBase(CvtPkScalePk16F16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16F16Bf6OpGenericAdaptor : public detail::CvtPkScalePk16F16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16F16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16F16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16F16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16F16Bf6OpGenericAdaptor(RangeT values, const CvtPkScalePk16F16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16F16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16F16Bf6Op>>>
  CvtPkScalePk16F16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16F16Bf6OpAdaptor : public CvtPkScalePk16F16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16F16Bf6OpGenericAdaptor::CvtPkScalePk16F16Bf6OpGenericAdaptor;
  CvtPkScalePk16F16Bf6OpAdaptor(CvtPkScalePk16F16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16F16Bf6Op : public ::mlir::Op<CvtPkScalePk16F16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16F16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16F16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.f16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16F16Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16F16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16F16Fp6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16F16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.f16.fp6", odsAttrs.getContext());
  }

  CvtPkScalePk16F16Fp6OpGenericAdaptorBase(CvtPkScalePk16F16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16F16Fp6OpGenericAdaptor : public detail::CvtPkScalePk16F16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16F16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16F16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16F16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16F16Fp6OpGenericAdaptor(RangeT values, const CvtPkScalePk16F16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16F16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16F16Fp6Op>>>
  CvtPkScalePk16F16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16F16Fp6OpAdaptor : public CvtPkScalePk16F16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16F16Fp6OpGenericAdaptor::CvtPkScalePk16F16Fp6OpGenericAdaptor;
  CvtPkScalePk16F16Fp6OpAdaptor(CvtPkScalePk16F16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16F16Fp6Op : public ::mlir::Op<CvtPkScalePk16F16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16F16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16F16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.f16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16F16Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16F32Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16F32Bf6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16F32Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.f32.bf6", odsAttrs.getContext());
  }

  CvtPkScalePk16F32Bf6OpGenericAdaptorBase(CvtPkScalePk16F32Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16F32Bf6OpGenericAdaptor : public detail::CvtPkScalePk16F32Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16F32Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16F32Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16F32Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16F32Bf6OpGenericAdaptor(RangeT values, const CvtPkScalePk16F32Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16F32Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16F32Bf6Op>>>
  CvtPkScalePk16F32Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16F32Bf6OpAdaptor : public CvtPkScalePk16F32Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16F32Bf6OpGenericAdaptor::CvtPkScalePk16F32Bf6OpGenericAdaptor;
  CvtPkScalePk16F32Bf6OpAdaptor(CvtPkScalePk16F32Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16F32Bf6Op : public ::mlir::Op<CvtPkScalePk16F32Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16F32Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16F32Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.f32.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16F32Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk16F32Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk16F32Fp6OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk16F32Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk16.f32.fp6", odsAttrs.getContext());
  }

  CvtPkScalePk16F32Fp6OpGenericAdaptorBase(CvtPkScalePk16F32Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk16F32Fp6OpGenericAdaptor : public detail::CvtPkScalePk16F32Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk16F32Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk16F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk16F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk16F32Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk16F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk16F32Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk16F32Fp6OpGenericAdaptor(RangeT values, const CvtPkScalePk16F32Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk16F32Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk16F32Fp6Op>>>
  CvtPkScalePk16F32Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk16F32Fp6OpAdaptor : public CvtPkScalePk16F32Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk16F32Fp6OpGenericAdaptor::CvtPkScalePk16F32Fp6OpGenericAdaptor;
  CvtPkScalePk16F32Fp6OpAdaptor(CvtPkScalePk16F32Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk16F32Fp6Op : public ::mlir::Op<CvtPkScalePk16F32Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk16F32Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk16F32Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk16.f32.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk16F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk16F32Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8Bf16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.bf16.bf8", odsAttrs.getContext());
  }

  CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase(CvtPkScalePk8Bf16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8Bf16Bf8OpGenericAdaptor : public detail::CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8Bf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8Bf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8Bf16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8Bf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8Bf16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8Bf16Bf8OpGenericAdaptor(RangeT values, const CvtPkScalePk8Bf16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8Bf16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8Bf16Bf8Op>>>
  CvtPkScalePk8Bf16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8Bf16Bf8OpAdaptor : public CvtPkScalePk8Bf16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8Bf16Bf8OpGenericAdaptor::CvtPkScalePk8Bf16Bf8OpGenericAdaptor;
  CvtPkScalePk8Bf16Bf8OpAdaptor(CvtPkScalePk8Bf16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8Bf16Bf8Op : public ::mlir::Op<CvtPkScalePk8Bf16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8Bf16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8Bf16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.bf16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8Bf16Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8Bf16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.bf16.fp4", odsAttrs.getContext());
  }

  CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase(CvtPkScalePk8Bf16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8Bf16Fp4OpGenericAdaptor : public detail::CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8Bf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8Bf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8Bf16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8Bf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8Bf16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8Bf16Fp4OpGenericAdaptor(RangeT values, const CvtPkScalePk8Bf16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8Bf16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8Bf16Fp4Op>>>
  CvtPkScalePk8Bf16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8Bf16Fp4OpAdaptor : public CvtPkScalePk8Bf16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8Bf16Fp4OpGenericAdaptor::CvtPkScalePk8Bf16Fp4OpGenericAdaptor;
  CvtPkScalePk8Bf16Fp4OpAdaptor(CvtPkScalePk8Bf16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8Bf16Fp4Op : public ::mlir::Op<CvtPkScalePk8Bf16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8Bf16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8Bf16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.bf16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8Bf16Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8Bf16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.bf16.fp8", odsAttrs.getContext());
  }

  CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase(CvtPkScalePk8Bf16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8Bf16Fp8OpGenericAdaptor : public detail::CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8Bf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8Bf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8Bf16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8Bf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8Bf16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8Bf16Fp8OpGenericAdaptor(RangeT values, const CvtPkScalePk8Bf16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8Bf16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8Bf16Fp8Op>>>
  CvtPkScalePk8Bf16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8Bf16Fp8OpAdaptor : public CvtPkScalePk8Bf16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8Bf16Fp8OpGenericAdaptor::CvtPkScalePk8Bf16Fp8OpGenericAdaptor;
  CvtPkScalePk8Bf16Fp8OpAdaptor(CvtPkScalePk8Bf16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8Bf16Fp8Op : public ::mlir::Op<CvtPkScalePk8Bf16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8Bf16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8Bf16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.bf16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8Bf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8Bf16Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f16.bf8", odsAttrs.getContext());
  }

  CvtPkScalePk8F16Bf8OpGenericAdaptorBase(CvtPkScalePk8F16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F16Bf8OpGenericAdaptor : public detail::CvtPkScalePk8F16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F16Bf8OpGenericAdaptor(RangeT values, const CvtPkScalePk8F16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F16Bf8Op>>>
  CvtPkScalePk8F16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F16Bf8OpAdaptor : public CvtPkScalePk8F16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F16Bf8OpGenericAdaptor::CvtPkScalePk8F16Bf8OpGenericAdaptor;
  CvtPkScalePk8F16Bf8OpAdaptor(CvtPkScalePk8F16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F16Bf8Op : public ::mlir::Op<CvtPkScalePk8F16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F16Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f16.fp4", odsAttrs.getContext());
  }

  CvtPkScalePk8F16Fp4OpGenericAdaptorBase(CvtPkScalePk8F16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F16Fp4OpGenericAdaptor : public detail::CvtPkScalePk8F16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F16Fp4OpGenericAdaptor(RangeT values, const CvtPkScalePk8F16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F16Fp4Op>>>
  CvtPkScalePk8F16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F16Fp4OpAdaptor : public CvtPkScalePk8F16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F16Fp4OpGenericAdaptor::CvtPkScalePk8F16Fp4OpGenericAdaptor;
  CvtPkScalePk8F16Fp4OpAdaptor(CvtPkScalePk8F16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F16Fp4Op : public ::mlir::Op<CvtPkScalePk8F16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F16Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f16.fp8", odsAttrs.getContext());
  }

  CvtPkScalePk8F16Fp8OpGenericAdaptorBase(CvtPkScalePk8F16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F16Fp8OpGenericAdaptor : public detail::CvtPkScalePk8F16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F16Fp8OpGenericAdaptor(RangeT values, const CvtPkScalePk8F16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F16Fp8Op>>>
  CvtPkScalePk8F16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F16Fp8OpAdaptor : public CvtPkScalePk8F16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F16Fp8OpGenericAdaptor::CvtPkScalePk8F16Fp8OpGenericAdaptor;
  CvtPkScalePk8F16Fp8OpAdaptor(CvtPkScalePk8F16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F16Fp8Op : public ::mlir::Op<CvtPkScalePk8F16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F16Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f32.bf8", odsAttrs.getContext());
  }

  CvtPkScalePk8F32Bf8OpGenericAdaptorBase(CvtPkScalePk8F32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F32Bf8OpGenericAdaptor : public detail::CvtPkScalePk8F32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F32Bf8OpGenericAdaptor(RangeT values, const CvtPkScalePk8F32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F32Bf8Op>>>
  CvtPkScalePk8F32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F32Bf8OpAdaptor : public CvtPkScalePk8F32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F32Bf8OpGenericAdaptor::CvtPkScalePk8F32Bf8OpGenericAdaptor;
  CvtPkScalePk8F32Bf8OpAdaptor(CvtPkScalePk8F32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F32Bf8Op : public ::mlir::Op<CvtPkScalePk8F32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F32Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F32Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F32Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F32Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f32.fp4", odsAttrs.getContext());
  }

  CvtPkScalePk8F32Fp4OpGenericAdaptorBase(CvtPkScalePk8F32Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F32Fp4OpGenericAdaptor : public detail::CvtPkScalePk8F32Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F32Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F32Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F32Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F32Fp4OpGenericAdaptor(RangeT values, const CvtPkScalePk8F32Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F32Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F32Fp4Op>>>
  CvtPkScalePk8F32Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F32Fp4OpAdaptor : public CvtPkScalePk8F32Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F32Fp4OpGenericAdaptor::CvtPkScalePk8F32Fp4OpGenericAdaptor;
  CvtPkScalePk8F32Fp4OpAdaptor(CvtPkScalePk8F32Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F32Fp4Op : public ::mlir::Op<CvtPkScalePk8F32Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F32Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F32Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f32.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F32Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtPkScalePk8F32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtPkScalePk8F32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using scaleSelTy = ::mlir::IntegerAttr;
    scaleSelTy scaleSel;

    auto getScaleSel() const {
      auto &propStorage = this->scaleSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setScaleSel(const ::mlir::IntegerAttr &propValue) {
      this->scaleSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.scaleSel == this->scaleSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtPkScalePk8F32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scale.pk8.f32.fp8", odsAttrs.getContext());
  }

  CvtPkScalePk8F32Fp8OpGenericAdaptorBase(CvtPkScalePk8F32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getScaleSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
    return attr;
  }

  uint32_t getScaleSel();
};

} // namespace detail
template <typename RangeT>
class CvtPkScalePk8F32Fp8OpGenericAdaptor : public detail::CvtPkScalePk8F32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtPkScalePk8F32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtPkScalePk8F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtPkScalePk8F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtPkScalePk8F32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtPkScalePk8F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtPkScalePk8F32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtPkScalePk8F32Fp8OpGenericAdaptor(RangeT values, const CvtPkScalePk8F32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtPkScalePk8F32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtPkScalePk8F32Fp8Op>>>
  CvtPkScalePk8F32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtPkScalePk8F32Fp8OpAdaptor : public CvtPkScalePk8F32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtPkScalePk8F32Fp8OpGenericAdaptor::CvtPkScalePk8F32Fp8OpGenericAdaptor;
  CvtPkScalePk8F32Fp8OpAdaptor(CvtPkScalePk8F32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtPkScalePk8F32Fp8Op : public ::mlir::Op<CvtPkScalePk8F32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtPkScalePk8F32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtPkScalePk8F32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("scaleSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getScaleSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getScaleSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scale.pk8.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getScaleSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().scaleSel);
  }

  uint32_t getScaleSel();
  void setScaleSelAttr(::mlir::IntegerAttr attr) {
    getProperties().scaleSel = attr;
  }

  void setScaleSel(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t scaleSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtPkScalePk8F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtPkScalePk8F32Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF322xPk16Bf6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.2xpk16.bf6.f32", odsAttrs.getContext());
  }

  CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase(CvtScaleF322xPk16Bf6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF322xPk16Bf6F32OpGenericAdaptor : public detail::CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF322xPk16Bf6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF322xPk16Bf6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, const CvtScaleF322xPk16Bf6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF322xPk16Bf6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF322xPk16Bf6F32Op>>>
  CvtScaleF322xPk16Bf6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF322xPk16Bf6F32OpAdaptor : public CvtScaleF322xPk16Bf6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF322xPk16Bf6F32OpGenericAdaptor::CvtScaleF322xPk16Bf6F32OpGenericAdaptor;
  CvtScaleF322xPk16Bf6F32OpAdaptor(CvtScaleF322xPk16Bf6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF322xPk16Bf6F32Op : public ::mlir::Op<CvtScaleF322xPk16Bf6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF322xPk16Bf6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF322xPk16Bf6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.2xpk16.bf6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF322xPk16Bf6F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF322xPk16Fp6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.2xpk16.fp6.f32", odsAttrs.getContext());
  }

  CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase(CvtScaleF322xPk16Fp6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF322xPk16Fp6F32OpGenericAdaptor : public detail::CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF322xPk16Fp6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF322xPk16Fp6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, const CvtScaleF322xPk16Fp6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF322xPk16Fp6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF322xPk16Fp6F32Op>>>
  CvtScaleF322xPk16Fp6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc0() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF322xPk16Fp6F32OpAdaptor : public CvtScaleF322xPk16Fp6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF322xPk16Fp6F32OpGenericAdaptor::CvtScaleF322xPk16Fp6F32OpGenericAdaptor;
  CvtScaleF322xPk16Fp6F32OpAdaptor(CvtScaleF322xPk16Fp6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF322xPk16Fp6F32Op : public ::mlir::Op<CvtScaleF322xPk16Fp6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF322xPk16Fp6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF322xPk16Fp6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src0 = 0;
  static constexpr int odsIndex_src1 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.2xpk16.fp6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF322xPk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF322xPk16Fp6F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32F16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32F16Bf8OpGenericAdaptorBase(CvtScaleF32F16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32F16Bf8OpGenericAdaptor : public detail::CvtScaleF32F16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32F16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F16Bf8Op>>>
  CvtScaleF32F16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F16Bf8OpAdaptor : public CvtScaleF32F16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F16Bf8OpGenericAdaptor::CvtScaleF32F16Bf8OpGenericAdaptor;
  CvtScaleF32F16Bf8OpAdaptor(CvtScaleF32F16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F16Bf8Op : public ::mlir::Op<CvtScaleF32F16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel"), ::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F16Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32F16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32F16Fp8OpGenericAdaptorBase(CvtScaleF32F16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32F16Fp8OpGenericAdaptor : public detail::CvtScaleF32F16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32F16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F16Fp8Op>>>
  CvtScaleF32F16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F16Fp8OpAdaptor : public CvtScaleF32F16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F16Fp8OpGenericAdaptor::CvtScaleF32F16Fp8OpGenericAdaptor;
  CvtScaleF32F16Fp8OpAdaptor(CvtScaleF32F16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F16Fp8Op : public ::mlir::Op<CvtScaleF32F16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel"), ::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F16Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32F32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f32.bf8", odsAttrs.getContext());
  }

  CvtScaleF32F32Bf8OpGenericAdaptorBase(CvtScaleF32F32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32F32Bf8OpGenericAdaptor : public detail::CvtScaleF32F32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32F32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F32Bf8Op>>>
  CvtScaleF32F32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F32Bf8OpAdaptor : public CvtScaleF32F32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F32Bf8OpGenericAdaptor::CvtScaleF32F32Bf8OpGenericAdaptor;
  CvtScaleF32F32Bf8OpAdaptor(CvtScaleF32F32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F32Bf8Op : public ::mlir::Op<CvtScaleF32F32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::FloatType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F32Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32F32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32F32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32F32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.f32.fp8", odsAttrs.getContext());
  }

  CvtScaleF32F32Fp8OpGenericAdaptorBase(CvtScaleF32F32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32F32Fp8OpGenericAdaptor : public detail::CvtScaleF32F32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32F32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32F32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32F32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32F32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32F32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32F32Fp8Op>>>
  CvtScaleF32F32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32F32Fp8OpAdaptor : public CvtScaleF32F32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32F32Fp8OpGenericAdaptor::CvtScaleF32F32Fp8OpGenericAdaptor;
  CvtScaleF32F32Fp8OpAdaptor(CvtScaleF32F32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32F32Fp8Op : public ::mlir::Op<CvtScaleF32F32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::FloatType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32F32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32F32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::FloatType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32F32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32F32Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Bf6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.bf6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase(CvtScaleF32Pk16Bf6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Bf6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Bf6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Bf6Bf16Op>>>
  CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Bf6Bf16OpAdaptor : public CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor::CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor;
  CvtScaleF32Pk16Bf6Bf16OpAdaptor(CvtScaleF32Pk16Bf6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Bf6Bf16Op : public ::mlir::Op<CvtScaleF32Pk16Bf6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Bf6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Bf6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.bf6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Bf6Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Bf6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.bf6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase(CvtScaleF32Pk16Bf6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Bf6F16OpGenericAdaptor : public detail::CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Bf6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Bf6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Bf6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Bf6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Bf6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Bf6F16Op>>>
  CvtScaleF32Pk16Bf6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Bf6F16OpAdaptor : public CvtScaleF32Pk16Bf6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Bf6F16OpGenericAdaptor::CvtScaleF32Pk16Bf6F16OpGenericAdaptor;
  CvtScaleF32Pk16Bf6F16OpAdaptor(CvtScaleF32Pk16Bf6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Bf6F16Op : public ::mlir::Op<CvtScaleF32Pk16Bf6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Bf6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Bf6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.bf6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Bf6F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Bf6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.bf6.f32", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase(CvtScaleF32Pk16Bf6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Bf6F32OpGenericAdaptor : public detail::CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Bf6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Bf6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Bf6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Bf6F32OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Bf6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Bf6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Bf6F32Op>>>
  CvtScaleF32Pk16Bf6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Bf6F32OpAdaptor : public CvtScaleF32Pk16Bf6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Bf6F32OpGenericAdaptor::CvtScaleF32Pk16Bf6F32OpGenericAdaptor;
  CvtScaleF32Pk16Bf6F32OpAdaptor(CvtScaleF32Pk16Bf6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Bf6F32Op : public ::mlir::Op<CvtScaleF32Pk16Bf6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Bf6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Bf6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.bf6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Bf6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Bf6F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Fp6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.fp6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase(CvtScaleF32Pk16Fp6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Fp6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Fp6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Fp6Bf16Op>>>
  CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Fp6Bf16OpAdaptor : public CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor::CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor;
  CvtScaleF32Pk16Fp6Bf16OpAdaptor(CvtScaleF32Pk16Fp6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Fp6Bf16Op : public ::mlir::Op<CvtScaleF32Pk16Fp6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Fp6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Fp6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.fp6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Fp6Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Fp6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.fp6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase(CvtScaleF32Pk16Fp6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Fp6F16OpGenericAdaptor : public detail::CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Fp6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Fp6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Fp6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Fp6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Fp6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Fp6F16Op>>>
  CvtScaleF32Pk16Fp6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Fp6F16OpAdaptor : public CvtScaleF32Pk16Fp6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Fp6F16OpGenericAdaptor::CvtScaleF32Pk16Fp6F16OpGenericAdaptor;
  CvtScaleF32Pk16Fp6F16OpAdaptor(CvtScaleF32Pk16Fp6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Fp6F16Op : public ::mlir::Op<CvtScaleF32Pk16Fp6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Fp6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Fp6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.fp6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Fp6F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk16Fp6F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk16.fp6.f32", odsAttrs.getContext());
  }

  CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase(CvtScaleF32Pk16Fp6F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk16Fp6F32OpGenericAdaptor : public detail::CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk16Fp6F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk16Fp6F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk16Fp6F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk16Fp6F32OpGenericAdaptor(RangeT values, const CvtScaleF32Pk16Fp6F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk16Fp6F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk16Fp6F32Op>>>
  CvtScaleF32Pk16Fp6F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk16Fp6F32OpAdaptor : public CvtScaleF32Pk16Fp6F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk16Fp6F32OpGenericAdaptor::CvtScaleF32Pk16Fp6F32OpGenericAdaptor;
  CvtScaleF32Pk16Fp6F32OpAdaptor(CvtScaleF32Pk16Fp6F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk16Fp6F32Op : public ::mlir::Op<CvtScaleF32Pk16Fp6F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk16Fp6F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk16Fp6F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk16.fp6.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk16Fp6F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk16Fp6F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf16.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase(CvtScaleF32Pk32Bf16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf16Bf6Op>>>
  CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf16Bf6OpAdaptor : public CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor::CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor;
  CvtScaleF32Pk32Bf16Bf6OpAdaptor(CvtScaleF32Pk32Bf16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf16Bf6Op : public ::mlir::Op<CvtScaleF32Pk32Bf16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf16Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf16.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase(CvtScaleF32Pk32Bf16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf16Fp6Op>>>
  CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf16Fp6OpAdaptor : public CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor::CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor;
  CvtScaleF32Pk32Bf16Fp6OpAdaptor(CvtScaleF32Pk32Bf16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf16Fp6Op : public ::mlir::Op<CvtScaleF32Pk32Bf16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf16Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase(CvtScaleF32Pk32Bf6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf6Bf16Op>>>
  CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf6Bf16OpAdaptor : public CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor::CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor;
  CvtScaleF32Pk32Bf6Bf16OpAdaptor(CvtScaleF32Pk32Bf6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf6Bf16Op : public ::mlir::Op<CvtScaleF32Pk32Bf6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf6Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Bf6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.bf6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase(CvtScaleF32Pk32Bf6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Bf6F16OpGenericAdaptor : public detail::CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Bf6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Bf6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Bf6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Bf6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Bf6F16Op>>>
  CvtScaleF32Pk32Bf6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Bf6F16OpAdaptor : public CvtScaleF32Pk32Bf6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Bf6F16OpGenericAdaptor::CvtScaleF32Pk32Bf6F16OpGenericAdaptor;
  CvtScaleF32Pk32Bf6F16OpAdaptor(CvtScaleF32Pk32Bf6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Bf6F16Op : public ::mlir::Op<CvtScaleF32Pk32Bf6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Bf6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Bf6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.bf6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Bf6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Bf6F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F16Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f16.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase(CvtScaleF32Pk32F16Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F16Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F16Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F16Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F16Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F16Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F16Bf6Op>>>
  CvtScaleF32Pk32F16Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F16Bf6OpAdaptor : public CvtScaleF32Pk32F16Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F16Bf6OpGenericAdaptor::CvtScaleF32Pk32F16Bf6OpGenericAdaptor;
  CvtScaleF32Pk32F16Bf6OpAdaptor(CvtScaleF32Pk32F16Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F16Bf6Op : public ::mlir::Op<CvtScaleF32Pk32F16Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F16Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F16Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f16.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F16Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F16Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f16.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase(CvtScaleF32Pk32F16Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F16Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F16Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F16Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F16Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F16Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F16Fp6Op>>>
  CvtScaleF32Pk32F16Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F16Fp6OpAdaptor : public CvtScaleF32Pk32F16Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F16Fp6OpGenericAdaptor::CvtScaleF32Pk32F16Fp6OpGenericAdaptor;
  CvtScaleF32Pk32F16Fp6OpAdaptor(CvtScaleF32Pk32F16Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F16Fp6Op : public ::mlir::Op<CvtScaleF32Pk32F16Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F16Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F16Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f16.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F16Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F16Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F32Bf6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f32.bf6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase(CvtScaleF32Pk32F32Bf6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F32Bf6OpGenericAdaptor : public detail::CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F32Bf6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F32Bf6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F32Bf6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F32Bf6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F32Bf6Op>>>
  CvtScaleF32Pk32F32Bf6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F32Bf6OpAdaptor : public CvtScaleF32Pk32F32Bf6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F32Bf6OpGenericAdaptor::CvtScaleF32Pk32F32Bf6OpGenericAdaptor;
  CvtScaleF32Pk32F32Bf6OpAdaptor(CvtScaleF32Pk32F32Bf6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F32Bf6Op : public ::mlir::Op<CvtScaleF32Pk32F32Bf6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F32Bf6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F32Bf6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f32.bf6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Bf6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F32Bf6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32F32Fp6Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.f32.fp6", odsAttrs.getContext());
  }

  CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase(CvtScaleF32Pk32F32Fp6Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32F32Fp6OpGenericAdaptor : public detail::CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32F32Fp6OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32F32Fp6OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32F32Fp6OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32F32Fp6Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32F32Fp6Op>>>
  CvtScaleF32Pk32F32Fp6OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32F32Fp6OpAdaptor : public CvtScaleF32Pk32F32Fp6OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32F32Fp6OpGenericAdaptor::CvtScaleF32Pk32F32Fp6OpGenericAdaptor;
  CvtScaleF32Pk32F32Fp6OpAdaptor(CvtScaleF32Pk32F32Fp6Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32F32Fp6Op : public ::mlir::Op<CvtScaleF32Pk32F32Fp6Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32F32Fp6OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32F32Fp6OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.f32.fp6");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32F32Fp6Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32F32Fp6Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Fp6Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.fp6.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase(CvtScaleF32Pk32Fp6Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Fp6Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Fp6Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Fp6Bf16Op>>>
  CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Fp6Bf16OpAdaptor : public CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor::CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor;
  CvtScaleF32Pk32Fp6Bf16OpAdaptor(CvtScaleF32Pk32Fp6Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Fp6Bf16Op : public ::mlir::Op<CvtScaleF32Pk32Fp6Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Fp6Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Fp6Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.fp6.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Fp6Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk32Fp6F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk32.fp6.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase(CvtScaleF32Pk32Fp6F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk32Fp6F16OpGenericAdaptor : public detail::CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk32Fp6F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk32Fp6F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk32Fp6F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk32Fp6F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk32Fp6F16Op>>>
  CvtScaleF32Pk32Fp6F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk32Fp6F16OpAdaptor : public CvtScaleF32Pk32Fp6F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk32Fp6F16OpGenericAdaptor::CvtScaleF32Pk32Fp6F16OpGenericAdaptor;
  CvtScaleF32Pk32Fp6F16OpAdaptor(CvtScaleF32Pk32Fp6F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk32Fp6F16Op : public ::mlir::Op<CvtScaleF32Pk32Fp6F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk32Fp6F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk32Fp6F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk32.fp6.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk32Fp6F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk32Fp6F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Bf8Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.bf8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase(CvtScaleF32Pk8Bf8Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Bf8Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Bf8Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Bf8Bf16Op>>>
  CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Bf8Bf16OpAdaptor : public CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor::CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor;
  CvtScaleF32Pk8Bf8Bf16OpAdaptor(CvtScaleF32Pk8Bf8Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Bf8Bf16Op : public ::mlir::Op<CvtScaleF32Pk8Bf8Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Bf8Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Bf8Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.bf8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Bf8Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Bf8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.bf8.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase(CvtScaleF32Pk8Bf8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Bf8F16OpGenericAdaptor : public detail::CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Bf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Bf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Bf8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Bf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Bf8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Bf8F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Bf8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Bf8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Bf8F16Op>>>
  CvtScaleF32Pk8Bf8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Bf8F16OpAdaptor : public CvtScaleF32Pk8Bf8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Bf8F16OpGenericAdaptor::CvtScaleF32Pk8Bf8F16OpGenericAdaptor;
  CvtScaleF32Pk8Bf8F16OpAdaptor(CvtScaleF32Pk8Bf8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Bf8F16Op : public ::mlir::Op<CvtScaleF32Pk8Bf8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Bf8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Bf8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.bf8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Bf8F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Bf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.bf8.f32", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase(CvtScaleF32Pk8Bf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Bf8F32OpGenericAdaptor : public detail::CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Bf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Bf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Bf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Bf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Bf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Bf8F32OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Bf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Bf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Bf8F32Op>>>
  CvtScaleF32Pk8Bf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Bf8F32OpAdaptor : public CvtScaleF32Pk8Bf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Bf8F32OpGenericAdaptor::CvtScaleF32Pk8Bf8F32OpGenericAdaptor;
  CvtScaleF32Pk8Bf8F32OpAdaptor(CvtScaleF32Pk8Bf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Bf8F32Op : public ::mlir::Op<CvtScaleF32Pk8Bf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Bf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Bf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Bf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Bf8F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp4Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp4.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase(CvtScaleF32Pk8Fp4Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp4Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp4Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp4Bf16Op>>>
  CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp4Bf16OpAdaptor : public CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor::CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor;
  CvtScaleF32Pk8Fp4Bf16OpAdaptor(CvtScaleF32Pk8Fp4Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp4Bf16Op : public ::mlir::Op<CvtScaleF32Pk8Fp4Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp4Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp4Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp4.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp4Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp4F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp4.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase(CvtScaleF32Pk8Fp4F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp4F16OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp4F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp4F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp4F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp4F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp4F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp4F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp4F16Op>>>
  CvtScaleF32Pk8Fp4F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp4F16OpAdaptor : public CvtScaleF32Pk8Fp4F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp4F16OpGenericAdaptor::CvtScaleF32Pk8Fp4F16OpGenericAdaptor;
  CvtScaleF32Pk8Fp4F16OpAdaptor(CvtScaleF32Pk8Fp4F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp4F16Op : public ::mlir::Op<CvtScaleF32Pk8Fp4F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp4F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp4F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp4.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp4F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp4F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp4.f32", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase(CvtScaleF32Pk8Fp4F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp4F32OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp4F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp4F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp4F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp4F32OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp4F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp4F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp4F32Op>>>
  CvtScaleF32Pk8Fp4F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp4F32OpAdaptor : public CvtScaleF32Pk8Fp4F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp4F32OpGenericAdaptor::CvtScaleF32Pk8Fp4F32OpGenericAdaptor;
  CvtScaleF32Pk8Fp4F32OpAdaptor(CvtScaleF32Pk8Fp4F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp4F32Op : public ::mlir::Op<CvtScaleF32Pk8Fp4F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp4F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp4F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp4.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp4F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp4F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp8Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase(CvtScaleF32Pk8Fp8Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp8Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp8Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp8Bf16Op>>>
  CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp8Bf16OpAdaptor : public CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor::CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor;
  CvtScaleF32Pk8Fp8Bf16OpAdaptor(CvtScaleF32Pk8Fp8Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp8Bf16Op : public ::mlir::Op<CvtScaleF32Pk8Fp8Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp8Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp8Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp8Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp8.f16", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase(CvtScaleF32Pk8Fp8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp8F16OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp8F16OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp8F16Op>>>
  CvtScaleF32Pk8Fp8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp8F16OpAdaptor : public CvtScaleF32Pk8Fp8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp8F16OpGenericAdaptor::CvtScaleF32Pk8Fp8F16OpGenericAdaptor;
  CvtScaleF32Pk8Fp8F16OpAdaptor(CvtScaleF32Pk8Fp8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp8F16Op : public ::mlir::Op<CvtScaleF32Pk8Fp8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp8F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32Pk8Fp8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk8.fp8.f32", odsAttrs.getContext());
  }

  CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase(CvtScaleF32Pk8Fp8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CvtScaleF32Pk8Fp8F32OpGenericAdaptor : public detail::CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32Pk8Fp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32Pk8Fp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32Pk8Fp8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32Pk8Fp8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32Pk8Fp8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32Pk8Fp8F32OpGenericAdaptor(RangeT values, const CvtScaleF32Pk8Fp8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32Pk8Fp8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32Pk8Fp8F32Op>>>
  CvtScaleF32Pk8Fp8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32Pk8Fp8F32OpAdaptor : public CvtScaleF32Pk8Fp8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32Pk8Fp8F32OpGenericAdaptor::CvtScaleF32Pk8Fp8F32OpGenericAdaptor;
  CvtScaleF32Pk8Fp8F32OpAdaptor(CvtScaleF32Pk8Fp8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32Pk8Fp8F32Op : public ::mlir::Op<CvtScaleF32Pk8Fp8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32Pk8Fp8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32Pk8Fp8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk8.fp8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32Pk8Fp8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32Pk8Fp8F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Bf8OpGenericAdaptorBase(CvtScaleF32PkBf16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Bf8OpGenericAdaptor : public detail::CvtScaleF32PkBf16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Bf8Op>>>
  CvtScaleF32PkBf16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Bf8OpAdaptor : public CvtScaleF32PkBf16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Bf8OpGenericAdaptor::CvtScaleF32PkBf16Bf8OpGenericAdaptor;
  CvtScaleF32PkBf16Bf8OpAdaptor(CvtScaleF32PkBf16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Bf8Op : public ::mlir::Op<CvtScaleF32PkBf16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Fp4OpGenericAdaptorBase(CvtScaleF32PkBf16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Fp4OpGenericAdaptor : public detail::CvtScaleF32PkBf16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Fp4Op>>>
  CvtScaleF32PkBf16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Fp4OpAdaptor : public CvtScaleF32PkBf16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Fp4OpGenericAdaptor::CvtScaleF32PkBf16Fp4OpGenericAdaptor;
  CvtScaleF32PkBf16Fp4OpAdaptor(CvtScaleF32PkBf16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Fp4Op : public ::mlir::Op<CvtScaleF32PkBf16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkBf16Fp8OpGenericAdaptorBase(CvtScaleF32PkBf16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf16Fp8OpGenericAdaptor : public detail::CvtScaleF32PkBf16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf16Fp8Op>>>
  CvtScaleF32PkBf16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf16Fp8OpAdaptor : public CvtScaleF32PkBf16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf16Fp8OpGenericAdaptor::CvtScaleF32PkBf16Fp8OpGenericAdaptor;
  CvtScaleF32PkBf16Fp8OpAdaptor(CvtScaleF32PkBf16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf16Fp8Op : public ::mlir::Op<CvtScaleF32PkBf16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf16Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf8Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.bf16", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8Bf16OpGenericAdaptorBase(CvtScaleF32PkBf8Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8Bf16OpGenericAdaptor : public detail::CvtScaleF32PkBf8Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8Bf16Op>>>
  CvtScaleF32PkBf8Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8Bf16OpAdaptor : public CvtScaleF32PkBf8Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8Bf16OpGenericAdaptor::CvtScaleF32PkBf8Bf16OpGenericAdaptor;
  CvtScaleF32PkBf8Bf16OpAdaptor(CvtScaleF32PkBf8Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8Bf16Op : public ::mlir::Op<CvtScaleF32PkBf8Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8Bf16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8Bf16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.bf16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8Bf16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8Bf16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8F16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf8F16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8F16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.f16", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8F16OpGenericAdaptorBase(CvtScaleF32PkBf8F16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8F16OpGenericAdaptor : public detail::CvtScaleF32PkBf8F16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8F16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8F16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8F16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8F16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8F16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8F16Op>>>
  CvtScaleF32PkBf8F16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8F16OpAdaptor : public CvtScaleF32PkBf8F16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8F16OpGenericAdaptor::CvtScaleF32PkBf8F16OpGenericAdaptor;
  CvtScaleF32PkBf8F16OpAdaptor(CvtScaleF32PkBf8F16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8F16Op : public ::mlir::Op<CvtScaleF32PkBf8F16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8F16OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8F16OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_scale = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.f16");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F16Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8F16Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkBf8F32Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkBf8F32OpGenericAdaptorBase {
public:
  struct Properties {
    using dstLoHiSelTy = ::mlir::IntegerAttr;
    dstLoHiSelTy dstLoHiSel;

    auto getDstLoHiSel() const {
      auto &propStorage = this->dstLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->dstLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstLoHiSel == this->dstLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkBf8F32OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.bf8.f32", odsAttrs.getContext());
  }

  CvtScaleF32PkBf8F32OpGenericAdaptorBase(CvtScaleF32PkBf8F32Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
    return attr;
  }

  bool getDstLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkBf8F32OpGenericAdaptor : public detail::CvtScaleF32PkBf8F32OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkBf8F32OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
public:
  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkBf8F32OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkBf8F32OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, const CvtScaleF32PkBf8F32OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkBf8F32Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkBf8F32Op>>>
  CvtScaleF32PkBf8F32OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc0() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSrc1() {
    return (*getODSOperands(2).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(3).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkBf8F32OpAdaptor : public CvtScaleF32PkBf8F32OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkBf8F32OpGenericAdaptor::CvtScaleF32PkBf8F32OpGenericAdaptor;
  CvtScaleF32PkBf8F32OpAdaptor(CvtScaleF32PkBf8F32Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkBf8F32Op : public ::mlir::Op<CvtScaleF32PkBf8F32Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkBf8F32OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkBf8F32OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src0 = 1;
  static constexpr int odsIndex_src1 = 2;
  static constexpr int odsIndex_scale = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("dstLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDstLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDstLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.bf8.f32");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getOldVdst() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc0() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getSrc1() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(3).begin());
  }

  ::mlir::OpOperand &getOldVdstMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc0Mutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSrc1Mutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getDstLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstLoHiSel);
  }

  bool getDstLoHiSel();
  void setDstLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().dstLoHiSel = attr;
  }

  void setDstLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, ::mlir::IntegerAttr dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value oldVdst, ::mlir::Value src0, ::mlir::Value src1, ::mlir::Value scale, bool dstLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkBf8F32Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkBf8F32Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF16Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Bf8OpGenericAdaptorBase(CvtScaleF32PkF16Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Bf8OpGenericAdaptor : public detail::CvtScaleF32PkF16Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Bf8Op>>>
  CvtScaleF32PkF16Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Bf8OpAdaptor : public CvtScaleF32PkF16Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Bf8OpGenericAdaptor::CvtScaleF32PkF16Bf8OpGenericAdaptor;
  CvtScaleF32PkF16Bf8OpAdaptor(CvtScaleF32PkF16Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Bf8Op : public ::mlir::Op<CvtScaleF32PkF16Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF16Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Fp4OpGenericAdaptorBase(CvtScaleF32PkF16Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Fp4OpGenericAdaptor : public detail::CvtScaleF32PkF16Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Fp4Op>>>
  CvtScaleF32PkF16Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Fp4OpAdaptor : public CvtScaleF32PkF16Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Fp4OpGenericAdaptor::CvtScaleF32PkF16Fp4OpGenericAdaptor;
  CvtScaleF32PkF16Fp4OpAdaptor(CvtScaleF32PkF16Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Fp4Op : public ::mlir::Op<CvtScaleF32PkF16Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF16Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF16Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF16Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f16.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkF16Fp8OpGenericAdaptorBase(CvtScaleF32PkF16Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF16Fp8OpGenericAdaptor : public detail::CvtScaleF32PkF16Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF16Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF16Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF16Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF16Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF16Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF16Fp8Op>>>
  CvtScaleF32PkF16Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF16Fp8OpAdaptor : public CvtScaleF32PkF16Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF16Fp8OpGenericAdaptor::CvtScaleF32PkF16Fp8OpGenericAdaptor;
  CvtScaleF32PkF16Fp8OpAdaptor(CvtScaleF32PkF16Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF16Fp8Op : public ::mlir::Op<CvtScaleF32PkF16Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF16Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF16Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f16.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF16Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF16Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Bf8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF32Bf8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Bf8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.bf8", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Bf8OpGenericAdaptorBase(CvtScaleF32PkF32Bf8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Bf8OpGenericAdaptor : public detail::CvtScaleF32PkF32Bf8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Bf8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Bf8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Bf8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Bf8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Bf8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Bf8Op>>>
  CvtScaleF32PkF32Bf8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Bf8OpAdaptor : public CvtScaleF32PkF32Bf8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Bf8OpGenericAdaptor::CvtScaleF32PkF32Bf8OpGenericAdaptor;
  CvtScaleF32PkF32Bf8OpAdaptor(CvtScaleF32PkF32Bf8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Bf8Op : public ::mlir::Op<CvtScaleF32PkF32Bf8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Bf8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Bf8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.bf8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Bf8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Bf8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Fp4Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF32Fp4OpGenericAdaptorBase {
public:
  struct Properties {
    using srcSelIndexTy = ::mlir::IntegerAttr;
    srcSelIndexTy srcSelIndex;

    auto getSrcSelIndex() const {
      auto &propStorage = this->srcSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->srcSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcSelIndex == this->srcSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Fp4OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.fp4", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Fp4OpGenericAdaptorBase(CvtScaleF32PkF32Fp4Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
    return attr;
  }

  uint32_t getSrcSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Fp4OpGenericAdaptor : public detail::CvtScaleF32PkF32Fp4OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Fp4OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Fp4OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Fp4OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Fp4OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Fp4Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Fp4Op>>>
  CvtScaleF32PkF32Fp4OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Fp4OpAdaptor : public CvtScaleF32PkF32Fp4OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Fp4OpGenericAdaptor::CvtScaleF32PkF32Fp4OpGenericAdaptor;
  CvtScaleF32PkF32Fp4OpAdaptor(CvtScaleF32PkF32Fp4Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Fp4Op : public ::mlir::Op<CvtScaleF32PkF32Fp4Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Fp4OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Fp4OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcSelIndex")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcSelIndexAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcSelIndexAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.fp4");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcSelIndexAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcSelIndex);
  }

  uint32_t getSrcSelIndex();
  void setSrcSelIndexAttr(::mlir::IntegerAttr attr) {
    getProperties().srcSelIndex = attr;
  }

  void setSrcSelIndex(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, uint32_t srcSelIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp4Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Fp4Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkF32Fp8Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkF32Fp8OpGenericAdaptorBase {
public:
  struct Properties {
    using srcLoHiSelTy = ::mlir::IntegerAttr;
    srcLoHiSelTy srcLoHiSel;

    auto getSrcLoHiSel() const {
      auto &propStorage = this->srcLoHiSel;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSrcLoHiSel(const ::mlir::IntegerAttr &propValue) {
      this->srcLoHiSel = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.srcLoHiSel == this->srcLoHiSel &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkF32Fp8OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.f32.fp8", odsAttrs.getContext());
  }

  CvtScaleF32PkF32Fp8OpGenericAdaptorBase(CvtScaleF32PkF32Fp8Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
    return attr;
  }

  bool getSrcLoHiSel();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkF32Fp8OpGenericAdaptor : public detail::CvtScaleF32PkF32Fp8OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkF32Fp8OpGenericAdaptorBase;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
public:
  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkF32Fp8OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkF32Fp8OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, const CvtScaleF32PkF32Fp8OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkF32Fp8Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkF32Fp8Op>>>
  CvtScaleF32PkF32Fp8OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSrc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkF32Fp8OpAdaptor : public CvtScaleF32PkF32Fp8OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkF32Fp8OpGenericAdaptor::CvtScaleF32PkF32Fp8OpGenericAdaptor;
  CvtScaleF32PkF32Fp8OpAdaptor(CvtScaleF32PkF32Fp8Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkF32Fp8Op : public ::mlir::Op<CvtScaleF32PkF32Fp8Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CvtScaleF32PkF32Fp8OpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CvtScaleF32PkF32Fp8OpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_src = 0;
  static constexpr int odsIndex_scale = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("srcLoHiSel")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSrcLoHiSelAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSrcLoHiSelAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rocdl.cvt.scalef32.pk.f32.fp8");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getSrc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::FloatType> getScale() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::FloatType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSrcMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getScaleMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getSrcLoHiSelAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().srcLoHiSel);
  }

  bool getSrcLoHiSel();
  void setSrcLoHiSelAttr(::mlir::IntegerAttr attr) {
    getProperties().srcLoHiSel = attr;
  }

  void setSrcLoHiSel(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, ::mlir::IntegerAttr srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value src, ::mlir::Value scale, bool srcLoHiSel);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CvtScaleF32PkF32Fp8Op create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace mlir::ROCDL
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::ROCDL::CvtScaleF32PkF32Fp8Op)

namespace mlir::ROCDL {


//===----------------------------------------------------------------------===//
// ::mlir::ROCDL::CvtScaleF32PkFp4Bf16Op declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CvtScaleF32PkFp4Bf16OpGenericAdaptorBase {
public:
  struct Properties {
    using dstSelIndexTy = ::mlir::IntegerAttr;
    dstSelIndexTy dstSelIndex;

    auto getDstSelIndex() const {
      auto &propStorage = this->dstSelIndex;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setDstSelIndex(const ::mlir::IntegerAttr &propValue) {
      this->dstSelIndex = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.dstSelIndex == this->dstSelIndex &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CvtScaleF32PkFp4Bf16OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rocdl.cvt.scalef32.pk.fp4.bf16", odsAttrs.getContext());
  }

  CvtScaleF32PkFp4Bf16OpGenericAdaptorBase(CvtScaleF32PkFp4Bf16Op op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getDstSelIndexAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().dstSelIndex);
    return attr;
  }

  uint32_t getDstSelIndex();
};

} // namespace detail
template <typename RangeT>
class CvtScaleF32PkFp4Bf16OpGenericAdaptor : public detail::CvtScaleF32PkFp4Bf16OpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CvtScaleF32PkFp4Bf16OpGenericAdaptorBase;
  static constexpr int odsIndex_oldVdst = 0;
  static constexpr int odsIndex_src = 1;
  static constexpr int odsIndex_scale = 2;
public:
  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CvtScaleF32PkFp4Bf16OpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CvtScaleF32PkFp4Bf16OpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, const CvtScaleF32PkFp4Bf16OpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CvtScaleF32PkFp4Bf16Op, typename = std::enable_if_t<std::is_same_v<LateInst, CvtScaleF32PkFp4Bf16Op>>>
  CvtScaleF32PkFp4Bf16OpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOldVdst() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSrc() {
    return (*getODSOperands(1).begin());
  }

  ValueT getScale() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CvtScaleF32PkFp4Bf16OpAdaptor : public CvtScaleF32PkFp4Bf16OpGenericAdaptor<::mlir::ValueRange> {
public:
  using CvtScaleF32PkFp4Bf16OpGenericAdaptor::CvtScaleF32PkFp4Bf16OpGenericAdaptor;
  CvtScaleF32PkFp4Bf16OpAdaptor(CvtScaleF32PkFp4Bf16Op op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CvtScaleF32PkFp4Bf16Op : public ::mlir::Op<CvtScaleF32PkFp4Bf16Op, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::