/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_ARITHEMULATEUNSUPPORTEDFLOATS
#define GEN_PASS_DECL_ARITHEMULATEWIDEINT
#define GEN_PASS_DECL_ARITHEXPANDOPSPASS
#define GEN_PASS_DECL_ARITHINTRANGENARROWING
#define GEN_PASS_DECL_ARITHINTRANGEOPTS
#define GEN_PASS_DECL_ARITHUNSIGNEDWHENEQUIVALENTPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// ArithEmulateUnsupportedFloats
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHEMULATEUNSUPPORTEDFLOATS
struct ArithEmulateUnsupportedFloatsOptions {
  ::llvm::SmallVector<std::string> sourceTypeStrs;
  std::string targetTypeStr = "f32";
};
std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats();
std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats(ArithEmulateUnsupportedFloatsOptions options);
#undef GEN_PASS_DECL_ARITHEMULATEUNSUPPORTEDFLOATS
#endif // GEN_PASS_DECL_ARITHEMULATEUNSUPPORTEDFLOATS
#ifdef GEN_PASS_DEF_ARITHEMULATEUNSUPPORTEDFLOATS

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats(ArithEmulateUnsupportedFloatsOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithEmulateUnsupportedFloatsBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithEmulateUnsupportedFloatsBase;

  ArithEmulateUnsupportedFloatsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithEmulateUnsupportedFloatsBase(const ArithEmulateUnsupportedFloatsBase &other) : ::mlir::OperationPass<>(other) {}
  ArithEmulateUnsupportedFloatsBase& operator=(const ArithEmulateUnsupportedFloatsBase &) = delete;
  ArithEmulateUnsupportedFloatsBase(ArithEmulateUnsupportedFloatsBase &&) = delete;
  ArithEmulateUnsupportedFloatsBase& operator=(ArithEmulateUnsupportedFloatsBase &&) = delete;
  ~ArithEmulateUnsupportedFloatsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-emulate-unsupported-floats");
  }
  ::llvm::StringRef getArgument() const override { return "arith-emulate-unsupported-floats"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate operations on unsupported floats with extf/truncf)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithEmulateUnsupportedFloats");
  }
  ::llvm::StringRef getName() const override { return "ArithEmulateUnsupportedFloats"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithEmulateUnsupportedFloatsBase<DerivedT>)

  ArithEmulateUnsupportedFloatsBase(ArithEmulateUnsupportedFloatsOptions options) : ArithEmulateUnsupportedFloatsBase() {
    sourceTypeStrs = std::move(options.sourceTypeStrs);
    targetTypeStr = std::move(options.targetTypeStr);
  }
protected:
  ::mlir::Pass::ListOption<std::string> sourceTypeStrs{*this, "source-types", ::llvm::cl::desc(R"PO(MLIR types without arithmetic support on a given target)PO")};
  ::mlir::Pass::Option<std::string> targetTypeStr{*this, "target-type", ::llvm::cl::desc(R"PO(MLIR type to convert the unsupported source types to)PO"), ::llvm::cl::init("f32")};
private:

  friend std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats(ArithEmulateUnsupportedFloatsOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats() {
  return impl::createArithEmulateUnsupportedFloats();
}

std::unique_ptr<::mlir::Pass> createArithEmulateUnsupportedFloats(ArithEmulateUnsupportedFloatsOptions options) {
  return impl::createArithEmulateUnsupportedFloats(std::move(options));
}
#undef GEN_PASS_DEF_ARITHEMULATEUNSUPPORTEDFLOATS
#endif // GEN_PASS_DEF_ARITHEMULATEUNSUPPORTEDFLOATS

//===----------------------------------------------------------------------===//
// ArithEmulateWideInt
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHEMULATEWIDEINT
struct ArithEmulateWideIntOptions {
  unsigned widestIntSupported = 32;
};
std::unique_ptr<::mlir::Pass> createArithEmulateWideInt();
std::unique_ptr<::mlir::Pass> createArithEmulateWideInt(ArithEmulateWideIntOptions options);
#undef GEN_PASS_DECL_ARITHEMULATEWIDEINT
#endif // GEN_PASS_DECL_ARITHEMULATEWIDEINT
#ifdef GEN_PASS_DEF_ARITHEMULATEWIDEINT

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithEmulateWideInt();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithEmulateWideInt(ArithEmulateWideIntOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithEmulateWideIntBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithEmulateWideIntBase;

  ArithEmulateWideIntBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithEmulateWideIntBase(const ArithEmulateWideIntBase &other) : ::mlir::OperationPass<>(other) {}
  ArithEmulateWideIntBase& operator=(const ArithEmulateWideIntBase &) = delete;
  ArithEmulateWideIntBase(ArithEmulateWideIntBase &&) = delete;
  ArithEmulateWideIntBase& operator=(ArithEmulateWideIntBase &&) = delete;
  ~ArithEmulateWideIntBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-emulate-wide-int");
  }
  ::llvm::StringRef getArgument() const override { return "arith-emulate-wide-int"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate 2*N-bit integer operations using N-bit operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithEmulateWideInt");
  }
  ::llvm::StringRef getName() const override { return "ArithEmulateWideInt"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithEmulateWideIntBase<DerivedT>)

  ArithEmulateWideIntBase(ArithEmulateWideIntOptions options) : ArithEmulateWideIntBase() {
    widestIntSupported = std::move(options.widestIntSupported);
  }
protected:
  ::mlir::Pass::Option<unsigned> widestIntSupported{*this, "widest-int-supported", ::llvm::cl::desc(R"PO(Widest integer type supported by the target)PO"), ::llvm::cl::init(32)};
private:

  friend std::unique_ptr<::mlir::Pass> createArithEmulateWideInt() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createArithEmulateWideInt(ArithEmulateWideIntOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithEmulateWideInt() {
  return impl::createArithEmulateWideInt();
}

std::unique_ptr<::mlir::Pass> createArithEmulateWideInt(ArithEmulateWideIntOptions options) {
  return impl::createArithEmulateWideInt(std::move(options));
}
#undef GEN_PASS_DEF_ARITHEMULATEWIDEINT
#endif // GEN_PASS_DEF_ARITHEMULATEWIDEINT

//===----------------------------------------------------------------------===//
// ArithExpandOpsPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHEXPANDOPSPASS
struct ArithExpandOpsPassOptions {
  bool includeBf16 = false;
  bool includeF8E8M0 = false;
  bool includeF4E2M1 = false;
};
std::unique_ptr<::mlir::Pass> createArithExpandOpsPass();
std::unique_ptr<::mlir::Pass> createArithExpandOpsPass(ArithExpandOpsPassOptions options);
#undef GEN_PASS_DECL_ARITHEXPANDOPSPASS
#endif // GEN_PASS_DECL_ARITHEXPANDOPSPASS
#ifdef GEN_PASS_DEF_ARITHEXPANDOPSPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithExpandOpsPass();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithExpandOpsPass(ArithExpandOpsPassOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithExpandOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithExpandOpsPassBase;

  ArithExpandOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithExpandOpsPassBase(const ArithExpandOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ArithExpandOpsPassBase& operator=(const ArithExpandOpsPassBase &) = delete;
  ArithExpandOpsPassBase(ArithExpandOpsPassBase &&) = delete;
  ArithExpandOpsPassBase& operator=(ArithExpandOpsPassBase &&) = delete;
  ~ArithExpandOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-expand");
  }
  ::llvm::StringRef getArgument() const override { return "arith-expand"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize Arith ops to be convertible to LLVM.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithExpandOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ArithExpandOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithExpandOpsPassBase<DerivedT>)

  ArithExpandOpsPassBase(ArithExpandOpsPassOptions options) : ArithExpandOpsPassBase() {
    includeBf16 = std::move(options.includeBf16);
    includeF8E8M0 = std::move(options.includeF8E8M0);
    includeF4E2M1 = std::move(options.includeF4E2M1);
  }
protected:
  ::mlir::Pass::Option<bool> includeBf16{*this, "include-bf16", ::llvm::cl::desc(R"PO(Enable the BF16 expansion patterns)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> includeF8E8M0{*this, "include-f8e8m0", ::llvm::cl::desc(R"PO(Enable the F8E8M0 expansion patterns)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> includeF4E2M1{*this, "include-f4e2m1", ::llvm::cl::desc(R"PO(Enable the F4E2M1 expansion patterns)PO"), ::llvm::cl::init(false)};
private:

  friend std::unique_ptr<::mlir::Pass> createArithExpandOpsPass() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createArithExpandOpsPass(ArithExpandOpsPassOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithExpandOpsPass() {
  return impl::createArithExpandOpsPass();
}

std::unique_ptr<::mlir::Pass> createArithExpandOpsPass(ArithExpandOpsPassOptions options) {
  return impl::createArithExpandOpsPass(std::move(options));
}
#undef GEN_PASS_DEF_ARITHEXPANDOPSPASS
#endif // GEN_PASS_DEF_ARITHEXPANDOPSPASS

//===----------------------------------------------------------------------===//
// ArithIntRangeNarrowing
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHINTRANGENARROWING
struct ArithIntRangeNarrowingOptions {
  ::llvm::SmallVector<unsigned> bitwidthsSupported;
};
std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing();
std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing(ArithIntRangeNarrowingOptions options);
#undef GEN_PASS_DECL_ARITHINTRANGENARROWING
#endif // GEN_PASS_DECL_ARITHINTRANGENARROWING
#ifdef GEN_PASS_DEF_ARITHINTRANGENARROWING

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing();
} // namespace impl

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing(ArithIntRangeNarrowingOptions options);
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithIntRangeNarrowingBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithIntRangeNarrowingBase;

  ArithIntRangeNarrowingBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithIntRangeNarrowingBase(const ArithIntRangeNarrowingBase &other) : ::mlir::OperationPass<>(other) {}
  ArithIntRangeNarrowingBase& operator=(const ArithIntRangeNarrowingBase &) = delete;
  ArithIntRangeNarrowingBase(ArithIntRangeNarrowingBase &&) = delete;
  ArithIntRangeNarrowingBase& operator=(ArithIntRangeNarrowingBase &&) = delete;
  ~ArithIntRangeNarrowingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-int-range-narrowing");
  }
  ::llvm::StringRef getArgument() const override { return "arith-int-range-narrowing"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Reduce integer operations bitwidth based on integer range analysis)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithIntRangeNarrowing");
  }
  ::llvm::StringRef getName() const override { return "ArithIntRangeNarrowing"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<::mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithIntRangeNarrowingBase<DerivedT>)

  ArithIntRangeNarrowingBase(ArithIntRangeNarrowingOptions options) : ArithIntRangeNarrowingBase() {
    bitwidthsSupported = std::move(options.bitwidthsSupported);
  }
protected:
  ::mlir::Pass::ListOption<unsigned> bitwidthsSupported{*this, "int-bitwidths-supported", ::llvm::cl::desc(R"PO(Integer bitwidths supported)PO")};
private:

  friend std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing() {
    return std::make_unique<DerivedT>();
  }

  friend std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing(ArithIntRangeNarrowingOptions options) {
    return std::make_unique<DerivedT>(std::move(options));
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing() {
  return impl::createArithIntRangeNarrowing();
}

std::unique_ptr<::mlir::Pass> createArithIntRangeNarrowing(ArithIntRangeNarrowingOptions options) {
  return impl::createArithIntRangeNarrowing(std::move(options));
}
#undef GEN_PASS_DEF_ARITHINTRANGENARROWING
#endif // GEN_PASS_DEF_ARITHINTRANGENARROWING

//===----------------------------------------------------------------------===//
// ArithIntRangeOpts
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHINTRANGEOPTS
std::unique_ptr<::mlir::Pass> createArithIntRangeOpts();
#undef GEN_PASS_DECL_ARITHINTRANGEOPTS
#endif // GEN_PASS_DECL_ARITHINTRANGEOPTS
#ifdef GEN_PASS_DEF_ARITHINTRANGEOPTS

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithIntRangeOpts();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithIntRangeOptsBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithIntRangeOptsBase;

  ArithIntRangeOptsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithIntRangeOptsBase(const ArithIntRangeOptsBase &other) : ::mlir::OperationPass<>(other) {}
  ArithIntRangeOptsBase& operator=(const ArithIntRangeOptsBase &) = delete;
  ArithIntRangeOptsBase(ArithIntRangeOptsBase &&) = delete;
  ArithIntRangeOptsBase& operator=(ArithIntRangeOptsBase &&) = delete;
  ~ArithIntRangeOptsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("int-range-optimizations");
  }
  ::llvm::StringRef getArgument() const override { return "int-range-optimizations"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Do optimizations based on integer range analysis)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithIntRangeOpts");
  }
  ::llvm::StringRef getName() const override { return "ArithIntRangeOpts"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<::mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithIntRangeOptsBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createArithIntRangeOpts() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithIntRangeOpts() {
  return impl::createArithIntRangeOpts();
}
#undef GEN_PASS_DEF_ARITHINTRANGEOPTS
#endif // GEN_PASS_DEF_ARITHINTRANGEOPTS

//===----------------------------------------------------------------------===//
// ArithUnsignedWhenEquivalentPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_ARITHUNSIGNEDWHENEQUIVALENTPASS
std::unique_ptr<::mlir::Pass> createArithUnsignedWhenEquivalentPass();
#undef GEN_PASS_DECL_ARITHUNSIGNEDWHENEQUIVALENTPASS
#endif // GEN_PASS_DECL_ARITHUNSIGNEDWHENEQUIVALENTPASS
#ifdef GEN_PASS_DEF_ARITHUNSIGNEDWHENEQUIVALENTPASS

namespace impl {
  std::unique_ptr<::mlir::Pass> createArithUnsignedWhenEquivalentPass();
} // namespace impl
namespace impl {

template <typename DerivedT>
class ArithUnsignedWhenEquivalentPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithUnsignedWhenEquivalentPassBase;

  ArithUnsignedWhenEquivalentPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithUnsignedWhenEquivalentPassBase(const ArithUnsignedWhenEquivalentPassBase &other) : ::mlir::OperationPass<>(other) {}
  ArithUnsignedWhenEquivalentPassBase& operator=(const ArithUnsignedWhenEquivalentPassBase &) = delete;
  ArithUnsignedWhenEquivalentPassBase(ArithUnsignedWhenEquivalentPassBase &&) = delete;
  ArithUnsignedWhenEquivalentPassBase& operator=(ArithUnsignedWhenEquivalentPassBase &&) = delete;
  ~ArithUnsignedWhenEquivalentPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-unsigned-when-equivalent");
  }
  ::llvm::StringRef getArgument() const override { return "arith-unsigned-when-equivalent"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Replace signed ops with unsigned ones where they are proven equivalent)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithUnsignedWhenEquivalentPass");
  }
  ::llvm::StringRef getName() const override { return "ArithUnsignedWhenEquivalentPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithUnsignedWhenEquivalentPassBase<DerivedT>)

protected:
private:

  friend std::unique_ptr<::mlir::Pass> createArithUnsignedWhenEquivalentPass() {
    return std::make_unique<DerivedT>();
  }
};
} // namespace impl

std::unique_ptr<::mlir::Pass> createArithUnsignedWhenEquivalentPass() {
  return impl::createArithUnsignedWhenEquivalentPass();
}
#undef GEN_PASS_DEF_ARITHUNSIGNEDWHENEQUIVALENTPASS
#endif // GEN_PASS_DEF_ARITHUNSIGNEDWHENEQUIVALENTPASS
#ifdef GEN_PASS_REGISTRATION
// Generate registrations for all passes.
#define GEN_PASS_REGISTRATION_ARITHEMULATEUNSUPPORTEDFLOATS
#define GEN_PASS_REGISTRATION_ARITHEMULATEWIDEINT
#define GEN_PASS_REGISTRATION_ARITHEXPANDOPSPASS
#define GEN_PASS_REGISTRATION_ARITHINTRANGENARROWING
#define GEN_PASS_REGISTRATION_ARITHINTRANGEOPTS
#define GEN_PASS_REGISTRATION_ARITHUNSIGNEDWHENEQUIVALENTPASS
#endif // GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ArithEmulateUnsupportedFloats Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHEMULATEUNSUPPORTEDFLOATS

inline void registerArithEmulateUnsupportedFloats() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithEmulateUnsupportedFloats();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithEmulateUnsupportedFloatsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithEmulateUnsupportedFloats();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHEMULATEUNSUPPORTEDFLOATS
#endif // GEN_PASS_REGISTRATION_ARITHEMULATEUNSUPPORTEDFLOATS

//===----------------------------------------------------------------------===//
// ArithEmulateWideInt Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHEMULATEWIDEINT

inline void registerArithEmulateWideInt() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithEmulateWideInt();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithEmulateWideIntPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithEmulateWideInt();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHEMULATEWIDEINT
#endif // GEN_PASS_REGISTRATION_ARITHEMULATEWIDEINT

//===----------------------------------------------------------------------===//
// ArithExpandOpsPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHEXPANDOPSPASS

inline void registerArithExpandOpsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithExpandOpsPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithExpandOpsPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithExpandOpsPass();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHEXPANDOPSPASS
#endif // GEN_PASS_REGISTRATION_ARITHEXPANDOPSPASS

//===----------------------------------------------------------------------===//
// ArithIntRangeNarrowing Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHINTRANGENARROWING

inline void registerArithIntRangeNarrowing() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithIntRangeNarrowing();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithIntRangeNarrowingPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithIntRangeNarrowing();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHINTRANGENARROWING
#endif // GEN_PASS_REGISTRATION_ARITHINTRANGENARROWING

//===----------------------------------------------------------------------===//
// ArithIntRangeOpts Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHINTRANGEOPTS

inline void registerArithIntRangeOpts() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithIntRangeOpts();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithIntRangeOptsPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithIntRangeOpts();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHINTRANGEOPTS
#endif // GEN_PASS_REGISTRATION_ARITHINTRANGEOPTS

//===----------------------------------------------------------------------===//
// ArithUnsignedWhenEquivalentPass Registration
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_REGISTRATION_ARITHUNSIGNEDWHENEQUIVALENTPASS

inline void registerArithUnsignedWhenEquivalentPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithUnsignedWhenEquivalentPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerArithUnsignedWhenEquivalentPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return createArithUnsignedWhenEquivalentPass();
  });
}

#undef GEN_PASS_REGISTRATION_ARITHUNSIGNEDWHENEQUIVALENTPASS
#endif // GEN_PASS_REGISTRATION_ARITHUNSIGNEDWHENEQUIVALENTPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// Arith Registration
//===----------------------------------------------------------------------===//

inline void registerArithPasses() {
  registerArithEmulateUnsupportedFloats();
  registerArithEmulateWideInt();
  registerArithExpandOpsPass();
  registerArithIntRangeNarrowing();
  registerArithIntRangeOpts();
  registerArithUnsignedWhenEquivalentPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class ArithEmulateUnsupportedFloatsBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithEmulateUnsupportedFloatsBase;

  ArithEmulateUnsupportedFloatsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithEmulateUnsupportedFloatsBase(const ArithEmulateUnsupportedFloatsBase &other) : ::mlir::OperationPass<>(other) {}
  ArithEmulateUnsupportedFloatsBase& operator=(const ArithEmulateUnsupportedFloatsBase &) = delete;
  ArithEmulateUnsupportedFloatsBase(ArithEmulateUnsupportedFloatsBase &&) = delete;
  ArithEmulateUnsupportedFloatsBase& operator=(ArithEmulateUnsupportedFloatsBase &&) = delete;
  ~ArithEmulateUnsupportedFloatsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-emulate-unsupported-floats");
  }
  ::llvm::StringRef getArgument() const override { return "arith-emulate-unsupported-floats"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate operations on unsupported floats with extf/truncf)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithEmulateUnsupportedFloats");
  }
  ::llvm::StringRef getName() const override { return "ArithEmulateUnsupportedFloats"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithEmulateUnsupportedFloatsBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<std::string> sourceTypeStrs{*this, "source-types", ::llvm::cl::desc(R"PO(MLIR types without arithmetic support on a given target)PO")};
  ::mlir::Pass::Option<std::string> targetTypeStr{*this, "target-type", ::llvm::cl::desc(R"PO(MLIR type to convert the unsupported source types to)PO"), ::llvm::cl::init("f32")};
};

template <typename DerivedT>
class ArithEmulateWideIntBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithEmulateWideIntBase;

  ArithEmulateWideIntBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithEmulateWideIntBase(const ArithEmulateWideIntBase &other) : ::mlir::OperationPass<>(other) {}
  ArithEmulateWideIntBase& operator=(const ArithEmulateWideIntBase &) = delete;
  ArithEmulateWideIntBase(ArithEmulateWideIntBase &&) = delete;
  ArithEmulateWideIntBase& operator=(ArithEmulateWideIntBase &&) = delete;
  ~ArithEmulateWideIntBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-emulate-wide-int");
  }
  ::llvm::StringRef getArgument() const override { return "arith-emulate-wide-int"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Emulate 2*N-bit integer operations using N-bit operations)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithEmulateWideInt");
  }
  ::llvm::StringRef getName() const override { return "ArithEmulateWideInt"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithEmulateWideIntBase<DerivedT>)

protected:
  ::mlir::Pass::Option<unsigned> widestIntSupported{*this, "widest-int-supported", ::llvm::cl::desc(R"PO(Widest integer type supported by the target)PO"), ::llvm::cl::init(32)};
};

template <typename DerivedT>
class ArithExpandOpsPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithExpandOpsPassBase;

  ArithExpandOpsPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithExpandOpsPassBase(const ArithExpandOpsPassBase &other) : ::mlir::OperationPass<>(other) {}
  ArithExpandOpsPassBase& operator=(const ArithExpandOpsPassBase &) = delete;
  ArithExpandOpsPassBase(ArithExpandOpsPassBase &&) = delete;
  ArithExpandOpsPassBase& operator=(ArithExpandOpsPassBase &&) = delete;
  ~ArithExpandOpsPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-expand");
  }
  ::llvm::StringRef getArgument() const override { return "arith-expand"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Legalize Arith ops to be convertible to LLVM.)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithExpandOpsPass");
  }
  ::llvm::StringRef getName() const override { return "ArithExpandOpsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<vector::VectorDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithExpandOpsPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> includeBf16{*this, "include-bf16", ::llvm::cl::desc(R"PO(Enable the BF16 expansion patterns)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> includeF8E8M0{*this, "include-f8e8m0", ::llvm::cl::desc(R"PO(Enable the F8E8M0 expansion patterns)PO"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> includeF4E2M1{*this, "include-f4e2m1", ::llvm::cl::desc(R"PO(Enable the F4E2M1 expansion patterns)PO"), ::llvm::cl::init(false)};
};

template <typename DerivedT>
class ArithIntRangeNarrowingBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithIntRangeNarrowingBase;

  ArithIntRangeNarrowingBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithIntRangeNarrowingBase(const ArithIntRangeNarrowingBase &other) : ::mlir::OperationPass<>(other) {}
  ArithIntRangeNarrowingBase& operator=(const ArithIntRangeNarrowingBase &) = delete;
  ArithIntRangeNarrowingBase(ArithIntRangeNarrowingBase &&) = delete;
  ArithIntRangeNarrowingBase& operator=(ArithIntRangeNarrowingBase &&) = delete;
  ~ArithIntRangeNarrowingBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-int-range-narrowing");
  }
  ::llvm::StringRef getArgument() const override { return "arith-int-range-narrowing"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Reduce integer operations bitwidth based on integer range analysis)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithIntRangeNarrowing");
  }
  ::llvm::StringRef getName() const override { return "ArithIntRangeNarrowing"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<::mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithIntRangeNarrowingBase<DerivedT>)

protected:
  ::mlir::Pass::ListOption<unsigned> bitwidthsSupported{*this, "int-bitwidths-supported", ::llvm::cl::desc(R"PO(Integer bitwidths supported)PO")};
};

template <typename DerivedT>
class ArithIntRangeOptsBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithIntRangeOptsBase;

  ArithIntRangeOptsBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithIntRangeOptsBase(const ArithIntRangeOptsBase &other) : ::mlir::OperationPass<>(other) {}
  ArithIntRangeOptsBase& operator=(const ArithIntRangeOptsBase &) = delete;
  ArithIntRangeOptsBase(ArithIntRangeOptsBase &&) = delete;
  ArithIntRangeOptsBase& operator=(ArithIntRangeOptsBase &&) = delete;
  ~ArithIntRangeOptsBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("int-range-optimizations");
  }
  ::llvm::StringRef getArgument() const override { return "int-range-optimizations"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Do optimizations based on integer range analysis)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithIntRangeOpts");
  }
  ::llvm::StringRef getName() const override { return "ArithIntRangeOpts"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    registry.insert<::mlir::arith::ArithDialect>();
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithIntRangeOptsBase<DerivedT>)

protected:
};

template <typename DerivedT>
class ArithUnsignedWhenEquivalentPassBase : public ::mlir::OperationPass<> {
public:
  using Base = ArithUnsignedWhenEquivalentPassBase;

  ArithUnsignedWhenEquivalentPassBase() : ::mlir::OperationPass<>(::mlir::TypeID::get<DerivedT>()) {}
  ArithUnsignedWhenEquivalentPassBase(const ArithUnsignedWhenEquivalentPassBase &other) : ::mlir::OperationPass<>(other) {}
  ArithUnsignedWhenEquivalentPassBase& operator=(const ArithUnsignedWhenEquivalentPassBase &) = delete;
  ArithUnsignedWhenEquivalentPassBase(ArithUnsignedWhenEquivalentPassBase &&) = delete;
  ArithUnsignedWhenEquivalentPassBase& operator=(ArithUnsignedWhenEquivalentPassBase &&) = delete;
  ~ArithUnsignedWhenEquivalentPassBase() = default;

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("arith-unsigned-when-equivalent");
  }
  ::llvm::StringRef getArgument() const override { return "arith-unsigned-when-equivalent"; }

  ::llvm::StringRef getDescription() const override { return R"PD(Replace signed ops with unsigned ones where they are proven equivalent)PD"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ArithUnsignedWhenEquivalentPass");
  }
  ::llvm::StringRef getName() const override { return "ArithUnsignedWhenEquivalentPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Register the dialects that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(ArithUnsignedWhenEquivalentPassBase<DerivedT>)

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
