/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Definitions                                                   *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: FIRAttr.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace fir {

::llvm::StringRef stringifyLocalitySpecifierType(LocalitySpecifierType val) {
  switch (val) {
    case LocalitySpecifierType::Local: return "local";
    case LocalitySpecifierType::LocalInit: return "local_init";
  }
  return "";
}

::std::optional<LocalitySpecifierType> symbolizeLocalitySpecifierType(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<LocalitySpecifierType>>(str)
      .Case("local", LocalitySpecifierType::Local)
      .Case("local_init", LocalitySpecifierType::LocalInit)
      .Default(::std::nullopt);
}
::std::optional<LocalitySpecifierType> symbolizeLocalitySpecifierType(uint32_t value) {
  switch (value) {
  case 0: return LocalitySpecifierType::Local;
  case 1: return LocalitySpecifierType::LocalInit;
  default: return ::std::nullopt;
  }
}


} // namespace fir
namespace fir {

::llvm::StringRef stringifyBoxFieldAttr(BoxFieldAttr val) {
  switch (val) {
    case BoxFieldAttr::base_addr: return "base_addr";
    case BoxFieldAttr::derived_type: return "derived_type";
  }
  return "";
}

::std::optional<BoxFieldAttr> symbolizeBoxFieldAttr(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<BoxFieldAttr>>(str)
      .Case("base_addr", BoxFieldAttr::base_addr)
      .Case("derived_type", BoxFieldAttr::derived_type)
      .Default(::std::nullopt);
}
::std::optional<BoxFieldAttr> symbolizeBoxFieldAttr(uint32_t value) {
  switch (value) {
  case 0: return BoxFieldAttr::base_addr;
  case 1: return BoxFieldAttr::derived_type;
  default: return ::std::nullopt;
  }
}

bool BoxFieldAttrAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && (((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 0)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 1)))));
}
BoxFieldAttrAttr BoxFieldAttrAttr::get(::mlir::MLIRContext *context, BoxFieldAttr val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<BoxFieldAttrAttr>(baseAttr);
}
BoxFieldAttr BoxFieldAttrAttr::getValue() const {
  return static_cast<BoxFieldAttr>(::mlir::IntegerAttr::getValue().getZExtValue());
}

} // namespace fir
namespace fir {

std::string stringifyFortranInlineEnum(FortranInlineEnum symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(7u == (7u | val) && "invalid bits set in bit enum");
  // Special case for all bits unset.
  if (val == 0) return "none";

  ::llvm::SmallVector<::llvm::StringRef, 2> strs;
  // Print bit enum groups before individual bits

  if (1u == (1u & val))
    strs.push_back("no_inline");

  if (2u == (2u & val))
    strs.push_back("always_inline");

  if (4u == (4u & val))
    strs.push_back("inline_hint");
  return ::llvm::join(strs, ", ");
}

::std::optional<FortranInlineEnum> symbolizeFortranInlineEnum(::llvm::StringRef str) {
  // Special case for all bits unset.
  if (str == "none") return FortranInlineEnum::none;

  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, ",");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("no_inline", 1)
      .Case("always_inline", 2)
      .Case("inline_hint", 4)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<FortranInlineEnum>(val);
}

::std::optional<FortranInlineEnum> symbolizeFortranInlineEnum(uint32_t value) {
  // Special case for all bits unset.
  if (value == 0) return FortranInlineEnum::none;

  if (value & ~static_cast<uint32_t>(7u)) return std::nullopt;
  return static_cast<FortranInlineEnum>(value);
}

} // namespace fir
namespace fir {

std::string stringifyFortranProcedureFlagsEnum(FortranProcedureFlagsEnum symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(31u == (31u | val) && "invalid bits set in bit enum");
  // Special case for all bits unset.
  if (val == 0) return "none";

  ::llvm::SmallVector<::llvm::StringRef, 2> strs;
  // Print bit enum groups before individual bits

  if (1u == (1u & val))
    strs.push_back("elemental");

  if (2u == (2u & val))
    strs.push_back("pure");

  if (4u == (4u & val))
    strs.push_back("non_recursive");

  if (8u == (8u & val))
    strs.push_back("simple");

  if (16u == (16u & val))
    strs.push_back("bind_c");
  return ::llvm::join(strs, ", ");
}

::std::optional<FortranProcedureFlagsEnum> symbolizeFortranProcedureFlagsEnum(::llvm::StringRef str) {
  // Special case for all bits unset.
  if (str == "none") return FortranProcedureFlagsEnum::none;

  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, ",");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("elemental", 1)
      .Case("pure", 2)
      .Case("non_recursive", 4)
      .Case("simple", 8)
      .Case("bind_c", 16)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<FortranProcedureFlagsEnum>(val);
}

::std::optional<FortranProcedureFlagsEnum> symbolizeFortranProcedureFlagsEnum(uint32_t value) {
  // Special case for all bits unset.
  if (value == 0) return FortranProcedureFlagsEnum::none;

  if (value & ~static_cast<uint32_t>(31u)) return std::nullopt;
  return static_cast<FortranProcedureFlagsEnum>(value);
}

} // namespace fir
namespace fir {

std::string stringifyFortranVariableFlagsEnum(FortranVariableFlagsEnum symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(32767u == (32767u | val) && "invalid bits set in bit enum");
  // Special case for all bits unset.
  if (val == 0) return "None";

  ::llvm::SmallVector<::llvm::StringRef, 2> strs;
  // Print bit enum groups before individual bits

  if (1u == (1u & val))
    strs.push_back("allocatable");

  if (2u == (2u & val))
    strs.push_back("asynchronous");

  if (4u == (4u & val))
    strs.push_back("bind_c");

  if (8u == (8u & val))
    strs.push_back("contiguous");

  if (16u == (16u & val))
    strs.push_back("intent_in");

  if (32u == (32u & val))
    strs.push_back("intent_inout");

  if (64u == (64u & val))
    strs.push_back("intent_out");

  if (128u == (128u & val))
    strs.push_back("optional");

  if (256u == (256u & val))
    strs.push_back("parameter");

  if (512u == (512u & val))
    strs.push_back("pointer");

  if (1024u == (1024u & val))
    strs.push_back("target");

  if (2048u == (2048u & val))
    strs.push_back("value");

  if (4096u == (4096u & val))
    strs.push_back("volatile");

  if (8192u == (8192u & val))
    strs.push_back("host_assoc");

  if (16384u == (16384u & val))
    strs.push_back("internal_assoc");
  return ::llvm::join(strs, ", ");
}

::std::optional<FortranVariableFlagsEnum> symbolizeFortranVariableFlagsEnum(::llvm::StringRef str) {
  // Special case for all bits unset.
  if (str == "None") return FortranVariableFlagsEnum::None;

  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, ",");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("allocatable", 1)
      .Case("asynchronous", 2)
      .Case("bind_c", 4)
      .Case("contiguous", 8)
      .Case("intent_in", 16)
      .Case("intent_inout", 32)
      .Case("intent_out", 64)
      .Case("optional", 128)
      .Case("parameter", 256)
      .Case("pointer", 512)
      .Case("target", 1024)
      .Case("value", 2048)
      .Case("volatile", 4096)
      .Case("host_assoc", 8192)
      .Case("internal_assoc", 16384)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<FortranVariableFlagsEnum>(val);
}

::std::optional<FortranVariableFlagsEnum> symbolizeFortranVariableFlagsEnum(uint32_t value) {
  // Special case for all bits unset.
  if (value == 0) return FortranVariableFlagsEnum::None;

  if (value & ~static_cast<uint32_t>(32767u)) return std::nullopt;
  return static_cast<FortranVariableFlagsEnum>(value);
}
bool FortranVariableFlagsEnumAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!(::llvm::cast<::mlir::IntegerAttr>(attr).getValue().getZExtValue() & (~(0u|1u|2u|4u|8u|16u|32u|64u|128u|256u|512u|1024u|2048u|4096u|8192u|16384u)))));
}
FortranVariableFlagsEnumAttr FortranVariableFlagsEnumAttr::get(::mlir::MLIRContext *context, FortranVariableFlagsEnum val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<FortranVariableFlagsEnumAttr>(baseAttr);
}
FortranVariableFlagsEnum FortranVariableFlagsEnumAttr::getValue() const {
  return static_cast<FortranVariableFlagsEnum>(::mlir::IntegerAttr::getValue().getZExtValue());
}

} // namespace fir
namespace fir {

::llvm::StringRef stringifyLocationKind(LocationKind val) {
  switch (val) {
    case LocationKind::Base: return "base";
    case LocationKind::Inclusion: return "inclusion";
  }
  return "";
}

::std::optional<LocationKind> symbolizeLocationKind(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<LocationKind>>(str)
      .Case("base", LocationKind::Base)
      .Case("inclusion", LocationKind::Inclusion)
      .Default(::std::nullopt);
}
::std::optional<LocationKind> symbolizeLocationKind(uint32_t value) {
  switch (value) {
  case 0: return LocationKind::Base;
  case 1: return LocationKind::Inclusion;
  default: return ::std::nullopt;
  }
}


} // namespace fir
namespace fir {

::llvm::StringRef stringifyLowerBoundModifierAttribute(LowerBoundModifierAttribute val) {
  switch (val) {
    case LowerBoundModifierAttribute::Preserve: return "preserve";
    case LowerBoundModifierAttribute::SetToOnes: return "ones";
    case LowerBoundModifierAttribute::SetToZeroes: return "zeroes";
  }
  return "";
}

::std::optional<LowerBoundModifierAttribute> symbolizeLowerBoundModifierAttribute(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<LowerBoundModifierAttribute>>(str)
      .Case("preserve", LowerBoundModifierAttribute::Preserve)
      .Case("ones", LowerBoundModifierAttribute::SetToOnes)
      .Case("zeroes", LowerBoundModifierAttribute::SetToZeroes)
      .Default(::std::nullopt);
}
::std::optional<LowerBoundModifierAttribute> symbolizeLowerBoundModifierAttribute(uint32_t value) {
  switch (value) {
  case 0: return LowerBoundModifierAttribute::Preserve;
  case 1: return LowerBoundModifierAttribute::SetToOnes;
  case 2: return LowerBoundModifierAttribute::SetToZeroes;
  default: return ::std::nullopt;
  }
}

bool LowerBoundModifierAttributeAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && (((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 0)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 1)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 2)))));
}
LowerBoundModifierAttributeAttr LowerBoundModifierAttributeAttr::get(::mlir::MLIRContext *context, LowerBoundModifierAttribute val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<LowerBoundModifierAttributeAttr>(baseAttr);
}
LowerBoundModifierAttribute LowerBoundModifierAttributeAttr::getValue() const {
  return static_cast<LowerBoundModifierAttribute>(::mlir::IntegerAttr::getValue().getZExtValue());
}

} // namespace fir
namespace fir {

std::string stringifyPackArrayHeuristics(PackArrayHeuristics symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(1u == (1u | val) && "invalid bits set in bit enum");
  // Special case for all bits unset.
  if (val == 0) return "none";

  ::llvm::SmallVector<::llvm::StringRef, 2> strs;

  if (1u == (1u & val))
    strs.push_back("loop_only");
  return ::llvm::join(strs, ", ");
}

::std::optional<PackArrayHeuristics> symbolizePackArrayHeuristics(::llvm::StringRef str) {
  // Special case for all bits unset.
  if (str == "none") return PackArrayHeuristics::None;

  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, ",");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("loop_only", 1)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<PackArrayHeuristics>(val);
}

::std::optional<PackArrayHeuristics> symbolizePackArrayHeuristics(uint32_t value) {
  // Special case for all bits unset.
  if (value == 0) return PackArrayHeuristics::None;

  if (value & ~static_cast<uint32_t>(1u)) return std::nullopt;
  return static_cast<PackArrayHeuristics>(value);
}

} // namespace fir
namespace fir {

std::string stringifyReduceOperationEnum(ReduceOperationEnum symbol) {
  auto val = static_cast<uint32_t>(symbol);
  assert(2047u == (2047u | val) && "invalid bits set in bit enum");
  ::llvm::SmallVector<::llvm::StringRef, 2> strs;
  // Print bit enum groups before individual bits

  if (1u == (1u & val))
    strs.push_back("add");

  if (2u == (2u & val))
    strs.push_back("multiply");

  if (4u == (4u & val))
    strs.push_back("and");

  if (8u == (8u & val))
    strs.push_back("or");

  if (16u == (16u & val))
    strs.push_back("eqv");

  if (32u == (32u & val))
    strs.push_back("neqv");

  if (64u == (64u & val))
    strs.push_back("max");

  if (128u == (128u & val))
    strs.push_back("min");

  if (256u == (256u & val))
    strs.push_back("iand");

  if (512u == (512u & val))
    strs.push_back("ior");

  if (1024u == (1024u & val))
    strs.push_back("ieor");
  return ::llvm::join(strs, ", ");
}

::std::optional<ReduceOperationEnum> symbolizeReduceOperationEnum(::llvm::StringRef str) {
  ::llvm::SmallVector<::llvm::StringRef, 2> symbols;
  str.split(symbols, ",");

  uint32_t val = 0;
  for (auto symbol : symbols) {
    auto bit = llvm::StringSwitch<::std::optional<uint32_t>>(symbol.trim())
      .Case("add", 1)
      .Case("multiply", 2)
      .Case("and", 4)
      .Case("or", 8)
      .Case("eqv", 16)
      .Case("neqv", 32)
      .Case("max", 64)
      .Case("min", 128)
      .Case("iand", 256)
      .Case("ior", 512)
      .Case("ieor", 1024)
      .Default(::std::nullopt);
    if (bit) { val |= *bit; } else { return ::std::nullopt; }
  }
  return static_cast<ReduceOperationEnum>(val);
}

::std::optional<ReduceOperationEnum> symbolizeReduceOperationEnum(uint32_t value) {
  if (value & ~static_cast<uint32_t>(2047u)) return std::nullopt;
  return static_cast<ReduceOperationEnum>(value);
}
bool ReduceOperationEnumAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && ((!(::llvm::cast<::mlir::IntegerAttr>(attr).getValue().getZExtValue() & (~(1u|2u|4u|8u|16u|32u|64u|128u|256u|512u|1024u)))));
}
ReduceOperationEnumAttr ReduceOperationEnumAttr::get(::mlir::MLIRContext *context, ReduceOperationEnum val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<ReduceOperationEnumAttr>(baseAttr);
}
ReduceOperationEnum ReduceOperationEnumAttr::getValue() const {
  return static_cast<ReduceOperationEnum>(::mlir::IntegerAttr::getValue().getZExtValue());
}

} // namespace fir
