# - Config file for rocprofiler-systems and its component libraries
# It defines the following variables:
#
# rocprofiler-systems_INCLUDE_DIRS
# rocprofiler-systems_LIBRARIES
# rocprofiler-systems_INTERNAL_DEFINES - used by the test suite

# compute paths
get_filename_component(rocprofiler-systems_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# version
include(${CMAKE_CURRENT_LIST_DIR}/rocprofiler-systems-version.cmake)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rocprof-sys-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocprofiler-systems_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocprofiler-systems_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
get_filename_component(rocprofiler-systems_ROOT_DIR ${rocprofiler-systems_INCLUDE_DIR} PATH)

set(rocprofiler-systems_LIBRARIES)

add_library(rocprofiler-systems::rocprofiler-systems INTERFACE IMPORTED)

include("${rocprofiler-systems_CMAKE_DIR}/rocprofiler-systems-library-targets.cmake")

# Library dependencies
foreach(TARG user)
    set(TARG rocprofiler-systems-${TARG}-library)
    if(NOT rocprofiler-systems_FIND_COMPONENTS)
        list(APPEND rocprofiler-systems_LIBRARIES rocprofiler-systems::${TARG})
        target_link_libraries(rocprofiler-systems::rocprofiler-systems
                              INTERFACE rocprofiler-systems::${TARG})
    endif()
endforeach()

if(rocprofiler-systems_FIND_COMPONENTS)
    foreach(COMP ${rocprofiler-systems_FIND_COMPONENTS})
        set(TARG rocprofiler-systems::rocprofiler-systems-${COMP}-library)
        if(TARGET ${TARG})
            set(rocprofiler-systems_${COMP}_FOUND 1)
            list(APPEND rocprofiler-systems_LIBRARIES ${TARG})
            target_link_libraries(rocprofiler-systems::rocprofiler-systems
                                  INTERFACE ${TARG})
        else()
            set(rocprofiler-systems_${COMP}_FOUND 0)
        endif()
    endforeach()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocprofiler-systems
    FOUND_VAR rocprofiler-systems_FOUND
    REQUIRED_VARS rocprofiler-systems_ROOT_DIR rocprofiler-systems_INCLUDE_DIR rocprofiler-systems_LIBRARIES
    VERSION_VAR rocprofiler-systems_VERSION
    HANDLE_COMPONENTS)
