# - Config file for the rdc package
# It defines the following variables
#  RDC_INCLUDE_DIRS - include directories for rdc
#  RDC_LIBRARIES    - libraries to link against


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was rdc-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Compute paths
get_filename_component(RDC_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
set(ROCM_RDC_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/${CMAKE_INSTALL_INCLUDEDIR}")
set(ROCM_RDC_LIB_DIR "${PACKAGE_PREFIX_DIR}/${CMAKE_INSTALL_LIBDIR}")

# Our library dependencies (contains definitions for IMPORTED targets)
if(NOT TARGET rdc_libs AND NOT rdc_BINARY_DIR)
    include("${RDC_CMAKE_DIR}/rdcTargets.cmake")
endif()

# These are IMPORTED targets created by rdcTargets.cmake
set(ROCM_RDC_LIBRARIES "librdc_bootstrap.so")
