# Copyright © Advanced Micro Devices, Inc., or its affiliates.
# SPDX-License-Identifier:  MIT


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was hipdnn_data_sdkConfig_imported.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Extract and use include directories from dependency targets instead of linking
# Function to add include directories and optional compile definitions from dependency targets
# !!!! Note !!!! We are using this to force a headeronly consumption of 3rd party dependencies for hipdnn_data_sdk
# Using regular linking will result in a non-header only consumption of these libraries due to the way they are configured when installing
function(hipdnn_add_dependency_includes TARGET_NAME HEADER_LIB_TARGET_NAME)
    # Parse optional arguments
    set(options "")
    set(oneValueArgs "")
    set(multiValueArgs COMPILE_DEFINITIONS)
    cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

    # Validate required parameters
    if(NOT TARGET ${TARGET_NAME})
        message(FATAL_ERROR "hipdnn_add_dependency_includes: Target '${TARGET_NAME}' does not exist")
        return()
    endif()

    if(NOT TARGET ${HEADER_LIB_TARGET_NAME})
        message(FATAL_ERROR "hipdnn_add_dependency_includes: Header library target '${HEADER_LIB_TARGET_NAME}' does not exist")
        return()
    endif()

    if(TARGET ${HEADER_LIB_TARGET_NAME})
        get_target_property(_dep_includes ${HEADER_LIB_TARGET_NAME} INTERFACE_INCLUDE_DIRECTORIES)
        if(_dep_includes)
            message(VERBOSE "${TARGET_NAME} adding includes from ${HEADER_LIB_TARGET_NAME}: ${_dep_includes}")
            target_include_directories(${TARGET_NAME} SYSTEM INTERFACE ${_dep_includes})
        endif()

        if(ARG_COMPILE_DEFINITIONS)
            target_compile_definitions(${TARGET_NAME} INTERFACE ${ARG_COMPILE_DEFINITIONS})
        endif()
    endif()
endfunction()

# Find required dependencies
find_package(Threads REQUIRED)

include(CMakeFindDependencyMacro)

find_dependency(hip CONFIG REQUIRED)

find_dependency(flatbuffers REQUIRED)
find_dependency(spdlog REQUIRED)
find_dependency(nlohmann_json REQUIRED)

# fmt can potentially be embedded in spdlog, make this dependency quiet, and conditional include the path
find_dependency(fmt QUIET)

# Subdirectory path for hipDNN engine plugins (relative to lib)
set(HIPDNN_PLUGIN_ENGINE_SUBDIR "hipdnn_plugins/engines")

# Install path for engine plugins
set(HIPDNN_FULL_INSTALL_PLUGIN_ENGINE_DIR "/therock/output/build/ml-libs/hipDNN/stage/lib/hipdnn_plugins/engines")
set(HIPDNN_RELATIVE_INSTALL_PLUGIN_ENGINE_DIR "lib/hipdnn_plugins/engines")

include("${CMAKE_CURRENT_LIST_DIR}/hipdnn_data_sdkTargets.cmake")

hipdnn_add_dependency_includes(hipdnn_data_sdk flatbuffers::flatbuffers)
hipdnn_add_dependency_includes(hipdnn_data_sdk spdlog::spdlog_header_only)
hipdnn_add_dependency_includes(hipdnn_data_sdk nlohmann_json::nlohmann_json)
if (fmt_FOUND)
    message(STATUS "Found fmt: using system fmt")
    hipdnn_add_dependency_includes(hipdnn_data_sdk fmt::fmt COMPILE_DEFINITIONS SPDLOG_FMT_EXTERNAL)
else()
    message(STATUS "Not found fmt: using bundled fmt from spdlog")
endif()

message(STATUS "hipDNN Data SDK: Engine plugin build directory is ${CMAKE_INSTALL_LIBDIR}/${HIPDNN_PLUGIN_ENGINE_SUBDIR}")
message(STATUS "hipDNN Data SDK: Plugin absolute installation directory ${HIPDNN_FULL_INSTALL_PLUGIN_ENGINE_DIR}")
message(STATUS "hipDNN Data SDK: Plugin relative installation directory ${HIPDNN_RELATIVE_INSTALL_PLUGIN_ENGINE_DIR}")
