// MIT License
//
// Copyright (c) 2023-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

/**
 * @file rocprofiler-sdk/ext_version.h
 * @brief Defines versions for external dependencies
 *
 */

// clang-format off
#define ROCPROFILER_HSA_RUNTIME_VERSION_MAJOR 1
#define ROCPROFILER_HSA_RUNTIME_VERSION_MINOR 18

#define ROCPROFILER_HSA_API_TABLE_MAJOR_VERSION 0x03
#define ROCPROFILER_HSA_CORE_API_TABLE_MAJOR_VERSION 0x02
#define ROCPROFILER_HSA_AMD_EXT_API_TABLE_MAJOR_VERSION 0x02
#define ROCPROFILER_HSA_FINALIZER_API_TABLE_MAJOR_VERSION 0x02
#define ROCPROFILER_HSA_IMAGE_API_TABLE_MAJOR_VERSION 0x02
#define ROCPROFILER_HSA_AQLPROFILE_API_TABLE_MAJOR_VERSION 0x01
#define ROCPROFILER_HSA_TOOLS_API_TABLE_MAJOR_VERSION 0x01

#define ROCPROFILER_HSA_API_TABLE_STEP_VERSION 0x01
#define ROCPROFILER_HSA_CORE_API_TABLE_STEP_VERSION 0x00
#define ROCPROFILER_HSA_AMD_EXT_API_TABLE_STEP_VERSION 0x09
#define ROCPROFILER_HSA_FINALIZER_API_TABLE_STEP_VERSION 0x00
#define ROCPROFILER_HSA_IMAGE_API_TABLE_STEP_VERSION 0x01
#define ROCPROFILER_HSA_AQLPROFILE_API_TABLE_STEP_VERSION 0x00
#define ROCPROFILER_HSA_TOOLS_API_TABLE_STEP_VERSION 0x00
// clang-format on

// latest hsa-runtime version supported
#define ROCPROFILER_HSA_RUNTIME_VERSION                                                            \
    ((10000 * ROCPROFILER_HSA_RUNTIME_VERSION_MAJOR) +                                             \
     (100 * ROCPROFILER_HSA_RUNTIME_VERSION_MINOR))
