// Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_

#include "../../../config.hpp"
#include "../../../type_traits.hpp"
#include "../../config_types.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{
template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 6}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 10}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 14}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 6}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 6}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 10}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 14}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 6}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 14}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 12}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {128, 7}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 10}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {128, 12}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 16}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 16}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 16}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {128, 7}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 12}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {128, 12}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {128, 11}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 12}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 20}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {128, 13}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 22}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 20}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 7}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 9}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 12}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 16}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 8}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 7}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 9}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 12}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 16}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 8}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 16}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 32}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 16}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 5}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 8}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 13}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 14}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 16}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 12}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 14}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 16}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 8}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 8}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 13}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 14}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 16}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 12}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 16}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 14}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 17}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 5}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 8}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 13}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 16}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 12}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 16}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 5}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 8}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 13}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 16}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 12}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {256, 13}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 17}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 4}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 5}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 5}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 10}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 9}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 5}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 10}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {128, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 5}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 5}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 7}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {192, 10}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 9}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {192, 5}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 10}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {192, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {256, 6}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {192, 10}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {256, 28}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {192, 28}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on key_type = double, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = double, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = double, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = double, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = double, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = float, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = float, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = float, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on key_type = float, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = float, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on key_type = rocprim::half, value_type = rocprim::int128_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = rocprim::half, value_type = int64_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = rocprim::half, value_type = int
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = rocprim::half, value_type = short
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 22}
        };
    }
    // Based on key_type = rocprim::half, value_type = int8_t
    if constexpr((bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                  && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                  && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                  && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                  && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                  && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                  && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 14}
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                  && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 22}
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                  && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                  && (sizeof(value_type) <= 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<key_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto select_unique_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>::value,
    partition_config_params>
{
    return select_unique_by_key_config_picker<
        comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
        key_type,
        value_type>();
}

// All the existing configs should be auto generated
using select_unique_by_key_targets
    = comp_targets<comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>,
                   comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>,
                   comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>,
                   comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
                   comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>,
                   comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>,
                   comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>;

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_
