// Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_PREDICATE_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_PREDICATE_HPP_

#include "../../../config.hpp"
#include "../../../type_traits.hpp"
#include "../../config_types.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{
template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 6}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {256, 30}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 8}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {256, 30}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {128, 14}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {192, 22}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {512, 4}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {384, 6}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {128, 14}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {128, 30}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {256, 28}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {384, 7}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {384, 18}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {256, 4}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {384, 7}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {384, 18}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {384, 28}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {256, 7}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {256, 15}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {256, 7}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {192, 15}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {256, 26}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {128, 7}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {256, 15}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {128, 7}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {256, 14}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {256, 26}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {128, 6}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 10}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {256, 20}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {256, 3}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {512, 5}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 10}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {256, 20}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {256, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>>::value,
    partition_config_params>
{
    // Based on data_type = double
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on data_type = float
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on data_type = rocprim::half
    if constexpr((bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)))
    {
        return partition_config_params{
            {512, 30}
        };
    }
    // Based on data_type = rocprim::int128_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 16)
                  && (sizeof(data_type) > 8)))
    {
        return partition_config_params{
            {384, 4}
        };
    }
    // Based on data_type = int64_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 8)
                  && (sizeof(data_type) > 4)))
    {
        return partition_config_params{
            {512, 7}
        };
    }
    // Based on data_type = int
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 4)
                  && (sizeof(data_type) > 2)))
    {
        return partition_config_params{
            {512, 15}
        };
    }
    // Based on data_type = short
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 2)
                  && (sizeof(data_type) > 1)))
    {
        return partition_config_params{
            {512, 30}
        };
    }
    // Based on data_type = int8_t
    if constexpr((!bool(rocprim::is_floating_point<data_type>::value) && (sizeof(data_type) <= 1)))
    {
        return partition_config_params{
            {512, 24}
        };
    }
    // Default case if none of the conditions match
    return partition_config_params_base<data_type>();
}

template<class Target, class data_type>
constexpr auto select_predicate_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>::value,
    partition_config_params>
{
    return select_predicate_config_picker<
        comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
        data_type>();
}

// All the existing configs should be auto generated
using select_predicate_targets
    = comp_targets<comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>,
                   comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>,
                   comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>,
                   comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
                   comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>,
                   comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>,
                   comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>;

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_PREDICATE_HPP_
