// Copyright (c) 2024-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_

#include "../../../type_traits.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{
template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {128, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan,
            2
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 11},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 4},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 9},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::rdna4, target_arch::gfx1201, gpu::rx9070, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 13},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 13},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {128, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {384, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {384, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {384, 8},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {384, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {384, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {512, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {128, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {128, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {128, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {128, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {128, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {128, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 6},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 12},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {128, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 5},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {192, 10},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    // Based on key_type = rocprim::int128_t, value_type = double
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = float
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 7},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = short
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = rocprim::int128_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 16) && (sizeof(key_type) > 8)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = double
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = float
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = short
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int64_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 8) && (sizeof(key_type) > 4)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = double
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = float
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = short
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 4) && (sizeof(key_type) > 2)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = double
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = float
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = short
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = short, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 2) && (sizeof(key_type) > 1)
                  && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = double
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = float
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::half
    if constexpr(((sizeof(key_type) <= 1) && bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = rocprim::int128_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8)))
    {
        return reduce_by_key_config_params{
            {256, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int64_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2)))
    {
        return reduce_by_key_config_params{
            {512, 15},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = short
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Based on key_type = int8_t, value_type = int8_t
    if constexpr(((sizeof(key_type) <= 1) && !bool(rocprim::is_floating_point<value_type>::value)
                  && (sizeof(value_type) <= 1)))
    {
        return reduce_by_key_config_params{
            {192, 14},
            block_load_method::block_load_transpose,
            block_load_method::block_load_transpose,
            block_scan_algorithm::using_warp_scan
        };
    }
    // Default case if none of the conditions match
    return reduce_by_key_config_params_base<key_type, value_type>();
}

template<class Target, class key_type, class value_type>
constexpr auto reduce_by_key_config_picker() -> std::enable_if_t<
    std::is_same<Target,
                 comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>::value,
    reduce_by_key_config_params>
{
    return reduce_by_key_config_picker<
        comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
        key_type,
        value_type>();
}

// All the existing configs should be auto generated
using reduce_by_key_targets
    = comp_targets<comp_target<gen::rdna2, target_arch::gfx1030, gpu::rx6900, rep::amdgcn>,
                   comp_target<gen::rdna3, target_arch::gfx1100, gpu::rx7900, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1200, gpu::rx9060, rep::amdgcn>,
                   comp_target<gen::rdna4, target_arch::gfx1201, gpu::rx9070, rep::amdgcn>,
                   comp_target<gen::gcn5, target_arch::gfx906, gpu::mi50, rep::amdgcn>,
                   comp_target<gen::cdna1, target_arch::gfx908, gpu::mi100, rep::amdgcn>,
                   comp_target<gen::cdna2, target_arch::gfx90a, gpu::mi210, rep::amdgcn>,
                   comp_target<gen::cdna3, target_arch::gfx942, gpu::mi300x, rep::amdgcn>,
                   comp_target<gen::unknown, target_arch::unknown, gpu::generic, rep::amdgcn>>;

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_REDUCE_BY_KEY_HPP_
